/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.online.metadata;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import org.serviio.delivery.DeliveryContext;
import org.serviio.library.entities.Image;
import org.serviio.library.entities.MediaItem;
import org.serviio.library.entities.MusicTrack;
import org.serviio.library.entities.Video;
import org.serviio.library.local.metadata.ImageDescriptor;
import org.serviio.library.local.metadata.MPAARating;
import org.serviio.library.metadata.InvalidMetadataException;
import org.serviio.library.metadata.ItemMetadata;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.library.online.OnlineItemId;
import org.serviio.library.online.metadata.TechnicalMetadata;
import org.serviio.util.FileUtils;
import org.serviio.util.HttpUtils;
import org.serviio.util.ObjectValidator;
import org.serviio.util.StringUtils;

public abstract class OnlineItem
extends ItemMetadata {
    private OnlineItemId id;
    private ImageDescriptor thumbnail;
    private String contentUrl;
    private MediaFileType type;
    private TechnicalMetadata technicalMD = new TechnicalMetadata();
    private String cacheKey;
    private boolean validEssence = true;
    private boolean live = false;
    private String userAgent;

    @Override
    public void validateMetadata() throws InvalidMetadataException {
        super.validateMetadata();
        if (this.contentUrl == null) {
            throw new InvalidMetadataException("Unknown feed entry URL.");
        }
        if (this.type == null) {
            throw new InvalidMetadataException("Unknown feed entry type.");
        }
    }

    @Override
    public void fillInUnknownEntries() {
        if (ObjectValidator.isEmpty(this.author)) {
            this.setAuthor("Unknown");
        }
        if (ObjectValidator.isEmpty(this.title)) {
            this.setTitle("Unknown");
        }
        if (this.date == null) {
            this.setDate(new Date());
        }
        if (ObjectValidator.isEmpty(this.cacheKey)) {
            this.setCacheKey(this.contentUrl);
        }
    }

    public String getDisplayTitle(String repositoryName) {
        if (ObjectValidator.isNotEmpty(repositoryName)) {
            return repositoryName;
        }
        return this.getTitle();
    }

    public MediaItem toMediaItem() {
        DeliveryContext deliveryContext = new DeliveryContext(false, this.userAgent);
        if (this.type == MediaFileType.IMAGE) {
            Image image = new Image(this.title, this.technicalMD.getImageContainer(), this.contentUrl, this.contentUrl, this.technicalMD.getFileSize(), null, null, this.date);
            image.setHeight(this.technicalMD.getHeight());
            image.setWidth(this.technicalMD.getWidth());
            image.setId(this.getId());
            image.setLive(false);
            if (this.getThumbnail() != null) {
                image.setThumbnailId(image.getId());
            }
            image.setChromaSubsampling(this.technicalMD.getChromaSubsampling());
            image.setDeliveryContext(deliveryContext);
            return image;
        }
        if (this.type == MediaFileType.AUDIO) {
            MusicTrack track = new MusicTrack(this.title, this.technicalMD.getAudioContainer(), this.contentUrl, this.contentUrl, this.technicalMD.getFileSize(), null, null, this.date);
            track.setId(this.getId());
            if (this.getThumbnail() != null) {
                track.setThumbnailId(track.getId());
            }
            track.setBitrate(this.technicalMD.getBitrate());
            track.setDuration(this.technicalMD.getDuration() != null ? Integer.valueOf(this.technicalMD.getDuration().intValue()) : null);
            track.setSampleFrequency(this.technicalMD.getSamplingRate() != null ? Integer.valueOf(this.technicalMD.getSamplingRate()) : null);
            track.setChannels(this.technicalMD.getChannels());
            track.setLive(this.live);
            track.setDeliveryContext(deliveryContext);
            return track;
        }
        if (this.type == MediaFileType.VIDEO) {
            Video video = new Video(this.title, this.technicalMD.getVideoContainer(), this.contentUrl, this.contentUrl, this.technicalMD.getFileSize(), null, null, this.date);
            video.setId(this.getId());
            if (this.getThumbnail() != null) {
                video.setThumbnailId(video.getId());
            }
            video.setAudioBitrate(this.technicalMD.getAudioBitrate());
            video.setAudioCodec(this.technicalMD.getAudioCodec());
            video.setAudioStreamIndex(this.technicalMD.getAudioStreamIndex());
            video.setBitrate(this.technicalMD.getBitrate());
            video.setChannels(this.technicalMD.getChannels());
            video.setDuration(this.technicalMD.getDuration() != null ? Integer.valueOf(this.technicalMD.getDuration().intValue()) : null);
            video.setFps(this.technicalMD.getFps());
            video.setFrequency(this.technicalMD.getSamplingRate());
            video.setHeight(this.technicalMD.getHeight());
            video.setVideoCodec(this.technicalMD.getVideoCodec());
            video.setVideoStreamIndex(this.technicalMD.getVideoStreamIndex());
            video.setWidth(this.technicalMD.getWidth());
            video.setFtyp(this.technicalMD.getFtyp());
            video.setH264Levels(this.technicalMD.getH264Levels());
            video.setH264Profile(this.technicalMD.getH264Profile());
            video.setSar(this.technicalMD.getSar());
            video.setLive(this.live);
            video.setDeliveryContext(deliveryContext);
            video.setRating(MPAARating.UNKNOWN);
            return video;
        }
        return null;
    }

    public void setMediaType(String mimeType, String contentUrl) {
        String normalizedMimeType = StringUtils.localeSafeToLowercase(mimeType);
        String extension = null;
        try {
            extension = StringUtils.localeSafeToLowercase(FileUtils.getFileExtension(new URL(contentUrl)));
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        this.type = MediaFileType.findMediaFileTypeByMimeType(normalizedMimeType);
        if (this.type == null && extension != null) {
            this.type = MediaFileType.findMediaFileTypeByExtension(extension);
        }
    }

    public boolean isCompletelyLoaded() {
        if (this.type == MediaFileType.IMAGE) {
            return this.technicalMD != null && this.technicalMD.getFileSize() != null && this.technicalMD.getImageContainer() != null;
        }
        if (this.type == MediaFileType.AUDIO) {
            return HttpUtils.isHttpUrl(this.contentUrl) && !this.live ? this.technicalMD != null && this.technicalMD.getFileSize() != null && this.technicalMD.getAudioContainer() != null : this.technicalMD != null && this.technicalMD.getAudioContainer() != null;
        }
        if (this.type == MediaFileType.VIDEO) {
            return HttpUtils.isHttpUrl(this.contentUrl) && !this.live ? this.technicalMD != null && this.technicalMD.getFileSize() != null && this.technicalMD.getVideoContainer() != null : this.technicalMD != null && this.technicalMD.getVideoContainer() != null;
        }
        return false;
    }

    public DeliveryContext deliveryContext() {
        return new DeliveryContext(false, this.userAgent);
    }

    protected abstract OnlineItemId generateId();

    protected void resetId() {
        this.id = null;
    }

    public Long getId() {
        if (this.id == null) {
            this.id = this.generateId();
        }
        return this.id.value();
    }

    public ImageDescriptor getThumbnail() {
        return this.thumbnail;
    }

    public void setThumbnail(ImageDescriptor thumbnail) {
        this.thumbnail = thumbnail;
    }

    public String getContentUrl() {
        return this.contentUrl;
    }

    public void setContentUrl(String contentUrl) {
        this.contentUrl = contentUrl;
    }

    public MediaFileType getType() {
        return this.type;
    }

    public void setType(MediaFileType type) {
        this.type = type;
    }

    public TechnicalMetadata getTechnicalMD() {
        return this.technicalMD;
    }

    public void setTechnicalMD(TechnicalMetadata technicalMD) {
        this.technicalMD = technicalMD;
    }

    public String getCacheKey() {
        return this.cacheKey;
    }

    public void setCacheKey(String cacheKey) {
        this.cacheKey = cacheKey;
    }

    public boolean isValidEssence() {
        return this.validEssence;
    }

    public void setValidEssence(boolean validEssence) {
        this.validEssence = validEssence;
    }

    public boolean isLive() {
        return this.live;
    }

    public void setLive(boolean live) {
        this.live = live;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }
}

