/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.online.metadata;

import java.util.Date;
import org.serviio.library.entities.MediaItem;
import org.serviio.library.local.metadata.ImageDescriptor;
import org.serviio.library.online.AbstractUrlExtractor;
import org.serviio.library.online.ContentURLContainer;
import org.serviio.library.online.OnlineItemId;
import org.serviio.library.online.metadata.OnlineItem;
import org.serviio.library.online.metadata.OnlineResourceContainer;

public abstract class OnlineContainerItem<C extends OnlineResourceContainer<?, ?>>
extends OnlineItem {
    protected int order;
    protected C parentContainer;
    protected Date expiresOn;
    protected boolean expiresImmediately = false;
    protected AbstractUrlExtractor plugin;

    @Override
    protected OnlineItemId generateId() {
        return new OnlineItemId(((OnlineResourceContainer)this.parentContainer).getOnlineRepositoryId(), this.order);
    }

    protected void setPluginOnMediaItem(MediaItem mediaItem) {
        if (this.expiresImmediately) {
            mediaItem.setOnlineResourcePlugin(this.plugin);
            mediaItem.setOnlineItem(this);
        }
    }

    @Override
    public MediaItem toMediaItem() {
        MediaItem item = super.toMediaItem();
        if (item != null) {
            this.setPluginOnMediaItem(item);
        }
        return item;
    }

    public void applyContentUrlContainer(ContentURLContainer extractedUrl, AbstractUrlExtractor urlExtractor) {
        if (extractedUrl != null) {
            this.setContentUrl(extractedUrl.getContentUrl());
            this.setExpiresOn(extractedUrl.getExpiresOn());
            this.setExpiresImmediately(extractedUrl.isExpiresImmediately());
            this.setCacheKey(extractedUrl.getCacheKey());
            this.setLive(extractedUrl.isLive());
            this.setType(extractedUrl.getFileType());
            this.setUserAgent(extractedUrl.getUserAgent());
            if (extractedUrl.getThumbnailUrl() != null) {
                this.setThumbnail(new ImageDescriptor(extractedUrl.getThumbnailUrl()));
            }
            this.setPlugin(urlExtractor);
        }
    }

    @Override
    public ImageDescriptor getThumbnail() {
        ImageDescriptor thumbnail = super.getThumbnail();
        return thumbnail != null ? thumbnail : ((OnlineResourceContainer)this.parentContainer).getThumbnail();
    }

    public Date getExpiresOn() {
        return this.expiresOn;
    }

    public void setExpiresOn(Date expiresIn) {
        this.expiresOn = expiresIn;
    }

    public boolean isExpiresImmediately() {
        return this.expiresImmediately;
    }

    public void setExpiresImmediately(boolean expiresImmediately) {
        this.expiresImmediately = expiresImmediately;
    }

    public AbstractUrlExtractor getPlugin() {
        return this.plugin;
    }

    public void setPlugin(AbstractUrlExtractor plugin) {
        this.plugin = plugin;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
        this.resetId();
    }
}

