/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.online.metadata;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.serviio.library.entities.OnlineRepository;
import org.serviio.library.local.metadata.AudioMetadata;
import org.serviio.library.local.metadata.ImageMetadata;
import org.serviio.library.local.metadata.LocalItemMetadata;
import org.serviio.library.local.metadata.VideoMetadata;
import org.serviio.library.local.metadata.extractor.InvalidMediaFormatException;
import org.serviio.library.local.service.SearchService;
import org.serviio.library.metadata.AbstractLibraryCheckerThread;
import org.serviio.library.metadata.FFmpegMetadataRetriever;
import org.serviio.library.metadata.ImageMetadataRetriever;
import org.serviio.library.metadata.ItemMetadata;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.library.online.AbstractUrlExtractor;
import org.serviio.library.online.CannotRetrieveThumbnailException;
import org.serviio.library.online.ContentURLContainer;
import org.serviio.library.online.OnlineLibraryManager;
import org.serviio.library.online.metadata.MissingPluginException;
import org.serviio.library.online.metadata.OnlineContainerItem;
import org.serviio.library.online.metadata.OnlineItem;
import org.serviio.library.online.metadata.OnlineResourceContainer;
import org.serviio.library.online.metadata.OnlineResourceParseException;
import org.serviio.library.online.metadata.SingleURLItem;
import org.serviio.library.online.metadata.TechnicalMetadata;
import org.serviio.library.online.service.OnlineRepositoryService;
import org.serviio.util.HttpClient;
import org.serviio.util.Tupple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeedUpdaterThread
extends AbstractLibraryCheckerThread {
    private static final Logger log = LoggerFactory.getLogger(FeedUpdaterThread.class);
    private static final int FEED_UPDATER_CHECK_INTERVAL = 1;
    private static final int FEER_PARSE_RETRY_COUNT = 2;
    private final OnlineLibraryManager onlineManager;
    private Map<Long, Integer> retryCounter = new HashMap<Long, Integer>();

    public FeedUpdaterThread(OnlineLibraryManager onlineManager) {
        this.onlineManager = onlineManager;
    }

    @Override
    public void run() {
        log.info("Started looking for information about online resources");
        this.workerRunning = true;
        while (this.workerRunning) {
            log.debug("Checking for new and expired online resources");
            this.searchingForFiles = true;
            List<OnlineRepository> repositories = OnlineRepositoryService.getAllRepositories();
            for (OnlineRepository repository : repositories) {
                try {
                    if (!this.workerRunning || !repository.isEnabled() || OnlineRepositoryService.getRepository(repository.getId()) == null) continue;
                    Tupple<OnlineResourceContainer<?, ?>, List<OnlineItem>> parsedResource = this.getOnlineItems(repository);
                    Iterator<? extends OnlineItem> it = parsedResource.getValueB().iterator();
                    this.feedParsedSuccessfully(repository.getId());
                    while (this.workerRunning && it.hasNext()) {
                        OnlineItem feedItem = it.next();
                        try {
                            boolean updated = false;
                            if (this.workerRunning) {
                                updated = this.retrieveTechnicalMetadata(feedItem);
                            }
                            if (this.workerRunning) {
                                try {
                                    this.onlineManager.findThumbnail(feedItem.getThumbnail(), feedItem.getUserAgent());
                                }
                                catch (CannotRetrieveThumbnailException e) {
                                    log.warn("An error occured while retrieving thumbnail, will remove it from the item and will continue", (Throwable)e);
                                    feedItem.setThumbnail(null);
                                }
                            }
                            SearchService.makeOnlineSearchable(feedItem, parsedResource.getValueA(), repository);
                            if (!updated) continue;
                            this.notifyListenersUpdate(feedItem.getType(), "Online item");
                        }
                        catch (IOException e) {
                            log.warn(String.format("Failed to retrieve online item information for %s. It might not play.", feedItem.getContentUrl().toString()), (Throwable)e);
                        }
                        catch (Exception e) {
                            log.warn("An error occured while scanning for online item information, will remove the item from the feed and will continue", (Throwable)e);
                            it.remove();
                        }
                    }
                }
                catch (MissingPluginException e) {
                    log.warn(String.format("An error occured while trying to parse an online resouce requiring a plugin, provide the plugin or remove the resource: %s", e.getMessage()));
                }
                catch (OnlineResourceParseException e) {
                    boolean retry = this.retryFeedParsing(repository.getId());
                    if (retry) {
                        log.warn(String.format("An error occured while parsing the online resource %s, will try again soon: %s", repository.getRepositoryUrl().toString(), e.getMessage()), (Throwable)e);
                        continue;
                    }
                    log.warn(String.format("An error occured while parsing the online resource %s, waiting for expiry time to try again: %s", repository.getRepositoryUrl().toString(), e.getMessage()), (Throwable)e);
                    this.onlineManager.storeExpiryDateForFailedResource(repository.getRepositoryUrl(), repository.getId());
                }
                catch (Exception e) {
                    log.warn("An unexpected error occured while parsing the online resource, will continue", (Throwable)e);
                }
            }
            this.searchingForFiles = false;
            try {
                if (this.workerRunning && !this.dontSleep) {
                    this.isSleeping = true;
                    Thread.sleep(60000L);
                    this.isSleeping = false;
                    continue;
                }
                this.dontSleep = false;
            }
            catch (InterruptedException e) {
                this.dontSleep = false;
                this.isSleeping = false;
            }
        }
        log.info("Finished looking for online resources information");
    }

    private Tupple<OnlineResourceContainer<?, ?>, List<? extends OnlineItem>> getOnlineItems(OnlineRepository repository) throws MissingPluginException, OnlineResourceParseException {
        if (repository.getRepoType() == OnlineRepository.OnlineRepositoryType.FEED || repository.getRepoType() == OnlineRepository.OnlineRepositoryType.WEB_RESOURCE) {
            OnlineResourceContainer<?, ?> resource = this.onlineManager.findResourceInCacheOrParse(repository);
            ArrayList items = resource != null ? resource.getItems() : new ArrayList();
            return new Tupple(resource, items);
        }
        SingleURLItem item = this.onlineManager.findSingleURLItemInCacheOrParse(repository);
        List<Object> items = item == null ? new ArrayList() : Collections.singletonList(item);
        return new Tupple(null, items);
    }

    private boolean retrieveTechnicalMetadata(OnlineItem onlineItem) throws IOException {
        boolean updated = false;
        if (!onlineItem.isCompletelyLoaded() && onlineItem.isValidEssence()) {
            TechnicalMetadata existingMetadata = this.onlineManager.findTechnicalMetadata(onlineItem.getCacheKey());
            if (existingMetadata != null) {
                onlineItem.setTechnicalMD(existingMetadata.clone());
                updated = true;
            } else {
                LocalItemMetadata md;
                if (onlineItem.getTechnicalMD().getFileSize() == null && !onlineItem.isLive()) {
                    try {
                        URL contentUrl = new URL(onlineItem.getContentUrl());
                        log.debug("Retrieving file size from the URL connection");
                        onlineItem.getTechnicalMD().setFileSize(new Long(HttpClient.getContentSize(contentUrl).intValue()));
                        updated = true;
                    }
                    catch (MalformedURLException e) {
                        // empty catch block
                    }
                }
                if (onlineItem.getType() == MediaFileType.VIDEO) {
                    md = new VideoMetadata();
                    log.debug(String.format("Retrieving information about the video stream '%s'", onlineItem.getTitle()));
                    this.retrieveMetadata(md, onlineItem);
                    onlineItem.getTechnicalMD().setAudioBitrate(((VideoMetadata)md).getAudioBitrate());
                    onlineItem.getTechnicalMD().setAudioCodec(((VideoMetadata)md).getAudioCodec());
                    onlineItem.getTechnicalMD().setAudioStreamIndex(((VideoMetadata)md).getAudioStreamIndex());
                    onlineItem.getTechnicalMD().setBitrate(((VideoMetadata)md).getBitrate());
                    onlineItem.getTechnicalMD().setChannels(((VideoMetadata)md).getChannels());
                    if (!onlineItem.isLive() && onlineItem.getTechnicalMD().getDuration() == null && ((VideoMetadata)md).getDuration() != null) {
                        onlineItem.getTechnicalMD().setDuration(new Long(((VideoMetadata)md).getDuration().intValue()));
                    }
                    onlineItem.getTechnicalMD().setFps(((VideoMetadata)md).getFps());
                    onlineItem.getTechnicalMD().setHeight(((VideoMetadata)md).getHeight());
                    onlineItem.getTechnicalMD().setSamplingRate(((VideoMetadata)md).getFrequency());
                    onlineItem.getTechnicalMD().setVideoBitrate(((VideoMetadata)md).getVideoBitrate());
                    onlineItem.getTechnicalMD().setVideoCodec(((VideoMetadata)md).getVideoCodec());
                    onlineItem.getTechnicalMD().setVideoContainer(((VideoMetadata)md).getContainer());
                    onlineItem.getTechnicalMD().setVideoStreamIndex(((VideoMetadata)md).getVideoStreamIndex());
                    onlineItem.getTechnicalMD().setWidth(((VideoMetadata)md).getWidth());
                    onlineItem.getTechnicalMD().setFtyp(((VideoMetadata)md).getFtyp());
                    onlineItem.getTechnicalMD().setH264Levels(((VideoMetadata)md).getH264Levels());
                    onlineItem.getTechnicalMD().setH264Profile(((VideoMetadata)md).getH264Profile());
                    onlineItem.getTechnicalMD().setSar(((VideoMetadata)md).getSar());
                    this.storeTechnicalMetadataToCache(onlineItem);
                    updated = true;
                } else if (onlineItem.getType() == MediaFileType.AUDIO) {
                    md = new AudioMetadata();
                    log.debug("Retrieving information about the audio stream");
                    this.retrieveMetadata(md, onlineItem);
                    onlineItem.getTechnicalMD().setAudioContainer(((AudioMetadata)md).getContainer());
                    onlineItem.getTechnicalMD().setBitrate(((AudioMetadata)md).getBitrate());
                    if (!onlineItem.isLive() && onlineItem.getTechnicalMD().getDuration() == null && ((AudioMetadata)md).getDuration() != null) {
                        onlineItem.getTechnicalMD().setDuration(new Long(((AudioMetadata)md).getDuration().intValue()));
                    }
                    onlineItem.getTechnicalMD().setSamplingRate(((AudioMetadata)md).getSampleFrequency());
                    onlineItem.getTechnicalMD().setChannels(((AudioMetadata)md).getChannels());
                    this.storeTechnicalMetadataToCache(onlineItem);
                    updated = true;
                } else if (onlineItem.getType() == MediaFileType.IMAGE) {
                    md = new ImageMetadata();
                    log.debug("Retrieving information about the online image");
                    this.retrieveMetadata(md, onlineItem);
                    onlineItem.getTechnicalMD().setImageContainer(((ImageMetadata)md).getContainer());
                    onlineItem.getTechnicalMD().setWidth(((ImageMetadata)md).getWidth());
                    onlineItem.getTechnicalMD().setHeight(((ImageMetadata)md).getHeight());
                    onlineItem.getTechnicalMD().setChromaSubsampling(((ImageMetadata)md).getChromaSubsampling());
                    this.storeTechnicalMetadataToCache(onlineItem);
                    updated = true;
                }
            }
        } else if (!onlineItem.isCompletelyLoaded() && !onlineItem.isValidEssence()) {
            log.debug(String.format("Skipping retrieving technical metadata for item %s, because its essence is invalid.", onlineItem.getTitle()));
        }
        return updated;
    }

    private void retrieveMetadata(ItemMetadata md, OnlineItem onlineItem) throws IOException {
        boolean run = true;
        int counter = 0;
        while (run) {
            try {
                if (md instanceof ImageMetadata) {
                    ImageMetadataRetriever.retrieveImageMetadata((ImageMetadata)md, onlineItem.getContentUrl(), false);
                } else {
                    FFmpegMetadataRetriever.retrieveOnlineMetadata(md, onlineItem.getContentUrl(), onlineItem.deliveryContext());
                }
                run = false;
            }
            catch (InvalidMediaFormatException e) {
                if (onlineItem instanceof OnlineContainerItem && ((OnlineContainerItem)onlineItem).isExpiresImmediately() && counter == 0) {
                    OnlineContainerItem containerItem = (OnlineContainerItem)onlineItem;
                    ++counter;
                    log.debug("Cannot get information about the URL, it might have expired already. Trying again.");
                    try {
                        ContentURLContainer container = AbstractUrlExtractor.extractItemUrl(containerItem.getPlugin(), containerItem);
                        if (container == null) continue;
                        containerItem.applyContentUrlContainer(container, containerItem.getPlugin());
                    }
                    catch (Throwable t) {
                        log.debug(String.format("Unexpected error during url extractor plugin invocation (%s) for item %s: %s", containerItem.getPlugin().getExtractorName(), containerItem.getTitle(), t.getMessage()), (Throwable)e);
                        this.markOnlineItemAsInvalidEssence(onlineItem);
                    }
                    continue;
                }
                this.markOnlineItemAsInvalidEssence(onlineItem);
                throw new IOException(e);
            }
        }
    }

    private void markOnlineItemAsInvalidEssence(OnlineItem onlineItem) {
        log.debug(String.format("Marking online item %s as 'invalid essence'", onlineItem.getTitle()));
        onlineItem.setValidEssence(false);
    }

    private void storeTechnicalMetadataToCache(OnlineItem onlineItem) {
        this.onlineManager.storeTechnicalMetadata(onlineItem.getCacheKey(), onlineItem.getTechnicalMD().clone());
    }

    private boolean retryFeedParsing(Long repositoryId) {
        Integer currentRetryCount = this.retryCounter.get(repositoryId);
        if (currentRetryCount == null) {
            this.retryCounter.put(repositoryId, 2);
            return true;
        }
        if (currentRetryCount < 1) {
            return false;
        }
        this.retryCounter.put(repositoryId, currentRetryCount - 1);
        return true;
    }

    private void feedParsedSuccessfully(Long repositoryId) {
        this.retryCounter.remove(repositoryId);
    }
}

