/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.online.feed.module.itunes;

import com.sun.syndication.feed.module.Module;
import com.sun.syndication.io.ModuleParser;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;
import org.serviio.library.online.feed.module.itunes.ITunesRssModuleImpl;
import org.serviio.library.online.feed.module.itunes.Image;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ITunesRssModuleParser
implements ModuleParser {
    private static final Logger log = LoggerFactory.getLogger(ITunesRssModuleParser.class);
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.UK);
    private static final Namespace NS = Namespace.getNamespace((String)"http://itunes.apple.com/rss");
    private static final Namespace ATOM_NS = Namespace.getNamespace((String)"http://www.w3.org/2005/Atom");

    public String getNamespaceUri() {
        return "http://itunes.apple.com/rss";
    }

    public Module parse(Element element) {
        ITunesRssModuleImpl module = new ITunesRssModuleImpl();
        Element name = element.getChild("name", NS);
        Element releaseDate = element.getChild("releaseDate", NS);
        Element artist = element.getChild("artist", NS);
        List images = element.getChildren("image", NS);
        List links = element.getChildren("link", ATOM_NS);
        if (name != null) {
            module.setName(name.getTextTrim());
        }
        if (releaseDate != null) {
            try {
                module.setReleaseDate(DATE_FORMAT.parse(releaseDate.getTextTrim()));
            }
            catch (ParseException e) {
                log.debug("Cannot parse release date: " + e.getMessage());
            }
        }
        if (artist != null) {
            module.setArtist(artist.getTextTrim());
        }
        if (images != null && images.size() > 0) {
            for (Element imageEl : images) {
                Attribute width = imageEl.getAttribute("width");
                Attribute height = imageEl.getAttribute("height");
                try {
                    Image image = new Image(new URL(imageEl.getTextTrim()), width != null ? new Integer(width.getValue()) : null, height != null ? new Integer(height.getValue()) : null);
                    module.getImages().add(image);
                }
                catch (MalformedURLException e) {
                    log.debug("Invalid image URL: " + e.getMessage());
                }
            }
        }
        if (links != null && links.size() > 0) {
            for (Element linkEl : links) {
                Element duration = linkEl.getChild("duration", NS);
                if (duration == null) continue;
                module.setDuration(new Integer(duration.getTextTrim()));
                break;
            }
        }
        return module;
    }

    static {
        DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

