/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.online.feed;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.codehaus.groovy.control.CompilationFailedException;
import org.serviio.ApplicationSettings;
import org.serviio.library.entities.OnlineRepository;
import org.serviio.library.online.AbstractUrlExtractor;
import org.serviio.library.online.FeedItemUrlExtractor;
import org.serviio.library.online.OnlineLibraryManager;
import org.serviio.library.online.WebResourceUrlExtractor;
import org.serviio.util.FileUtils;
import org.serviio.util.ObjectValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginCompilerThread
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(PluginCompilerThread.class);
    private static final int PLUGIN_COMPILER_CHECK_INTERVAL = 10;
    private File pluginsFolder;
    protected final Map<AbstractUrlExtractor, OnlineRepository.OnlineRepositoryType> urlExtractors = new HashMap<AbstractUrlExtractor, OnlineRepository.OnlineRepositoryType>();
    private Map<File, Date> seenFilesCache = new HashMap<File, Date>();
    private GroovyClassLoader gcl = new GroovyClassLoader();
    private boolean workerRunning;
    private boolean isSleeping = false;
    private final boolean checkPeriodically = this.checkForPluginsPeriodically();
    private final CountDownLatch pluginsCompiled;

    public PluginCompilerThread(CountDownLatch pluginsCompiled) {
        this.pluginsFolder = this.getPluginsDirectoryPath();
        this.pluginsCompiled = pluginsCompiled;
    }

    @Override
    public void run() {
        if (this.pluginsFolder != null && this.pluginsFolder.isDirectory()) {
            log.info("Started looking for plugins");
            this.workerRunning = true;
            while (this.workerRunning) {
                this.searchForPlugins();
                if (!this.checkPeriodically) {
                    this.workerRunning = false;
                }
                try {
                    if (this.workerRunning) {
                        this.isSleeping = true;
                        Thread.sleep(10000L);
                        this.isSleeping = false;
                    }
                }
                catch (InterruptedException e) {
                    this.isSleeping = false;
                }
                this.pluginsCompiled.countDown();
            }
            log.info("Finished looking for plugins");
        } else {
            log.warn(String.format("Plugins folder '%s' does not exist. No plugins will be compiled.", this.pluginsFolder));
        }
    }

    public void stopWorker() {
        this.workerRunning = false;
        if (this.isSleeping) {
            this.interrupt();
        }
    }

    public boolean isWorkerRunning() {
        return this.workerRunning;
    }

    private boolean checkForPluginsPeriodically() {
        if (ObjectValidator.isEmpty(System.getProperty("plugins.check"))) {
            return true;
        }
        return Boolean.parseBoolean(System.getProperty("plugins.check"));
    }

    private File getPluginsDirectoryPath() {
        String pluginFolderName = ApplicationSettings.getStringProperty("plugins_directory");
        File pluginFolder = new File(System.getProperty("serviio.home"), pluginFolderName);
        if (!ObjectValidator.isEmpty(System.getProperty("plugins.location"))) {
            pluginFolder = new File(System.getProperty("plugins.location"), pluginFolderName);
        }
        log.info(String.format("Looking for plugins at %s", pluginFolder.getPath()));
        return pluginFolder;
    }

    private void searchForPlugins() {
        File[] foundPlugins;
        for (File pluginFile : foundPlugins = this.pluginsFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".groovy");
            }
        })) {
            if (this.seenFilesCache.containsKey(pluginFile) && !FileUtils.getLastModifiedDate(pluginFile).after(this.seenFilesCache.get(pluginFile))) continue;
            this.compilePluginFile(pluginFile);
        }
    }

    protected void compilePluginFile(File pluginFile) {
        try {
            log.debug(String.format("Starting plugin %s compilation", pluginFile.getName()));
            Class pluginClass = this.gcl.parseClass(new GroovyCodeSource(pluginFile), false);
            if (AbstractUrlExtractor.class.isAssignableFrom(pluginClass)) {
                boolean feedPlugin = true;
                AbstractUrlExtractor pluginInstance = (AbstractUrlExtractor)pluginClass.newInstance();
                if (FeedItemUrlExtractor.class.isAssignableFrom(pluginClass)) {
                    this.storePluginInCache(pluginInstance, OnlineRepository.OnlineRepositoryType.FEED);
                } else if (WebResourceUrlExtractor.class.isAssignableFrom(pluginClass)) {
                    this.storePluginInCache(pluginInstance, OnlineRepository.OnlineRepositoryType.WEB_RESOURCE);
                    feedPlugin = false;
                } else {
                    log.warn("Unsupported plugin class");
                    return;
                }
                this.seenFilesCache.put(pluginFile, FileUtils.getLastModifiedDate(pluginFile));
                OnlineLibraryManager.getInstance().removeFeedFromCache(pluginInstance);
                log.info(String.format("Added %s plugin %s (%s), version: %d", feedPlugin ? "Feed" : "Web Resouce", pluginInstance.getExtractorName(), pluginFile.getName(), pluginInstance.getVersion()));
            } else {
                log.warn(String.format("Groovy class %s (%s) doesn't extend %s, it will not be used", pluginClass.getName(), pluginFile.getName(), FeedItemUrlExtractor.class.getName()));
            }
        }
        catch (CompilationFailedException e) {
            log.warn(String.format("Plugin %s failed to compile: %s", pluginFile.getName(), e.getMessage()));
        }
        catch (IOException e) {
            log.warn(String.format("Plugin %s failed to load: %s", pluginFile.getName(), e.getMessage()));
        }
        catch (Exception e) {
            log.warn(String.format("Unexpected error during adding plugin %s: %s", pluginFile.getName(), e.getMessage()), (Throwable)e);
        }
    }

    private synchronized void storePluginInCache(AbstractUrlExtractor plugin, OnlineRepository.OnlineRepositoryType type) {
        if (this.urlExtractors.containsKey(plugin)) {
            this.urlExtractors.remove(plugin);
        }
        this.urlExtractors.put(plugin, type);
    }

    public Map<AbstractUrlExtractor, OnlineRepository.OnlineRepositoryType> getUrlExtractors() {
        return Collections.unmodifiableMap(this.urlExtractors);
    }
}

