/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.online.feed;

import com.sun.syndication.feed.module.mediarss.MediaEntryModule;
import com.sun.syndication.feed.module.mediarss.types.MediaContent;
import com.sun.syndication.feed.module.mediarss.types.MediaGroup;
import com.sun.syndication.feed.module.mediarss.types.Metadata;
import com.sun.syndication.feed.module.mediarss.types.Thumbnail;
import com.sun.syndication.feed.module.mediarss.types.UrlReference;
import com.sun.syndication.feed.synd.SyndEntry;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Comparator;
import org.serviio.config.Configuration;
import org.serviio.library.local.metadata.ImageDescriptor;
import org.serviio.library.online.PreferredQuality;
import org.serviio.library.online.feed.FeedEntryParser;
import org.serviio.library.online.metadata.FeedItem;
import org.serviio.util.ObjectValidator;
import org.serviio.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaFeedEntryParser
implements FeedEntryParser {
    private static final Logger log = LoggerFactory.getLogger(MediaFeedEntryParser.class);

    @Override
    public void parseFeedEntry(SyndEntry entry, FeedItem item) {
        MediaEntryModule module = (MediaEntryModule)entry.getModule("http://search.yahoo.com/mrss/");
        if (module != null) {
            Metadata md = this.findMetadata(module);
            MediaContent con = this.findContents(module);
            if (ObjectValidator.isNotEmpty(md.getTitle()) && ObjectValidator.isEmpty(item.getTitle())) {
                item.setTitle(StringUtils.trim(md.getTitle()));
            }
            if (md.getCredits() != null && md.getCredits().length > 0 && ObjectValidator.isEmpty(item.getAuthor())) {
                item.setAuthor(md.getCredits()[0].getName());
            }
            this.setThumbnail(con, md, item);
            this.setContentData(con, item);
        }
    }

    private Metadata findMetadata(MediaEntryModule module) {
        if (module.getMediaGroups() != null && module.getMediaGroups().length > 0) {
            return module.getMediaGroups()[0].getMetadata();
        }
        return module.getMetadata();
    }

    private MediaContent findContents(MediaEntryModule module) {
        MediaContent[] availableContents = null;
        if (module.getMediaGroups() != null && module.getMediaGroups().length > 0) {
            MediaGroup mg = module.getMediaGroups()[0];
            if (mg.getContents() != null && mg.getContents().length > 0) {
                if (mg.getDefaultContentIndex() != null) {
                    return mg.getContents()[mg.getDefaultContentIndex()];
                }
                availableContents = mg.getContents();
            }
        } else if (module.getMediaContents() != null && module.getMediaContents().length > 0) {
            availableContents = module.getMediaContents();
        }
        if (availableContents != null) {
            MediaContent content = this.findDefaultMediaContent(availableContents);
            if (content == null) {
                MediaContent[] sortedContent = (MediaContent[])availableContents.clone();
                Arrays.sort(sortedContent, new MediaContentComparator());
                PreferredQuality prefQuality = Configuration.getOnlineFeedPreferredQuality();
                if (prefQuality == PreferredQuality.HIGH) {
                    return sortedContent[sortedContent.length - 1];
                }
                if (prefQuality == PreferredQuality.LOW) {
                    return sortedContent[0];
                }
                return sortedContent[sortedContent.length / 2];
            }
            return content;
        }
        return null;
    }

    private MediaContent findDefaultMediaContent(MediaContent[] contents) {
        for (MediaContent con : contents) {
            if (!con.isDefaultContent()) continue;
            return con;
        }
        return null;
    }

    private void setThumbnail(MediaContent con, Metadata md, FeedItem item) {
        Thumbnail[] availableThumbnails = null;
        if (md.getThumbnail() != null && md.getThumbnail().length > 0) {
            availableThumbnails = md.getThumbnail();
        } else if (con != null && con.getMetadata() != null) {
            availableThumbnails = con.getMetadata().getThumbnail();
        }
        if (availableThumbnails != null && availableThumbnails.length > 0) {
            Thumbnail selectedThumbnail = availableThumbnails[0];
            for (Thumbnail t : availableThumbnails) {
                if (t.getWidth() == null || t.getHeight() == null || t.getWidth() > 160 || t.getHeight() > 160) continue;
                selectedThumbnail = t;
            }
            try {
                ImageDescriptor thumbnail = new ImageDescriptor(selectedThumbnail.getUrl().toURL());
                thumbnail.setWidth(selectedThumbnail.getWidth());
                thumbnail.setHeight(selectedThumbnail.getHeight());
                item.setThumbnail(thumbnail);
            }
            catch (MalformedURLException e) {
                log.warn(String.format("Malformed url of a media feed thumbnail (%s), skipping this thumbnail", selectedThumbnail.getUrl().toString()));
            }
        }
    }

    private void setContentData(MediaContent con, FeedItem item) {
        if (con != null && con.getReference() != null && con.getReference() instanceof UrlReference) {
            String contentUrl = ((UrlReference)con.getReference()).getUrl().toString();
            if (item.getContentUrl() == null || item.getContentUrl().equals(contentUrl)) {
                if (item.getType() == null) {
                    item.setMediaType(con.getType(), contentUrl);
                }
                item.setContentUrl(contentUrl);
            }
        }
    }

    private class MediaContentComparator
    implements Comparator<MediaContent> {
        private MediaContentComparator() {
        }

        @Override
        public int compare(MediaContent o1, MediaContent o2) {
            if (o1.getBitrate() != null && o2.getBitrate() != null) {
                return o1.getBitrate().compareTo(o2.getBitrate());
            }
            if (o1.getBitrate() == null) {
                return -1;
            }
            return 1;
        }
    }
}

