/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.online.feed;

import com.sun.syndication.feed.synd.SyndEntry;
import java.util.Collections;
import org.serviio.library.local.metadata.ImageDescriptor;
import org.serviio.library.online.feed.FeedEntryParser;
import org.serviio.library.online.feed.module.itunes.ITunesRssModule;
import org.serviio.library.online.feed.module.itunes.Image;
import org.serviio.library.online.metadata.FeedItem;
import org.serviio.util.ObjectValidator;

public class ITunesRssFeedEntryParser
implements FeedEntryParser {
    @Override
    public void parseFeedEntry(SyndEntry entry, FeedItem item) {
        ITunesRssModule module = (ITunesRssModule)entry.getModule("http://itunes.apple.com/rss");
        if (module != null) {
            if (ObjectValidator.isNotEmpty(module.getArtist())) {
                item.setAuthor(module.getArtist());
            }
            if (module.getReleaseDate() != null) {
                item.setDate(module.getReleaseDate());
            }
            if (module.getDuration() != null) {
                item.getTechnicalMD().setDuration(new Long(module.getDuration() / 1000));
            }
            if (module.getImages() != null && module.getImages().size() > 0) {
                Collections.sort(module.getImages());
                Image selectedThumbnail = module.getImages().get(module.getImages().size() - 1);
                ImageDescriptor thumbnail = new ImageDescriptor(selectedThumbnail.getUrl());
                thumbnail.setWidth(selectedThumbnail.getWidth());
                thumbnail.setHeight(selectedThumbnail.getHeight());
                item.setThumbnail(thumbnail);
            }
        }
    }
}

