/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.online.feed;

import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndImage;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedInput;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.serviio.config.Configuration;
import org.serviio.library.entities.OnlineRepository;
import org.serviio.library.local.metadata.ImageDescriptor;
import org.serviio.library.metadata.InvalidMetadataException;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.library.online.AbstractOnlineItemParser;
import org.serviio.library.online.ContentURLContainer;
import org.serviio.library.online.FeedItemUrlExtractor;
import org.serviio.library.online.feed.BasicFeedEntryParser;
import org.serviio.library.online.feed.FeedEntryParser;
import org.serviio.library.online.feed.ITunesPodcastFeedEntryParser;
import org.serviio.library.online.feed.ITunesRssFeedEntryParser;
import org.serviio.library.online.feed.MediaFeedEntryParser;
import org.serviio.library.online.metadata.Feed;
import org.serviio.library.online.metadata.FeedItem;
import org.serviio.library.online.metadata.OnlineResourceParseException;
import org.serviio.util.HttpClient;
import org.serviio.util.HttpUtils;
import org.serviio.util.ObjectValidator;
import org.serviio.util.StringUtils;
import org.serviio.util.UnicodeReader;
import org.serviio.util.ZipUtils;
import org.xml.sax.InputSource;

public class FeedParser
extends AbstractOnlineItemParser {
    private static final FeedEntryParser[] entryParsers = new FeedEntryParser[]{new BasicFeedEntryParser(), new MediaFeedEntryParser(), new ITunesPodcastFeedEntryParser(), new ITunesRssFeedEntryParser()};
    public static final String DEFAULT_LINK_NAME = "default";
    public static final String THUMBNAIL_LINK_NAME = "thumbnail";

    public Feed parse(URL feedUrl, Long onlineRepositoryId, MediaFileType fileType) throws OnlineResourceParseException {
        this.log.debug(String.format("Parsing feed '%s'", feedUrl));
        Feed feed = new Feed(onlineRepositoryId);
        try {
            String[] credentials = HttpUtils.getCredentialsFormUrl(feedUrl.toString());
            SyndFeed syndfeed = this.parseFeedStream(feedUrl);
            feed.setTitle(StringUtils.trim(syndfeed.getTitle()));
            feed.setDomain(feedUrl.getHost());
            this.setFeedThumbnail(feed, syndfeed);
            List entries = syndfeed.getEntries();
            int maxFeedItemsToRetrieve = Configuration.getMaxNumberOfItemsForOnlineFeeds() != -1 ? Configuration.getMaxNumberOfItemsForOnlineFeeds().intValue() : entries.size();
            FeedItemUrlExtractor suitablePlugin = (FeedItemUrlExtractor)this.findSuitableExtractorPlugin(feedUrl, OnlineRepository.OnlineRepositoryType.FEED);
            feed.setUsedExtractor(suitablePlugin);
            int itemOrder = 1;
            for (int i = 0; i < entries.size() && itemOrder <= maxFeedItemsToRetrieve && this.isAlive; ++i) {
                boolean added = this.addEntryToFeed(feed, feedUrl, fileType, (SyndEntry)entries.get(i), itemOrder, credentials, suitablePlugin);
                if (!added) continue;
                ++itemOrder;
            }
        }
        catch (FeedException e) {
            throw new OnlineResourceParseException(String.format("Error during feed parsing, provided URL probably doesn't point to a valid RSS/Atom feed. Message: %s", e.getMessage()), e);
        }
        catch (IOException e) {
            throw new OnlineResourceParseException(String.format("Error during feed reading. Message: %s", e.getMessage()), e);
        }
        return feed;
    }

    private SyndFeed parseFeedStream(URL feedUrl) throws IOException, FeedException {
        SyndFeedInput input = new SyndFeedInput();
        byte[] feedBytes = HttpClient.retrieveBinaryFileFromURL(feedUrl.toString());
        ByteArrayInputStream feedStream = new ByteArrayInputStream(feedBytes);
        try {
            return input.build(new InputSource(feedStream));
        }
        catch (FeedException e) {
            this.log.debug("Failed feed sample: " + StringUtils.trimWithEllipsis(new String(feedBytes, "UTF-8"), 100));
            try {
                this.log.debug(String.format("Feed failed parsing (%s), trying BOM detection", e.getMessage()));
                ((InputStream)feedStream).reset();
                return input.build((Reader)new UnicodeReader(feedStream, "UTF-8"));
            }
            catch (FeedException e1) {
                try {
                    this.log.debug(String.format("BOM Feed failed parsing (%s), trying unzipping it", e1.getMessage()));
                    ((InputStream)feedStream).reset();
                    InputStream unzipped = ZipUtils.unGzipSingleFile(feedStream);
                    try {
                        return input.build(new InputSource(unzipped));
                    }
                    catch (FeedException e2) {
                        unzipped.reset();
                        return input.build((Reader)new UnicodeReader(unzipped, "UTF-8"));
                    }
                }
                catch (IOException e2) {
                    throw e;
                }
            }
        }
        catch (IllegalArgumentException e) {
            this.log.debug("Failed feed sample: " + StringUtils.trimWithEllipsis(new String(feedBytes, "UTF-8"), 100));
            throw new FeedException(e.getMessage(), (Throwable)e);
        }
    }

    private boolean addEntryToFeed(Feed feed, URL feedUrl, MediaFileType fileType, SyndEntry entry, int order, String[] credentials, FeedItemUrlExtractor suitablePlugin) {
        FeedItem feedItem = new FeedItem(feed, order);
        try {
            for (FeedEntryParser entryParser : entryParsers) {
                entryParser.parseFeedEntry(entry, feedItem);
            }
            if (suitablePlugin != null) {
                try {
                    this.extractContentUrlViaPlugin(suitablePlugin, feedItem);
                }
                catch (Throwable e) {
                    this.log.debug(String.format("Unexpected error during url extractor plugin invocation (%s) for item %s: %s", suitablePlugin.getExtractorName(), feedItem.getTitle(), e.getMessage()), e);
                    return false;
                }
            }
            if (fileType == feedItem.getType()) {
                feedItem.fillInUnknownEntries();
                feedItem.validateMetadata();
                this.alterUrlsWithCredentials(credentials, feedItem);
                this.log.debug(String.format("Added feed item %s: '%s' (%s)", order, feedItem.getTitle(), feedItem.getContentUrl()));
                feed.getItems().add(feedItem);
                return true;
            }
            this.log.debug(String.format("Skipping feed item '%s' because it's not of type %s", new Object[]{feedItem.getTitle(), fileType}));
            return false;
        }
        catch (InvalidMetadataException e) {
            this.log.debug(String.format("Cannot add feed entry of feed %s because of invalid metadata. Message: %s", feed.getTitle(), e.getMessage()));
            return false;
        }
    }

    private void extractContentUrlViaPlugin(FeedItemUrlExtractor urlExtractor, FeedItem feedItem) throws Throwable {
        ContentURLContainer extractedUrl = urlExtractor.extractUrl(feedItem);
        if (extractedUrl != null) {
            feedItem.applyContentUrlContainer(extractedUrl, urlExtractor);
        } else {
            this.log.warn(String.format("Plugin %s returned no value for resource item '%s'", urlExtractor.getExtractorName(), feedItem.getTitle()));
        }
    }

    private void setFeedThumbnail(Feed feed, SyndFeed syndfeed) {
        SyndImage image = syndfeed.getImage();
        if (image != null && ObjectValidator.isNotEmpty(image.getUrl())) {
            try {
                ImageDescriptor thumbnail = new ImageDescriptor(new URL(image.getUrl()));
                feed.setThumbnail(thumbnail);
            }
            catch (MalformedURLException e) {
                this.log.warn(String.format("Malformed url of a feed thumbnail (%s), skipping this thumbnail", image.getUrl()));
            }
        }
    }
}

