/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.online.feed;

import com.sun.syndication.feed.synd.SyndEnclosure;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndLink;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.serviio.library.online.feed.FeedEntryParser;
import org.serviio.library.online.metadata.FeedItem;
import org.serviio.util.ObjectValidator;
import org.serviio.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicFeedEntryParser
implements FeedEntryParser {
    private static final Logger log = LoggerFactory.getLogger(BasicFeedEntryParser.class);

    @Override
    public void parseFeedEntry(SyndEntry entry, FeedItem item) {
        item.setAuthor(entry.getAuthor());
        item.setDate(entry.getPublishedDate());
        item.setTitle(StringUtils.trim(entry.getTitle()));
        this.setEnclosureInfo(entry, item);
        this.setLinks(entry, item);
    }

    private void setEnclosureInfo(SyndEntry entry, FeedItem item) {
        if (entry.getEnclosures() != null && entry.getEnclosures().size() > 0) {
            boolean validEnclosureFound = false;
            for (int i = 0; i < entry.getEnclosures().size() && !validEnclosureFound; ++i) {
                SyndEnclosure en = (SyndEnclosure)entry.getEnclosures().get(i);
                item.setContentUrl(en.getUrl());
                item.getTechnicalMD().setFileSize(en.getLength() != 0L ? Long.valueOf(en.getLength()) : null);
                item.setMediaType(en.getType(), item.getContentUrl());
                if (item.getType() == null) continue;
                validEnclosureFound = true;
            }
        }
    }

    private void setLinks(SyndEntry entry, FeedItem item) {
        List links = entry.getLinks();
        if (links != null && links.size() > 0) {
            for (SyndLink link : links) {
                String key = link.getRel();
                if (ObjectValidator.isEmpty(key)) {
                    key = link.getType();
                }
                if (ObjectValidator.isEmpty(key)) {
                    key = "default";
                }
                this.addLinkToItem(item, link.getHref(), key);
            }
        } else if (ObjectValidator.isNotEmpty(entry.getLink())) {
            this.addLinkToItem(item, entry.getLink(), "default");
        }
    }

    private void addLinkToItem(FeedItem item, String url, String key) {
        try {
            item.getLinks().put(key, new URL(url));
        }
        catch (MalformedURLException e) {
            log.debug(String.format("Invalid link href URL (%s), skipping", url));
        }
    }
}

