/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.online;

import java.net.URL;
import org.serviio.config.Configuration;
import org.serviio.library.online.AbstractUrlExtractor;
import org.serviio.library.online.ContentURLContainer;
import org.serviio.library.online.PluginExecutionProcessor;
import org.serviio.library.online.PreferredQuality;
import org.serviio.library.online.WebResourceContainer;
import org.serviio.library.online.WebResourceItem;

public abstract class WebResourceUrlExtractor
extends AbstractUrlExtractor {
    public final WebResourceContainer parseWebResource(final URL resourceUrl, final int maxItemsToRetrieve) throws Throwable {
        this.log("Starting parsing resource: " + resourceUrl);
        return (WebResourceContainer)new PluginExecutionProcessor<WebResourceContainer>(){

            @Override
            protected WebResourceContainer executePluginMethod() {
                return WebResourceUrlExtractor.this.extractItems(resourceUrl, maxItemsToRetrieve);
            }
        }.execute(this.getExtractItemsTimeout() * 1000);
    }

    public final ContentURLContainer extractItemUrl(final WebResourceItem item) throws Throwable {
        this.log("Starting extraction of url for item: " + item.getTitle());
        ContentURLContainer result = (ContentURLContainer)new PluginExecutionProcessor<ContentURLContainer>(){

            @Override
            protected ContentURLContainer executePluginMethod() {
                return WebResourceUrlExtractor.this.extractUrl(item, Configuration.getOnlineFeedPreferredQuality());
            }
        }.execute(30000);
        boolean valid = this.validate(result);
        if (result != null && valid) {
            this.log("Finished extraction of url: " + result.toString());
            return result;
        }
        this.log("Finished extraction of url: no result");
        return null;
    }

    protected int getExtractItemsTimeout() {
        return 30;
    }

    protected abstract WebResourceContainer extractItems(URL var1, int var2);

    protected abstract ContentURLContainer extractUrl(WebResourceItem var1, PreferredQuality var2);
}

