/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.online;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.serviio.config.Configuration;
import org.serviio.library.entities.OnlineRepository;
import org.serviio.library.local.metadata.ImageDescriptor;
import org.serviio.library.metadata.InvalidMetadataException;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.library.online.AbstractOnlineItemParser;
import org.serviio.library.online.ContentURLContainer;
import org.serviio.library.online.WebResourceContainer;
import org.serviio.library.online.WebResourceItem;
import org.serviio.library.online.WebResourceUrlExtractor;
import org.serviio.library.online.metadata.MissingPluginException;
import org.serviio.library.online.metadata.OnlineResourceParseException;
import org.serviio.library.online.metadata.WebResourceFeed;
import org.serviio.library.online.metadata.WebResourceFeedItem;
import org.serviio.util.ObjectValidator;
import org.serviio.util.StringUtils;

public class WebResourceParser
extends AbstractOnlineItemParser {
    private static Map<String, Set<CachedItem>> parsedItemsCache = Collections.synchronizedMap(new HashMap());

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public WebResourceFeed parse(URL resourceUrl, Long onlineRepositoryId, MediaFileType fileType) throws OnlineResourceParseException, MissingPluginException {
        this.log.debug(String.format("Parsing web resource '%s'", resourceUrl));
        WebResourceFeed resource = new WebResourceFeed(onlineRepositoryId);
        WebResourceUrlExtractor suitablePlugin = (WebResourceUrlExtractor)this.findSuitableExtractorPlugin(resourceUrl, OnlineRepository.OnlineRepositoryType.WEB_RESOURCE);
        if (suitablePlugin == null) throw new MissingPluginException(String.format("No plugin for web resource %s has been found.", resourceUrl.toString()));
        WebResourceContainer container = null;
        try {
            container = suitablePlugin.parseWebResource(resourceUrl, Configuration.getMaxNumberOfItemsForOnlineFeeds());
        }
        catch (Throwable e) {
            throw new OnlineResourceParseException(String.format("Unexpected error while invoking plugin (%s): %s", suitablePlugin.getExtractorName(), e.getMessage()), e);
        }
        if (container == null) throw new OnlineResourceParseException(String.format("Plugin %s returned null container", suitablePlugin.getExtractorName()));
        resource.setTitle(StringUtils.trim(container.getTitle()));
        resource.setDomain(resourceUrl.getHost());
        resource.setUsedExtractor(suitablePlugin);
        this.setContainerThumbnail(resource, container);
        if (container.getItems() == null) return resource;
        int itemOrder = 1;
        for (int i = 0; i < container.getItems().size() && this.isAlive; ++i) {
            boolean added = this.addResourceItem(resourceUrl, resource, fileType, container.getItems().get(i), itemOrder, suitablePlugin);
            if (!added) continue;
            ++itemOrder;
        }
        return resource;
    }

    public synchronized void cleanItemCache(String resourceUrl) {
        this.log.debug(String.format("Removing all items from parsed items' cache for resource: %s", resourceUrl));
        parsedItemsCache.remove(resourceUrl);
    }

    public synchronized void cleanItemCache(URL resourceUrl, WebResourceFeedItem item) {
        Set<CachedItem> cItems = parsedItemsCache.get(resourceUrl.toString());
        if (cItems != null) {
            Iterator<CachedItem> it = cItems.iterator();
            while (it.hasNext()) {
                CachedItem cItem = it.next();
                if (!cItem.cacheKey.equals(item.getParsedItemCacheKey())) continue;
                this.log.debug(String.format("Removing item with key '%s' from parsedItemsCache cache for resource: %s", item.getCacheKey(), resourceUrl.toString()));
                it.remove();
                break;
            }
        }
    }

    private boolean addResourceItem(URL resourceUrl, WebResourceFeed resource, MediaFileType fileType, WebResourceItem item, int order, WebResourceUrlExtractor suitablePlugin) {
        WebResourceFeedItem resourceItem = WebResourceParser.findInCache(resourceUrl, item.getCacheKey());
        if (resourceItem != null) {
            this.log.debug(String.format("Item with key '%s' already found in the cache, skipping URL extraction", item.getCacheKey()));
            if (resourceItem.getOrder() != order) {
                resourceItem.setOrder(order);
            }
            if (!resourceItem.isValidEssence()) {
                this.log.debug(String.format("The cached item '%s' had its essence marked as invalid, setting it back to default to re-try essence validation", resourceItem.getCacheKey()));
                resourceItem.setValidEssence(true);
            }
            resource.getItems().add(resourceItem);
            this.log.debug(String.format("Added cached resource item %s: '%s' (%s)", order, resourceItem.getTitle(), resourceItem.getContentUrl()));
            return true;
        }
        resourceItem = new WebResourceFeedItem(resource, order);
        try {
            try {
                this.extractContentUrlViaPlugin(resourceUrl, suitablePlugin, resourceItem, item);
            }
            catch (Throwable e) {
                this.log.debug(String.format("Unexpected error during url extractor plugin invocation (%s) for item %s: %s", suitablePlugin.getExtractorName(), resourceItem.getTitle(), e.getMessage()), e);
                return false;
            }
            resourceItem.setDate(item.getReleaseDate());
            resourceItem.setTitle(StringUtils.trim(item.getTitle()));
            if (fileType == resourceItem.getType()) {
                resourceItem.fillInUnknownEntries();
                resourceItem.validateMetadata();
                if (ObjectValidator.isNotEmpty(item.getCacheKey())) {
                    resourceItem.setParsedItemCacheKey(item.getCacheKey());
                    WebResourceParser.storeInCache(resourceUrl, resourceItem);
                    this.log.debug(String.format("Stored item with key '%s' to cache", item.getCacheKey()));
                }
                this.log.debug(String.format("Added resource item %s: '%s' (%s)", order, resourceItem.getTitle(), resourceItem.getContentUrl()));
                resource.getItems().add(resourceItem);
                return true;
            }
            this.log.debug(String.format("Skipping web resource item '%s' because it's not of type %s", new Object[]{resourceItem.getTitle(), fileType}));
            return false;
        }
        catch (InvalidMetadataException e) {
            this.log.debug(String.format("Cannot add item of web resource %s because of invalid metadata. Message: %s", resource.getTitle(), e.getMessage()));
            return false;
        }
    }

    private void extractContentUrlViaPlugin(URL resourceUrl, WebResourceUrlExtractor urlExtractor, WebResourceFeedItem resourceItem, WebResourceItem extractedItem) throws Throwable {
        ContentURLContainer extractedUrl = urlExtractor.extractItemUrl(extractedItem);
        if (extractedUrl != null) {
            resourceItem.applyContentUrlContainer(extractedUrl, urlExtractor);
            resourceItem.getAdditionalInfo().putAll(extractedItem.getAdditionalInfo());
        } else {
            this.log.warn(String.format("Plugin %s returned no value for resource item '%s'", urlExtractor.getExtractorName(), resourceItem.getTitle()));
        }
    }

    private void setContainerThumbnail(WebResourceFeed resource, WebResourceContainer container) {
        if (container != null && ObjectValidator.isNotEmpty(container.getThumbnailUrl())) {
            try {
                ImageDescriptor thumbnail = new ImageDescriptor(new URL(container.getThumbnailUrl()));
                resource.setThumbnail(thumbnail);
            }
            catch (MalformedURLException e) {
                this.log.warn(String.format("Malformed url of a web resource thumbnail (%s), skipping this thumbnail", container.getThumbnailUrl()));
            }
        }
    }

    protected static synchronized WebResourceFeedItem findInCache(URL resourceUrl, String cacheKey) {
        Set<CachedItem> feedItems;
        if (cacheKey != null && (feedItems = parsedItemsCache.get(resourceUrl.toString())) != null) {
            for (CachedItem cItem : feedItems) {
                if (!cItem.cacheKey.equals(cacheKey)) continue;
                return cItem.item;
            }
        }
        return null;
    }

    protected static synchronized void storeInCache(URL resourceUrl, WebResourceFeedItem item) {
        String feedKey = resourceUrl.toString();
        if (!parsedItemsCache.containsKey(feedKey)) {
            parsedItemsCache.put(feedKey, new HashSet());
        }
        parsedItemsCache.get(feedKey).add(new CachedItem(item.getParsedItemCacheKey(), item));
    }

    private static class CachedItem {
        final String cacheKey;
        final WebResourceFeedItem item;

        public CachedItem(String cacheKey, WebResourceFeedItem item) {
            this.cacheKey = cacheKey;
            this.item = item;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.cacheKey == null ? 0 : this.cacheKey.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CachedItem other = (CachedItem)obj;
            return !(this.cacheKey == null ? other.cacheKey != null : !this.cacheKey.equals(other.cacheKey));
        }
    }
}

