/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.online;

import org.apache.jcs.access.exception.CacheException;
import org.serviio.cache.AbstractCacheDecorator;
import org.serviio.library.entities.CoverImage;
import org.serviio.library.online.OnlineCacheDecorator;

public class ThumbnailCacheDecorator
extends AbstractCacheDecorator
implements OnlineCacheDecorator<CoverImage> {
    public ThumbnailCacheDecorator(String regionName) {
        super(regionName);
    }

    @Override
    public CoverImage retrieve(String url) {
        CoverImage object = (CoverImage)this.cache.get((Object)url);
        return object;
    }

    @Override
    public void store(String url, CoverImage cachedValue) {
        try {
            this.cache.put((Object)url, (Object)cachedValue);
            this.log.debug(String.format("Stored entry in the cache (%s), returning it", this.regionName));
        }
        catch (CacheException e) {
            this.log.warn(String.format("Could not store object to local cache(%s): %s", this.regionName, e.getMessage()));
        }
    }

    @Override
    public void evict(String url) {
        try {
            this.cache.remove((Object)url);
            this.log.debug(String.format("Removed thumbnail %s from cache (%s)", url, this.regionName));
        }
        catch (CacheException e) {
            this.log.warn(String.format("Could not remove thumbnail %s from cache (%s): %s", url, this.regionName, e.getMessage()));
        }
    }
}

