/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.online;

import org.serviio.library.entities.OnlineRepository;
import org.serviio.library.local.metadata.ImageDescriptor;
import org.serviio.library.metadata.InvalidMetadataException;
import org.serviio.library.online.AbstractOnlineItemParser;
import org.serviio.library.online.metadata.SingleURLItem;
import org.serviio.util.HttpUtils;

public class SingleURLParser
extends AbstractOnlineItemParser {
    public SingleURLItem parseItem(OnlineRepository repository) {
        SingleURLItem item = new SingleURLItem(repository.getId());
        String[] credentials = null;
        item.setType(repository.getFileType());
        item.setContentUrl(repository.getRepositoryUrl());
        item.setTitle(repository.getRepositoryUrl());
        if (repository.getThumbnailUrl() != null) {
            item.setThumbnail(new ImageDescriptor(repository.getThumbnailUrl()));
        }
        item.setLive(repository.getRepoType() == OnlineRepository.OnlineRepositoryType.LIVE_STREAM);
        if (HttpUtils.isHttpUrl(repository.getRepositoryUrl())) {
            credentials = HttpUtils.getCredentialsFormUrl(repository.getRepositoryUrl());
        }
        try {
            item.fillInUnknownEntries();
            item.validateMetadata();
            this.alterUrlsWithCredentials(credentials, item);
        }
        catch (InvalidMetadataException e) {
            this.log.debug(String.format("Cannot parse online item %s because of invalid metadata. Message: %s", item.getContentUrl(), e.getMessage()));
            return null;
        }
        return item;
    }
}

