/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.online;

import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.serviio.util.ServiioThreadFactory;

public abstract class PluginExecutionProcessor<T> {
    private static ExecutorService executor = Executors.newCachedThreadPool(ServiioThreadFactory.getInstance());

    public static void shutdown() {
        executor.shutdownNow();
    }

    public T execute(int millisecondsTimeout) throws Throwable {
        Future future = executor.submit(new Callable<T>(){

            @Override
            public T call() {
                return PluginExecutionProcessor.this.executePluginMethod();
            }
        });
        try {
            Object t = future.get(millisecondsTimeout, TimeUnit.MILLISECONDS);
            return t;
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("The operation has been interrupted.");
        }
        catch (CancellationException e) {
            throw new RuntimeException("The operation has been cancelled.");
        }
        catch (TimeoutException e) {
            throw new RuntimeException(String.format("The operation took more than %s ms and has been cancelled.", millisecondsTimeout));
        }
        finally {
            this.cancel(future);
        }
    }

    protected abstract T executePluginMethod();

    private void cancel(Future<T> future) {
        future.cancel(true);
    }
}

