/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.online;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.serviio.config.Configuration;
import org.serviio.library.AbstractLibraryManager;
import org.serviio.library.entities.CoverImage;
import org.serviio.library.entities.OnlineRepository;
import org.serviio.library.local.metadata.ImageDescriptor;
import org.serviio.library.local.service.CoverImageService;
import org.serviio.library.local.service.SearchService;
import org.serviio.library.metadata.LibraryIndexingListener;
import org.serviio.library.online.AbstractOnlineItemParser;
import org.serviio.library.online.AbstractUrlExtractor;
import org.serviio.library.online.CannotRetrieveThumbnailException;
import org.serviio.library.online.OnlineCacheDecorator;
import org.serviio.library.online.OnlineContentCacheDecorator;
import org.serviio.library.online.PluginExecutionProcessor;
import org.serviio.library.online.SingleURLParser;
import org.serviio.library.online.TechnicalMetadataCacheDecorator;
import org.serviio.library.online.ThumbnailCacheDecorator;
import org.serviio.library.online.WebResourceParser;
import org.serviio.library.online.feed.FeedParser;
import org.serviio.library.online.metadata.FeedUpdaterThread;
import org.serviio.library.online.metadata.MissingPluginException;
import org.serviio.library.online.metadata.OnlineCDSLibraryIndexingListener;
import org.serviio.library.online.metadata.OnlineCachable;
import org.serviio.library.online.metadata.OnlineContainerItem;
import org.serviio.library.online.metadata.OnlineResourceContainer;
import org.serviio.library.online.metadata.OnlineResourceParseException;
import org.serviio.library.online.metadata.SingleURLItem;
import org.serviio.library.online.metadata.TechnicalMetadata;
import org.serviio.library.online.metadata.WebResourceFeed;
import org.serviio.library.online.metadata.WebResourceFeedItem;
import org.serviio.util.DateUtils;
import org.serviio.util.HttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineLibraryManager
extends AbstractLibraryManager {
    private static final Logger log = LoggerFactory.getLogger(OnlineLibraryManager.class);
    private static OnlineLibraryManager instance;
    private OnlineCacheDecorator<OnlineCachable> onlineCache;
    private OnlineCacheDecorator<CoverImage> thumbnailCache;
    private OnlineCacheDecorator<TechnicalMetadata> technicalMetadataCache;
    private FeedParser feedParser;
    private SingleURLParser singleURLParser;
    private WebResourceParser webResourceParser;
    private FeedUpdaterThread feedUpdaterThread;
    private LibraryIndexingListener cdsListener;
    private Map<String, Date> feedExpiryMonitor = Collections.synchronizedMap(new HashMap());
    private final CountDownLatch pluginsCompiled = new CountDownLatch(1);

    public static OnlineLibraryManager getInstance() {
        if (instance == null) {
            instance = new OnlineLibraryManager();
        }
        return instance;
    }

    private OnlineLibraryManager() {
        this.onlineCache = new OnlineContentCacheDecorator("online_feeds");
        this.thumbnailCache = new ThumbnailCacheDecorator("thumbnails");
        this.technicalMetadataCache = new TechnicalMetadataCacheDecorator("online_technical_metadata");
        this.feedParser = new FeedParser();
        this.webResourceParser = new WebResourceParser();
        this.singleURLParser = new SingleURLParser();
        this.cdsListener = new OnlineCDSLibraryIndexingListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startFeedUpdaterThread() {
        LibraryIndexingListener libraryIndexingListener = this.cdsListener;
        synchronized (libraryIndexingListener) {
            try {
                this.pluginsCompiled.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.feedParser.startParsing();
            this.webResourceParser.startParsing();
            if (this.feedUpdaterThread == null || this.feedUpdaterThread != null && !this.feedUpdaterThread.isWorkerRunning()) {
                this.feedUpdaterThread = new FeedUpdaterThread(this);
                this.feedUpdaterThread.setName("FeedUpdaterThread");
                this.feedUpdaterThread.setDaemon(true);
                this.feedUpdaterThread.setPriority(1);
                this.feedUpdaterThread.addListener(this.cdsListener);
                this.feedUpdaterThread.start();
            }
        }
    }

    public void startPluginCompilerThread() {
        AbstractOnlineItemParser.startPluginCompilerThread(this.pluginsCompiled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopFeedUpdaterThread() {
        LibraryIndexingListener libraryIndexingListener = this.cdsListener;
        synchronized (libraryIndexingListener) {
            this.feedParser.stopParsing();
            this.webResourceParser.stopParsing();
            this.stopThread(this.feedUpdaterThread);
            this.feedUpdaterThread = null;
        }
    }

    public void stopPluginCompilerThread() {
        AbstractOnlineItemParser.stopPluginCompilerThread();
        PluginExecutionProcessor.shutdown();
    }

    public void invokeFeedUpdaterThread() {
        if (this.feedUpdaterThread != null) {
            this.feedUpdaterThread.invoke();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OnlineResourceContainer<?, ?> findResource(OnlineRepository onlineRepository, boolean onlyCached) throws OnlineResourceParseException, MissingPluginException {
        try {
            URL resourceUrl = new URL(onlineRepository.getRepositoryUrl());
            OnlineResourceContainer resource = null;
            OnlineCacheDecorator<OnlineCachable> onlineCacheDecorator = this.onlineCache;
            synchronized (onlineCacheDecorator) {
                resource = (OnlineResourceContainer)this.onlineCache.retrieve(resourceUrl.toString());
            }
            if (!onlyCached && this.isResourceRefreshNeeded(resourceUrl, resource)) {
                log.debug(String.format("Resource %s not in cache, (re)loading it", resourceUrl.toString()));
                resource = onlineRepository.getRepoType() == OnlineRepository.OnlineRepositoryType.FEED ? this.feedParser.parse(resourceUrl, onlineRepository.getId(), onlineRepository.getFileType()) : this.webResourceParser.parse(resourceUrl, onlineRepository.getId(), onlineRepository.getFileType());
                onlineCacheDecorator = this.onlineCache;
                synchronized (onlineCacheDecorator) {
                    this.onlineCache.store(resourceUrl.toString(), resource);
                }
                SearchService.makeOnlineUnsearchable(onlineRepository.getId());
                this.storeResourceExpiryDate(resourceUrl.toString(), resource);
            }
            return resource;
        }
        catch (MalformedURLException e) {
            log.warn(String.format("Could not parse URL %s", onlineRepository.getRepositoryUrl()), (Throwable)e);
            return null;
        }
    }

    public OnlineResourceContainer<?, ?> findResourceInCacheOrParse(OnlineRepository onlineRepository) throws OnlineResourceParseException, MissingPluginException {
        return this.findResource(onlineRepository, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SingleURLItem findSingleURLItemInCacheOrParse(OnlineRepository onlineRepository) {
        SingleURLItem item = null;
        if (onlineRepository != null) {
            OnlineCacheDecorator<OnlineCachable> onlineCacheDecorator = this.onlineCache;
            synchronized (onlineCacheDecorator) {
                item = (SingleURLItem)this.onlineCache.retrieve(onlineRepository.getRepositoryUrl());
            }
            if (item == null) {
                item = this.singleURLParser.parseItem(onlineRepository);
                onlineCacheDecorator = this.onlineCache;
                synchronized (onlineCacheDecorator) {
                    this.onlineCache.store(onlineRepository.getRepositoryUrl(), item);
                }
            }
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOnlineContentFromCache(String resourceUrl, Long onlineRepositoryId, boolean resetExpiryDate) {
        Map<String, Date> map = this.feedExpiryMonitor;
        synchronized (map) {
            this.onlineCache.evict(resourceUrl);
            this.webResourceParser.cleanItemCache(resourceUrl);
            if (resetExpiryDate) {
                this.feedExpiryMonitor.remove(resourceUrl);
            }
            SearchService.makeOnlineUnsearchable(onlineRepositoryId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFeedFromCache(AbstractUrlExtractor plugin) {
        Map<String, Date> map = this.feedExpiryMonitor;
        synchronized (map) {
            HashSet<String> urls = new HashSet<String>(this.feedExpiryMonitor.keySet());
            for (String feedUrl : urls) {
                OnlineResourceContainer resource = (OnlineResourceContainer)this.onlineCache.retrieve(feedUrl);
                if (resource == null || resource.getUsedExtractor() == null || !((AbstractUrlExtractor)resource.getUsedExtractor()).equals(plugin)) continue;
                log.debug(String.format("Removing feed %s generated via %s from cache", feedUrl, plugin.getExtractorName()));
                this.removeOnlineContentFromCache(feedUrl, resource.getOnlineRepositoryId(), true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeTechnicalMetadata(String cacheKey, TechnicalMetadata md) {
        OnlineCacheDecorator<TechnicalMetadata> onlineCacheDecorator = this.technicalMetadataCache;
        synchronized (onlineCacheDecorator) {
            this.technicalMetadataCache.store(cacheKey, md);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TechnicalMetadata findTechnicalMetadata(String cacheKey) {
        OnlineCacheDecorator<TechnicalMetadata> onlineCacheDecorator = this.technicalMetadataCache;
        synchronized (onlineCacheDecorator) {
            if (cacheKey != null) {
                return this.technicalMetadataCache.retrieve(cacheKey);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoverImage findThumbnail(ImageDescriptor thumbnail, String userAgent) throws CannotRetrieveThumbnailException {
        OnlineCacheDecorator<CoverImage> onlineCacheDecorator = this.thumbnailCache;
        synchronized (onlineCacheDecorator) {
            if (thumbnail != null && thumbnail.getImageUrl() != null) {
                CoverImage coverImage = this.thumbnailCache.retrieve(thumbnail.getImageUrl().toString());
                if (coverImage == null) {
                    try {
                        log.debug(String.format("Thumbnail '%s' not in cache yet, loading it", thumbnail.getImageUrl().toString()));
                        byte[] imageBytes = HttpClient.retrieveBinaryFileFromURL(thumbnail.getImageUrl().toString(), userAgent);
                        ImageDescriptor clonedImage = new ImageDescriptor(imageBytes, null);
                        coverImage = CoverImageService.prepareCoverImage(clonedImage, null);
                        if (coverImage == null) {
                            throw new CannotRetrieveThumbnailException(String.format("An error accured when resizing thumbnail %s", thumbnail.getImageUrl().toString()));
                        }
                        this.thumbnailCache.store(thumbnail.getImageUrl().toString(), coverImage);
                    }
                    catch (IOException e) {
                        throw new CannotRetrieveThumbnailException(String.format("Failed to download thumbnail %s.", thumbnail.getImageUrl().toString()), e);
                    }
                }
                return coverImage;
            }
            return null;
        }
    }

    public void storeExpiryDateForFailedResource(String feedUrl, Long onlineRepositoryId) {
        log.debug(String.format("Resetting expiry date for feed %s", feedUrl));
        this.storeResourceExpiryDate(feedUrl, null);
        log.debug(String.format("Removing feed %s from online cache", feedUrl));
        this.removeOnlineContentFromCache(feedUrl, onlineRepositoryId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isResourceRefreshNeeded(URL resourceUrl, OnlineResourceContainer<?, ?> resource) {
        Map<String, Date> map = this.feedExpiryMonitor;
        synchronized (map) {
            Date expiryDate = this.feedExpiryMonitor.get(resourceUrl.toString());
            if (expiryDate != null) {
                Date currentDate = new Date();
                boolean resourceExpired = currentDate.after(expiryDate);
                if (!resourceExpired && resource != null) {
                    for (OnlineContainerItem item : resource.getItems()) {
                        if (item.getExpiresOn() == null || !currentDate.after(DateUtils.minusMinutes(item.getExpiresOn(), 5))) continue;
                        resourceExpired = true;
                        if (!(resource instanceof WebResourceFeed)) continue;
                        this.webResourceParser.cleanItemCache(resourceUrl, (WebResourceFeedItem)item);
                    }
                }
                if (resourceExpired) {
                    log.debug(String.format("Online resource %s expired, will reload it", resourceUrl.toString()));
                }
                return resourceExpired;
            }
            return resource == null;
        }
    }

    private Date getEarliestItemExpiryDate(OnlineResourceContainer<?, ?> resource) {
        Date earliestDate = null;
        for (OnlineContainerItem item : resource.getItems()) {
            if (item.getExpiresOn() == null) continue;
            earliestDate = earliestDate == null ? item.getExpiresOn() : (earliestDate.after(item.getExpiresOn()) ? item.getExpiresOn() : earliestDate);
        }
        return earliestDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expireAllFeeds() {
        Map<String, Date> map = this.feedExpiryMonitor;
        synchronized (map) {
            for (String url : this.feedExpiryMonitor.keySet()) {
                this.feedExpiryMonitor.put(url, new Date());
            }
        }
    }

    public void shutdownCaches() {
        this.technicalMetadataCache.shutdown();
        this.thumbnailCache.shutdown();
    }

    public void removePersistentCaches() {
        this.technicalMetadataCache.evictAll();
    }

    private Date getUserDefinedExpiryDate() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(new Date());
        ((Calendar)cal).add(10, Configuration.getOnlineFeedExpiryInterval());
        return cal.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeResourceExpiryDate(String feedUrl, OnlineResourceContainer<?, ?> resource) {
        Map<String, Date> map = this.feedExpiryMonitor;
        synchronized (map) {
            Date newExpiryDate = this.getUserDefinedExpiryDate();
            this.feedExpiryMonitor.put(feedUrl, newExpiryDate);
            if (resource != null) {
                Date itemExpiryDate = this.getEarliestItemExpiryDate(resource);
                log.debug(String.format("Resource %s will expire in the cache on %s", feedUrl, itemExpiryDate != null && itemExpiryDate.before(newExpiryDate) ? itemExpiryDate : newExpiryDate));
            }
        }
    }
}

