/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.online;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.serviio.library.entities.AccessGroup;
import org.serviio.library.entities.CoverImage;
import org.serviio.library.entities.OnlineRepository;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.library.online.CannotRetrieveThumbnailException;
import org.serviio.library.online.OnlineItemId;
import org.serviio.library.online.OnlineLibraryManager;
import org.serviio.library.online.metadata.MissingPluginException;
import org.serviio.library.online.metadata.NamedOnlineResource;
import org.serviio.library.online.metadata.OnlineItem;
import org.serviio.library.online.metadata.OnlineResourceContainer;
import org.serviio.library.online.metadata.OnlineResourceParseException;
import org.serviio.library.online.metadata.SingleURLItem;
import org.serviio.library.online.service.OnlineRepositoryService;
import org.serviio.upnp.service.contentdirectory.ObjectType;
import org.serviio.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineItemService {
    private static OnlineLibraryManager onlineLibraryManager = OnlineLibraryManager.getInstance();
    private static final Logger log = LoggerFactory.getLogger(OnlineItemService.class);

    public static OnlineResourceContainer<?, ?> findContainerResourceById(Long onlineRepositoryId) {
        NamedOnlineResource<OnlineResourceContainer<?, ?>> resource = OnlineItemService.findNamedContainerResourceById(onlineRepositoryId);
        if (resource != null) {
            return resource.getOnlineItem();
        }
        return null;
    }

    public static NamedOnlineResource<OnlineResourceContainer<?, ?>> findNamedContainerResourceById(Long onlineRepositoryId) {
        OnlineRepository onlineRepository = OnlineRepositoryService.getRepository(onlineRepositoryId);
        try {
            OnlineResourceContainer<?, ?> resource = OnlineItemService.findContainerResourceById(onlineRepository);
            if (resource != null) {
                return new NamedOnlineResource(resource, onlineRepository.getRepositoryName());
            }
            return null;
        }
        catch (OnlineResourceParseException e) {
            log.warn(String.format("Unexpected error retrieving resource %s: %s", onlineRepositoryId, e.getMessage()));
            return null;
        }
        catch (MissingPluginException e) {
            log.warn(String.format("Unexpected error retrieving resource %s: %s", onlineRepositoryId, e.getMessage()));
            return null;
        }
    }

    public static SingleURLItem findSingleURLItemById(Long onlineRepositoryId) {
        OnlineRepository onlineRepository = OnlineRepositoryService.getRepository(onlineRepositoryId);
        return onlineLibraryManager.findSingleURLItemInCacheOrParse(onlineRepository);
    }

    public static OnlineItem findOnlineItemById(Long onlineItemId) {
        NamedOnlineResource<OnlineItem> namedItem = OnlineItemService.findNamedOnlineItemById(onlineItemId);
        if (namedItem != null) {
            return namedItem.getOnlineItem();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NamedOnlineResource<OnlineItem> findNamedOnlineItemById(Long onlineItemId) {
        OnlineItemId itemId = OnlineItemId.parse(onlineItemId);
        OnlineRepository onlineRepository = OnlineRepositoryService.getRepository(itemId.getRepositoryId());
        if (onlineRepository != null) {
            if (OnlineItemService.getContainerResourceTypes().contains((Object)onlineRepository.getRepoType())) {
                OnlineResourceContainer<?, ?> resource = OnlineItemService.findContainerResourceById(itemId.getRepositoryId());
                if (resource == null) return null;
                try {
                    OnlineItem resourceItem = (OnlineItem)resource.getItems().get(itemId.getSequence() - 1);
                    if (resourceItem == null) return null;
                    return new NamedOnlineResource<OnlineItem>(resourceItem, resourceItem.getTitle());
                }
                catch (IndexOutOfBoundsException e) {
                    return null;
                }
            }
            SingleURLItem item = OnlineLibraryManager.getInstance().findSingleURLItemInCacheOrParse(onlineRepository);
            if (item == null) return null;
            return new NamedOnlineResource<OnlineItem>(item, onlineRepository.getRepositoryName());
        }
        log.warn("Cannot find online repository with id " + itemId.getRepositoryId());
        return null;
    }

    public static CoverImage findThumbnail(Long onlineItemId) throws IOException {
        OnlineItem onlineItem = OnlineItemService.findOnlineItemById(onlineItemId);
        if (onlineItem != null) {
            try {
                CoverImage thumbnail = onlineLibraryManager.findThumbnail(onlineItem.getThumbnail(), onlineItem.getUserAgent());
                if (thumbnail != null) {
                    thumbnail.setId(onlineItemId);
                    return thumbnail;
                }
            }
            catch (CannotRetrieveThumbnailException e) {
                log.warn(e.getMessage(), (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public static List<NamedOnlineResource<OnlineItem>> getListOfFeedItems(OnlineResourceContainer<?, ?> resource, MediaFileType itemType, int start, int count) {
        List<?> resourceItems = OnlineItemService.filterContainerResourceItems(resource.getItems(), itemType);
        if (resourceItems.size() >= start) {
            List<OnlineItem> requestedItems = CollectionUtils.getSubList(resourceItems, start, count);
            ArrayList<NamedOnlineResource<OnlineItem>> result = new ArrayList<NamedOnlineResource<OnlineItem>>();
            for (OnlineItem item : requestedItems) {
                result.add(new NamedOnlineResource<OnlineItem>(item, item.getTitle()));
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static void removeOnlineContentFromCache(String repoUrl, Long onlineRepositoryId) {
        OnlineLibraryManager.getInstance().removeOnlineContentFromCache(repoUrl, onlineRepositoryId, true);
    }

    public static List<NamedOnlineResource<OnlineResourceContainer<?, ?>>> getListOfParsedContainerResources(MediaFileType itemType, AccessGroup accessGroup, int start, int count, boolean onlyEnabled) {
        List<NamedOnlineResource<OnlineResourceContainer<?, ?>>> result = OnlineItemService.getAllParsedContainerResources(itemType, accessGroup, onlyEnabled);
        return CollectionUtils.getSubList(result, start, count);
    }

    public static int getCountOfParsedFeeds(MediaFileType itemType, AccessGroup accessGroup, boolean onlyEnabled) {
        return OnlineItemService.getAllParsedContainerResources(itemType, accessGroup, onlyEnabled).size();
    }

    public static int getCountOfOnlineItemsAndRepositories(MediaFileType itemType, ObjectType objectType, Long onlineRepositoryId, AccessGroup accessGroup, boolean onlyEnabled) {
        if (onlineRepositoryId == null) {
            int count = 0;
            if (objectType.supportsContainers()) {
                count += OnlineItemService.getCountOfParsedFeeds(itemType, accessGroup, onlyEnabled);
            }
            if (objectType.supportsItems()) {
                count += OnlineItemService.getCountOfSingleURLItems(itemType, accessGroup, onlyEnabled);
            }
            return count;
        }
        if (objectType.supportsItems()) {
            OnlineResourceContainer<?, ?> resource = OnlineItemService.findContainerResourceById(onlineRepositoryId);
            return OnlineItemService.getCountOfContainerItems(resource, itemType);
        }
        return 0;
    }

    public static List<NamedOnlineResource<OnlineItem>> getListOfSingleURLItems(MediaFileType itemType, AccessGroup accessGroup, int start, int count, boolean onlyEnabled) {
        List<OnlineRepository> repositories = OnlineRepositoryService.getListOfRepositories(OnlineItemService.getSingleUrlRepositoryTypes(), itemType, accessGroup, onlyEnabled);
        ArrayList<NamedOnlineResource<SingleURLItem>> onlineItems = new ArrayList<NamedOnlineResource<SingleURLItem>>();
        for (OnlineRepository repo : repositories) {
            SingleURLItem filteredItem;
            SingleURLItem item = onlineLibraryManager.findSingleURLItemInCacheOrParse(repo);
            if (item == null || (filteredItem = OnlineItemService.filterFeedItem(item, itemType)) == null) continue;
            onlineItems.add(new NamedOnlineResource<SingleURLItem>(filteredItem, repo.getRepositoryName()));
        }
        if (onlineItems.size() >= start) {
            List<NamedOnlineResource<OnlineItem>> requestedItems = CollectionUtils.getSubList(onlineItems, start, count);
            return requestedItems;
        }
        return Collections.emptyList();
    }

    public static int getCountOfSingleURLItems(MediaFileType itemType, AccessGroup accessGroup, boolean onlyEnabled) {
        List<OnlineRepository> repositories = OnlineRepositoryService.getListOfRepositories(OnlineItemService.getSingleUrlRepositoryTypes(), itemType, accessGroup, onlyEnabled);
        List<SingleURLItem> onlineItems = OnlineItemService.convertOnlineRepositories(repositories);
        return OnlineItemService.filterContainerResourceItems(onlineItems, itemType).size();
    }

    private static int getCountOfContainerItems(OnlineResourceContainer<?, ?> resource, MediaFileType itemType) {
        List<?> items = OnlineItemService.filterContainerResourceItems(resource.getItems(), itemType);
        return items.size();
    }

    private static List<NamedOnlineResource<OnlineResourceContainer<?, ?>>> getAllParsedContainerResources(MediaFileType itemType, AccessGroup accessGroup, boolean onlyEnabled) {
        List<OnlineRepository> allRepositories = OnlineRepositoryService.getListOfRepositories(OnlineItemService.getContainerResourceTypes(), itemType, accessGroup, onlyEnabled);
        ArrayList result = new ArrayList();
        for (OnlineRepository repo : allRepositories) {
            try {
                OnlineResourceContainer<?, ?> parsedResource = onlineLibraryManager.findResource(repo, true);
                if (parsedResource == null) continue;
                result.add(new NamedOnlineResource(parsedResource, repo.getRepositoryName()));
            }
            catch (MissingPluginException e) {
            }
            catch (OnlineResourceParseException e) {}
        }
        return result;
    }

    private static OnlineResourceContainer<?, ?> findContainerResourceById(OnlineRepository onlineRepository) throws MissingPluginException, OnlineResourceParseException {
        if (onlineRepository != null) {
            return onlineLibraryManager.findResource(onlineRepository, true);
        }
        return null;
    }

    private static <T extends OnlineItem> List<T> filterContainerResourceItems(List<T> items, MediaFileType type) {
        ArrayList<OnlineItem> filteredItems = new ArrayList<OnlineItem>();
        for (OnlineItem feedItem : items) {
            OnlineItem filteredItem = OnlineItemService.filterFeedItem(feedItem, type);
            if (filteredItem == null) continue;
            filteredItems.add(filteredItem);
        }
        return filteredItems;
    }

    private static <T extends OnlineItem> T filterFeedItem(T item, MediaFileType type) {
        if (item.getType() == type && item.isCompletelyLoaded()) {
            return item;
        }
        return null;
    }

    private static List<SingleURLItem> convertOnlineRepositories(List<OnlineRepository> repositories) {
        ArrayList<SingleURLItem> onlineItems = new ArrayList<SingleURLItem>();
        for (OnlineRepository repo : repositories) {
            SingleURLItem item = onlineLibraryManager.findSingleURLItemInCacheOrParse(repo);
            if (item == null) continue;
            onlineItems.add(item);
        }
        return onlineItems;
    }

    private static List<OnlineRepository.OnlineRepositoryType> getSingleUrlRepositoryTypes() {
        return Collections.singletonList(OnlineRepository.OnlineRepositoryType.LIVE_STREAM);
    }

    private static List<OnlineRepository.OnlineRepositoryType> getContainerResourceTypes() {
        return Arrays.asList(OnlineRepository.OnlineRepositoryType.FEED, OnlineRepository.OnlineRepositoryType.WEB_RESOURCE);
    }
}

