/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.online;

import org.serviio.util.NumberUtils;

public class OnlineItemId {
    private static final Long FEED_ITEM_ID_PREFIX = new Long(100000L);
    private long repositoryId;
    private int sequence;
    private int salt;

    public OnlineItemId(long repoId, int sequence) {
        this.repositoryId = repoId;
        this.sequence = sequence;
        this.salt = NumberUtils.getRandomInInterval(100, 999);
    }

    public long value() {
        return Long.parseLong(String.format("%s%03d%04d%03d", FEED_ITEM_ID_PREFIX, this.repositoryId, this.sequence, this.salt));
    }

    public static boolean isOnlineItemId(Long id) {
        boolean isLocalMedia = id > FEED_ITEM_ID_PREFIX * 10000000000L;
        return isLocalMedia;
    }

    public static OnlineItemId parse(Long itemId) {
        String idString = itemId.toString();
        int startIndex = FEED_ITEM_ID_PREFIX.toString().length();
        Long repositoryId = Long.parseLong(idString.substring(startIndex, startIndex + 3));
        Integer onlineItemOrder = Integer.parseInt(idString.substring(startIndex + 3, startIndex + 7));
        return new OnlineItemId(repositoryId, onlineItemOrder);
    }

    public long getRepositoryId() {
        return this.repositoryId;
    }

    public int getSequence() {
        return this.sequence;
    }
}

