/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.online;

import org.apache.jcs.access.exception.CacheException;
import org.serviio.cache.AbstractCacheDecorator;
import org.serviio.library.online.OnlineCacheDecorator;
import org.serviio.library.online.metadata.OnlineCachable;

public class OnlineContentCacheDecorator
extends AbstractCacheDecorator
implements OnlineCacheDecorator<OnlineCachable> {
    public OnlineContentCacheDecorator(String regionName) {
        super(regionName);
    }

    @Override
    public OnlineCachable retrieve(String url) {
        OnlineCachable object = (OnlineCachable)this.cache.get((Object)url);
        return object;
    }

    @Override
    public void store(String url, OnlineCachable cachedValue) {
        try {
            this.cache.put((Object)url, (Object)cachedValue);
            this.log.debug(String.format("Stored online content '%s' in the cache (%s), returning it", url, this.regionName));
        }
        catch (CacheException e) {
            this.log.warn(String.format("Could not store object to local cache (%s): %s", this.regionName, e.getMessage()));
        }
    }

    @Override
    public void evict(String url) {
        try {
            this.cache.remove((Object)url);
            this.log.debug(String.format("Removed online content '%s' from cache (%s)", url, this.regionName));
        }
        catch (CacheException e) {
            this.log.warn(String.format("Could not remove feed %s from cache (%s): %s", url, this.regionName, e.getMessage()));
        }
    }
}

