/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.online;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.serviio.config.Configuration;
import org.serviio.library.online.AbstractUrlExtractor;
import org.serviio.library.online.ContentURLContainer;
import org.serviio.library.online.PluginExecutionProcessor;
import org.serviio.library.online.PreferredQuality;
import org.serviio.library.online.metadata.FeedItem;

public abstract class FeedItemUrlExtractor
extends AbstractUrlExtractor {
    public final ContentURLContainer extractUrl(FeedItem feedItem) throws Throwable {
        this.log("Starting extraction of url for item: " + feedItem.getTitle());
        final HashMap<String, URL> links = new HashMap<String, URL>(feedItem.getLinks());
        if (feedItem.getThumbnail() != null) {
            links.put("thumbnail", feedItem.getThumbnail().getImageUrl());
        }
        ContentURLContainer result = (ContentURLContainer)new PluginExecutionProcessor<ContentURLContainer>(){

            @Override
            protected ContentURLContainer executePluginMethod() {
                return FeedItemUrlExtractor.this.extractUrl(links, Configuration.getOnlineFeedPreferredQuality());
            }
        }.execute(30000);
        boolean valid = this.validate(result);
        if (result != null && valid) {
            this.log("Finished extraction of url: " + result.toString());
            return result;
        }
        this.log("Finished extraction of url: no result");
        return null;
    }

    protected abstract ContentURLContainer extractUrl(Map<String, URL> var1, PreferredQuality var2);
}

