/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.online;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import org.serviio.library.metadata.MediaFileType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentURLContainer {
    private static final Logger log = LoggerFactory.getLogger(ContentURLContainer.class);
    private String contentUrl;
    private String thumbnailUrl;
    private MediaFileType fileType = MediaFileType.VIDEO;
    private Date expiresOn;
    private boolean expiresImmediately = false;
    private String cacheKey;
    private boolean live = false;
    private String userAgent;

    public String getContentUrl() {
        return this.contentUrl;
    }

    public URL getThumbnailUrl() {
        try {
            return this.thumbnailUrl != null ? new URL(this.thumbnailUrl) : null;
        }
        catch (MalformedURLException e) {
            log.debug("Cannot parse thumbnail URL: " + e.getMessage());
            return null;
        }
    }

    public MediaFileType getFileType() {
        return this.fileType;
    }

    public void setContentUrl(String contentUrl) {
        this.contentUrl = contentUrl;
    }

    public void setThumbnailUrl(String thumbnailUrl) {
        this.thumbnailUrl = thumbnailUrl;
    }

    public void setFileType(MediaFileType fileType) {
        this.fileType = fileType;
    }

    public Date getExpiresOn() {
        return this.expiresOn;
    }

    public void setExpiresOn(Date expiresIn) {
        this.expiresOn = expiresIn;
    }

    public boolean isExpiresImmediately() {
        return this.expiresImmediately;
    }

    public void setExpiresImmediately(boolean expiresImmediately) {
        this.expiresImmediately = expiresImmediately;
    }

    public String getCacheKey() {
        return this.cacheKey;
    }

    public void setCacheKey(String cacheKey) {
        this.cacheKey = cacheKey;
    }

    public boolean isLive() {
        return this.live;
    }

    public void setLive(boolean live) {
        this.live = live;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ContentURLContainer [");
        if (this.fileType != null) {
            builder.append("fileType=").append((Object)this.fileType).append(", ");
        }
        if (this.contentUrl != null) {
            builder.append("contentUrl=").append(this.contentUrl).append(", ");
        }
        if (this.thumbnailUrl != null) {
            builder.append("thumbnailUrl=").append(this.thumbnailUrl).append(", ");
        }
        if (this.expiresOn != null) {
            builder.append("expiresOn=").append(this.expiresOn).append(", ");
        }
        builder.append("expiresImmediately=").append(this.expiresImmediately).append(", ");
        if (this.cacheKey != null) {
            builder.append("cacheKey=").append(this.cacheKey).append(", ");
        }
        builder.append("live=").append(this.live).append(", ");
        if (this.userAgent != null) {
            builder.append("userAgent=").append(this.userAgent);
        }
        builder.append("]");
        return builder.toString();
    }
}

