/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.online;

import java.io.IOException;
import java.net.URL;
import java.util.Map;
import org.restlet.Client;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.ClientInfo;
import org.restlet.data.Cookie;
import org.restlet.data.Encoding;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.data.Status;
import org.serviio.config.Configuration;
import org.serviio.external.FFMPEGWrapper;
import org.serviio.library.online.ContentURLContainer;
import org.serviio.library.online.FeedItemUrlExtractor;
import org.serviio.library.online.WebResourceUrlExtractor;
import org.serviio.library.online.metadata.FeedItem;
import org.serviio.library.online.metadata.OnlineItem;
import org.serviio.library.online.metadata.WebResourceFeedItem;
import org.serviio.util.ObjectValidator;
import org.serviio.util.SecurityUtils;
import org.serviio.util.StringUtils;
import org.serviio.util.ZipUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUrlExtractor {
    protected static final int ITEM_LIST_TIMEOUT_SEC = 30;
    protected static final int URL_EXTRACTION_TIMEOUT_MS = 30000;
    protected static final Logger log = LoggerFactory.getLogger(FeedItemUrlExtractor.class);
    private Client restletClient = new Client(Protocol.HTTP);

    public static ContentURLContainer extractItemUrl(AbstractUrlExtractor plugin, OnlineItem item) throws Throwable {
        if (plugin != null) {
            if (plugin instanceof FeedItemUrlExtractor) {
                return ((FeedItemUrlExtractor)plugin).extractUrl((FeedItem)item);
            }
            if (plugin instanceof WebResourceUrlExtractor) {
                return ((WebResourceUrlExtractor)plugin).extractItemUrl(((WebResourceFeedItem)item).toContainerItem());
            }
        }
        return null;
    }

    public int getVersion() {
        return 1;
    }

    public abstract boolean extractorMatches(URL var1);

    public abstract String getExtractorName();

    protected final boolean validate(ContentURLContainer container) {
        if (container != null && (container.isExpiresImmediately() || container.getExpiresOn() != null) && ObjectValidator.isEmpty(container.getCacheKey())) {
            log.warn("Online item expires but no cache key has been set");
            return false;
        }
        return true;
    }

    protected final void log(String message) {
        log.debug(String.format("%s: %s", this.getExtractorName(), message));
    }

    protected final Integer getOnlineFeedExpiryInterval() {
        return Configuration.getOnlineFeedExpiryInterval();
    }

    protected final String generateMAC(String text, String salt, String algorithm) {
        try {
            return SecurityUtils.generateMacAsHex(salt, text, algorithm);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Error generating MAC: %s", e.getMessage()), e);
        }
    }

    protected final String decryptAES(String hexText, String key, String iv) {
        return SecurityUtils.decryptAES(key, iv, hexText);
    }

    protected final byte[] decrypt(String text, String key, String algorithm) {
        try {
            return SecurityUtils.decrypt(key, text, algorithm);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Error decrypting: %s", e.getMessage()), e);
        }
    }

    protected final String decryptAsHex(String text, String key, String algorithm) {
        try {
            return SecurityUtils.decryptAsHex(key, text, algorithm);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Error decrypting: %s", e.getMessage()), e);
        }
    }

    protected final String openURL(URL url, String userAgent) throws IOException {
        return this.openURL(url, userAgent, null);
    }

    protected final String openURL(URL url, String userAgent, Map<String, String> cookies) throws IOException {
        Response response;
        Request request = new Request(Method.GET, url.toString());
        if (cookies != null) {
            for (Map.Entry<String, String> cookie : cookies.entrySet()) {
                request.getCookies().add((Object)new Cookie(cookie.getKey(), cookie.getValue()));
            }
        }
        if (userAgent != null) {
            ClientInfo info = new ClientInfo();
            info.setAgent(userAgent);
            request.setClientInfo(info);
        }
        if (Status.SUCCESS_OK.equals((Object)(response = this.restletClient.handle(request)).getStatus())) {
            return this.readResponse(response);
        }
        if (response.getStatus().isRedirection()) {
            return this.openURL(response.getLocationRef().toUrl(), userAgent);
        }
        return null;
    }

    protected String readResponse(Response response) throws IOException {
        Encoding responseEncoding;
        Encoding encoding = responseEncoding = response.getEntity().getEncodings().size() > 0 ? (Encoding)response.getEntity().getEncodings().get(0) : null;
        if (responseEncoding == Encoding.GZIP) {
            return StringUtils.readStreamAsString(ZipUtils.unGzipSingleFile(response.getEntity().getStream()), "UTF-8");
        }
        if (responseEncoding == Encoding.ZIP) {
            return StringUtils.readStreamAsString(ZipUtils.unZipSingleFile(response.getEntity().getStream()), "UTF-8");
        }
        return StringUtils.readStreamAsString(response.getEntity().getStream(), "UTF-8");
    }

    protected final String getFFmpegUserAgent() {
        return FFMPEGWrapper.getFFmpegUserAgent();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getExtractorName() == null ? 0 : this.getExtractorName().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().getName().equals(obj.getClass().getName())) {
            return false;
        }
        AbstractUrlExtractor other = (AbstractUrlExtractor)obj;
        return !(this.getExtractorName() == null ? other.getExtractorName() != null : !this.getExtractorName().equals(other.getExtractorName()));
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.restletClient.stop();
    }
}

