/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.online;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.serviio.library.entities.OnlineRepository;
import org.serviio.library.online.AbstractUrlExtractor;
import org.serviio.library.online.feed.PluginCompilerThread;
import org.serviio.library.online.metadata.OnlineItem;
import org.serviio.util.HttpUtils;
import org.serviio.util.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOnlineItemParser {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected boolean isAlive = true;
    private static PluginCompilerThread pluginCompiler;

    public static synchronized void startPluginCompilerThread(CountDownLatch pluginsCompiled) {
        if (pluginCompiler == null || pluginCompiler != null && !pluginCompiler.isWorkerRunning()) {
            pluginCompiler = new PluginCompilerThread(pluginsCompiled);
            pluginCompiler.setName("PluginCompilerThread");
            pluginCompiler.setDaemon(true);
            pluginCompiler.setPriority(1);
            pluginCompiler.start();
        } else {
            pluginsCompiled.countDown();
        }
    }

    public static synchronized void stopPluginCompilerThread() {
        AbstractOnlineItemParser.stopThread(pluginCompiler);
        pluginCompiler = null;
    }

    public static Set<AbstractUrlExtractor> getListOfPlugins() {
        if (pluginCompiler != null) {
            return pluginCompiler.getUrlExtractors().keySet();
        }
        return Collections.emptySet();
    }

    public void stopParsing() {
        this.isAlive = false;
    }

    public void startParsing() {
        this.isAlive = true;
    }

    protected AbstractUrlExtractor findSuitableExtractorPlugin(URL feedUrl, OnlineRepository.OnlineRepositoryType type) {
        if (pluginCompiler != null && pluginCompiler.getUrlExtractors() != null) {
            for (Map.Entry<AbstractUrlExtractor, OnlineRepository.OnlineRepositoryType> urlExtractorEntry : pluginCompiler.getUrlExtractors().entrySet()) {
                AbstractUrlExtractor urlExtractor = urlExtractorEntry.getKey();
                try {
                    if (urlExtractorEntry.getValue() != type || !urlExtractor.extractorMatches(feedUrl)) continue;
                    this.log.debug(String.format("Found matching url extractor (%s) for resource %s", urlExtractor.getExtractorName(), feedUrl));
                    return urlExtractor;
                }
                catch (Exception e) {
                    this.log.debug(String.format("Unexpected error during url extractor plugin matching (%s): %s", urlExtractor.getExtractorName(), e.getMessage()));
                }
            }
        }
        return null;
    }

    protected void alterUrlsWithCredentials(String[] credentials, OnlineItem onlineItem) {
        if (credentials != null) {
            String contentUrl = onlineItem.getContentUrl();
            onlineItem.setContentUrl(this.getCredentialAlteredUrl(contentUrl, credentials));
            if (onlineItem.getThumbnail() != null && onlineItem.getThumbnail().getImageUrl() != null) {
                URL thumbnailUrl = onlineItem.getThumbnail().getImageUrl();
                onlineItem.getThumbnail().setImageUrl(this.getCredentialAlteredUrl(thumbnailUrl, credentials));
            }
        }
    }

    private String getCredentialAlteredUrl(String urlString, String[] credentials) {
        if (urlString != null) {
            try {
                if (HttpUtils.getCredentialsFormUrl(urlString) == null) {
                    URL url = new URL(urlString);
                    try {
                        return new URL(String.format("%s://%s:%s@%s%s", url.getProtocol(), credentials[0], credentials[1], url.getHost(), url.getPath(), url.getQuery())).toString();
                    }
                    catch (MalformedURLException e) {
                        this.log.warn("Cannot construct secure content URL: " + e.getMessage());
                    }
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return urlString;
    }

    private URL getCredentialAlteredUrl(URL url, String[] credentials) {
        if (url != null) {
            try {
                return new URL(this.getCredentialAlteredUrl(url.toString(), credentials));
            }
            catch (MalformedURLException e) {
                this.log.warn("Cannot construct secure content URL: " + e.getMessage());
            }
        }
        return url;
    }

    private static void stopThread(PluginCompilerThread thread) {
        if (thread != null) {
            thread.stopWorker();
            while (thread.isAlive()) {
                ThreadUtils.currentThreadSleep(100L);
            }
        }
    }
}

