/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.metadata;

import java.io.File;
import java.io.IOException;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.common.bytesource.ByteSource;
import org.apache.commons.imaging.common.bytesource.ByteSourceFile;
import org.apache.commons.imaging.common.bytesource.ByteSourceInputStream;
import org.serviio.library.local.metadata.ImageMetadata;
import org.serviio.library.local.metadata.extractor.InvalidMediaFormatException;
import org.serviio.library.local.metadata.extractor.embedded.EmbeddedMetadataExtractor;
import org.serviio.library.local.metadata.extractor.embedded.GIFExtractionStrategy;
import org.serviio.library.local.metadata.extractor.embedded.ImageExtractionStrategy;
import org.serviio.library.local.metadata.extractor.embedded.JPEGExtractionStrategy;
import org.serviio.library.local.metadata.extractor.embedded.PNGExtractionStrategy;
import org.serviio.util.HttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SanselanMetadataRetriever {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedMetadataExtractor.class);

    public static void retrieveImageMetadata(ImageMetadata md, String imageLocation, boolean local) throws InvalidMediaFormatException, IOException {
        Object byteSource = null;
        byteSource = local ? new ByteSourceFile(new File(imageLocation)) : new ByteSourceInputStream(HttpClient.retrieveBinaryStreamFromURL(imageLocation), imageLocation);
        try {
            ImageExtractionStrategy strategy = null;
            ImageFormat imageFormat = Imaging.guessFormat((ByteSource)byteSource);
            if (imageFormat == ImageFormat.IMAGE_FORMAT_JPEG) {
                strategy = new JPEGExtractionStrategy();
            } else if (imageFormat == ImageFormat.IMAGE_FORMAT_PNG) {
                strategy = new PNGExtractionStrategy();
            } else if (imageFormat == ImageFormat.IMAGE_FORMAT_GIF) {
                strategy = new GIFExtractionStrategy();
            } else {
                throw new InvalidMediaFormatException(String.format("File %s has unsupported image format", byteSource.getFilename()));
            }
            ((ImageExtractionStrategy)strategy).extractMetadata(md, (ByteSource)byteSource);
        }
        catch (ImageReadException e) {
            log.warn(String.format("Cannot read image file %s", imageLocation));
            throw new InvalidMediaFormatException(e.getMessage(), e);
        }
    }
}

