/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.metadata;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.serviio.util.CollectionUtils;
import org.serviio.util.ObjectValidator;
import org.serviio.util.StringUtils;

public enum MediaFileType {
    IMAGE{

        @Override
        public String[] supportedFileExtensions() {
            return new String[]{"jpg", "jpeg", "png", "gif", "arw", "cr2", "crw", "dng", "raf", "raw", "rw2", "mrw", "nef", "nrw", "pef", "srf", "orf"};
        }
    }
    ,
    VIDEO{

        @Override
        public String[] supportedFileExtensions() {
            return new String[]{"mpg", "mpeg", "vob", "avi", "mp4", "m4v", "ts", "wmv", "asf", "mkv", "divx", "m2ts", "mts", "mov", "mod", "tp", "trp", "vdr", "flv", "f4v", "dvr", "dvr-ms", "wtv", "ogv", "ogm", "3gp", "rm", "rmvb"};
        }
    }
    ,
    AUDIO{

        @Override
        public String[] supportedFileExtensions() {
            return new String[]{"mp3", "mp2", "wma", "m4a", "flac", "ogg", "oga", "wv", "mpc", "ape"};
        }
    };


    public abstract String[] supportedFileExtensions();

    public static MediaFileType findMediaFileTypeByExtension(String extension) {
        for (MediaFileType mediaFileType : MediaFileType.values()) {
            for (String supportedExtension : mediaFileType.supportedFileExtensions()) {
                if (!extension.equalsIgnoreCase(supportedExtension)) continue;
                return mediaFileType;
            }
        }
        return null;
    }

    public static MediaFileType findMediaFileTypeByMimeType(String mimeType) {
        if (ObjectValidator.isNotEmpty(mimeType)) {
            String mimeTypeLC = StringUtils.localeSafeToLowercase(mimeType);
            if (mimeTypeLC.startsWith("audio")) {
                return AUDIO;
            }
            if (mimeTypeLC.startsWith("image")) {
                return IMAGE;
            }
            if (mimeTypeLC.startsWith("video")) {
                return VIDEO;
            }
        }
        return null;
    }

    public static Set<MediaFileType> parseMediaFileTypesFromString(String fileTypesCSV) {
        HashSet<MediaFileType> result = new HashSet<MediaFileType>();
        if (ObjectValidator.isNotEmpty(fileTypesCSV)) {
            String[] fileTypes;
            for (String fileType : fileTypes = fileTypesCSV.split(",")) {
                result.add(MediaFileType.valueOf(StringUtils.localeSafeToUppercase(fileType.trim())));
            }
        }
        return result;
    }

    public static String parseMediaFileTypesToString(Set<MediaFileType> fileTypes) {
        return CollectionUtils.listToCSV(new ArrayList<MediaFileType>(fileTypes), ",", true);
    }
}

