/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.metadata;

import java.util.Date;
import org.serviio.library.metadata.InvalidMetadataException;
import org.serviio.util.ObjectValidator;
import org.serviio.util.StringUtils;

public abstract class ItemMetadata {
    public static final String UNKNOWN_ENTITY = "Unknown";
    protected String title;
    protected String author;
    protected Date date;
    protected String description;
    private boolean dirty = false;

    public void fillInUnknownEntries() {
        if (ObjectValidator.isEmpty(this.author)) {
            this.setAuthor(UNKNOWN_ENTITY);
        }
    }

    public void validateMetadata() throws InvalidMetadataException {
        if (ObjectValidator.isEmpty(this.title)) {
            throw new InvalidMetadataException("Title is empty.");
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        if (description != null && (description = StringUtils.removeNewLineCharacters(description)).length() > 1024) {
            this.description = description.substring(0, 1020) + " ...";
            return;
        }
        this.description = description;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }
}

