/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.serviio.delivery.DeliveryContext;
import org.serviio.dlna.AudioCodec;
import org.serviio.dlna.AudioContainer;
import org.serviio.dlna.SourceAspectRatio;
import org.serviio.dlna.SubtitleCodec;
import org.serviio.dlna.VideoCodec;
import org.serviio.dlna.VideoContainer;
import org.serviio.external.FFMPEGWrapper;
import org.serviio.library.local.EmbeddedSubtitles;
import org.serviio.library.local.H264LevelType;
import org.serviio.library.local.metadata.AudioMetadata;
import org.serviio.library.local.metadata.VideoMetadata;
import org.serviio.library.local.metadata.extractor.InvalidMediaFormatException;
import org.serviio.library.local.metadata.extractor.embedded.AVCHeader;
import org.serviio.library.metadata.ItemMetadata;
import org.serviio.util.CollectionUtils;
import org.serviio.util.DateUtils;
import org.serviio.util.MediaUtils;
import org.serviio.util.ObjectValidator;
import org.serviio.util.StringUtils;
import org.serviio.util.Tupple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FFmpegMetadataRetriever {
    private static final Logger log = LoggerFactory.getLogger(FFmpegMetadataRetriever.class);
    private static final Pattern streamIndexPattern = Pattern.compile("#[\\d][\\.:]([\\d]{1,2})(\\((\\w+)\\))?");
    private static final String CONTAINER = "container";
    private static final String DURATION = "duration";
    private static final String BITRATE = "bitrate";
    private static final String VIDEO_CODEC = "video_codec";
    private static final String VIDEO_FOURCC = "video_fourcc";
    private static final String VIDEO_STREAM_INDEX = "video_stream_index";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static final String VIDEO_BITRATE = "video_bitrate";
    private static final String FPS = "fps";
    private static final String AUDIO_CODEC = "audio_codec";
    private static final String AUDIO_CODEC_DETAILS = "audio_codec_details";
    private static final String AUDIO_STREAM_INDEX = "audio_stream_index";
    private static final String CHANNELS = "channels";
    private static final String FREQUENCY = "frequency";
    private static final String AUDIO_BITRATE = "audio_bitrate";
    private static final String FTYP = "ftyp";
    private static final String SAR = "sar";
    private static final String EMBEDDED_SUBTITLES = "embedded_subtitles";
    private static final String TOKEN_STREAM = "Stream";
    private static final Map<String, Integer> maxDpbMbs = new LinkedHashMap<String, Integer>();

    public static void retrieveMetadata(VideoMetadata metadata, String filePath, DeliveryContext context) throws IOException, InvalidMediaFormatException {
        List<String> mediaDescription = FFMPEGWrapper.readMediaFileInformation(filePath, context);
        FFmpegMetadataRetriever.updateMetadata(metadata, mediaDescription, filePath);
        FFmpegMetadataRetriever.validateMandatoryMetadata(metadata);
        FFmpegMetadataRetriever.getProfileForH264(metadata, filePath, context);
    }

    public static void retrieveAudioMetadata(AudioMetadata metadata, String filePath, DeliveryContext context) throws IOException, InvalidMediaFormatException {
        List<String> mediaDescription = FFMPEGWrapper.readMediaFileInformation(filePath, context);
        FFmpegMetadataRetriever.updateMetadata(metadata, mediaDescription);
        FFmpegMetadataRetriever.validateCodecsFound(metadata);
    }

    public static void retrieveOnlineMetadata(ItemMetadata md, String contentUrl, DeliveryContext context) throws InvalidMediaFormatException, IOException {
        if (md instanceof VideoMetadata) {
            FFmpegMetadataRetriever.retrieveMetadata((VideoMetadata)md, contentUrl, context);
        } else {
            FFmpegMetadataRetriever.retrieveAudioMetadata((AudioMetadata)md, contentUrl, context);
        }
    }

    private static Map<String, Object> getParametersMap(List<String> ffmpegMediaDescription) throws InvalidMediaFormatException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String container = null;
        ArrayList<EmbeddedSubtitles> subtitlesList = new ArrayList<EmbeddedSubtitles>();
        for (String line : ffmpegMediaDescription) {
            String sCodecName;
            SubtitleCodec sCodec;
            String[] tokens;
            int inputPos = (line = line.trim()).indexOf("Input #0");
            if (inputPos > -1) {
                container = line.substring(inputPos + 10, line.indexOf(",", inputPos + 11)).trim();
            }
            if (container == null) continue;
            parameters.put(CONTAINER, container);
            if (line.indexOf("major_brand") > -1) {
                tokens = line.split(":");
                parameters.put(FTYP, tokens[1].trim());
                continue;
            }
            if (line.indexOf("Duration") > -1) {
                for (String token : tokens = line.split(",")) {
                    String bitrateStr;
                    int spacepos;
                    if ((token = token.trim()).startsWith("Duration: ")) {
                        String duration = token.substring(10);
                        if (duration.indexOf("N/A") != -1) continue;
                        parameters.put(DURATION, DateUtils.timeToSeconds(duration));
                        continue;
                    }
                    if (!token.startsWith("bitrate: ") || (spacepos = (bitrateStr = token.substring(9)).indexOf(" ")) <= -1) continue;
                    String value = bitrateStr.substring(0, spacepos);
                    String unit = bitrateStr.substring(spacepos + 1);
                    Integer bitrate = Integer.parseInt(value);
                    if (unit.equals("mb/s")) {
                        bitrate = 1024 * bitrate;
                    }
                    parameters.put(BITRATE, bitrate);
                }
                continue;
            }
            if (line.startsWith(TOKEN_STREAM) && line.indexOf("Video:") > -1 && parameters.get(VIDEO_CODEC) == null) {
                String beforeVideo = line.substring(0, line.indexOf("Video:"));
                String afterVideo = line.substring(beforeVideo.length());
                String[] beforeVideoTokens = beforeVideo.split(",");
                String[] afterVideoTokens = afterVideo.split(",");
                for (String token : beforeVideoTokens) {
                    if (!(token = token.trim()).startsWith(TOKEN_STREAM)) continue;
                    parameters.put(VIDEO_STREAM_INDEX, FFmpegMetadataRetriever.getStreamIndex(token));
                }
                for (String token : afterVideoTokens) {
                    if ((token = token.trim()).startsWith("Video:")) {
                        parameters.put(VIDEO_CODEC, FFmpegMetadataRetriever.getVideoCodec(token));
                        parameters.put(VIDEO_FOURCC, FFmpegMetadataRetriever.getVideoFourCC(token));
                        continue;
                    }
                    if (token.indexOf("x") > -1) {
                        String resolution = token.trim();
                        int aspectStart = resolution.indexOf(" [");
                        if (aspectStart > -1) {
                            String aspectDef = resolution.substring(aspectStart + 2, resolution.indexOf("]"));
                            parameters.put(SAR, FFmpegMetadataRetriever.getSar(aspectDef));
                            resolution = resolution.substring(0, aspectStart);
                        }
                        try {
                            parameters.put(WIDTH, Integer.parseInt(resolution.substring(0, resolution.indexOf("x"))));
                            parameters.put(HEIGHT, Integer.parseInt(resolution.substring(resolution.indexOf("x") + 1)));
                        }
                        catch (NumberFormatException nfe) {}
                        continue;
                    }
                    if (token.indexOf("SAR") > -1 || token.indexOf("PAR") > -1) {
                        parameters.put(SAR, FFmpegMetadataRetriever.getSar(token));
                        continue;
                    }
                    if (token.indexOf("kb/s") > -1) {
                        parameters.put(VIDEO_BITRATE, Integer.parseInt(token.substring(0, token.indexOf("kb/s")).trim()));
                        continue;
                    }
                    if (token.indexOf("mb/s") > -1) {
                        parameters.put(VIDEO_BITRATE, Integer.parseInt(token.substring(0, token.indexOf("mb/s")).trim()) * 1024);
                        continue;
                    }
                    if (token.indexOf("tbr") > -1) {
                        String tbrValue = token.substring(0, token.indexOf("tbr")).trim();
                        parameters.put(FPS, FFmpegMetadataRetriever.getFps(tbrValue));
                        continue;
                    }
                    if (token.indexOf(FPS) <= -1 || parameters.get(FPS) != null) continue;
                    String fpsValue = token.substring(0, token.indexOf(FPS)).trim();
                    parameters.put(FPS, FFmpegMetadataRetriever.getFps(fpsValue));
                }
                continue;
            }
            if (line.startsWith(TOKEN_STREAM) && line.indexOf("Audio:") > -1 && parameters.get(AUDIO_CODEC) == null) {
                for (String token : tokens = line.split(",")) {
                    if ((token = token.trim()).startsWith(TOKEN_STREAM)) {
                        String[] audioCodec = FFmpegMetadataRetriever.getAudioCodec(token);
                        parameters.put(AUDIO_CODEC, audioCodec[0]);
                        parameters.put(AUDIO_CODEC_DETAILS, audioCodec[1]);
                        parameters.put(AUDIO_STREAM_INDEX, FFmpegMetadataRetriever.getStreamIndex(token));
                        continue;
                    }
                    if (token.indexOf(CHANNELS) > -1) {
                        parameters.put(CHANNELS, Integer.parseInt(token.substring(0, token.indexOf(CHANNELS)).trim()));
                        continue;
                    }
                    if (token.indexOf("stereo") > -1) {
                        parameters.put(CHANNELS, 2);
                        continue;
                    }
                    if (token.indexOf("5.1") > -1) {
                        parameters.put(CHANNELS, 6);
                        continue;
                    }
                    if (token.indexOf("7.1") > -1) {
                        parameters.put(CHANNELS, 8);
                        continue;
                    }
                    if (token.indexOf("mono") > -1) {
                        parameters.put(CHANNELS, 1);
                        continue;
                    }
                    if (token.indexOf("Hz") > -1) {
                        parameters.put(FREQUENCY, Integer.parseInt(token.substring(0, token.indexOf("Hz")).trim()));
                        continue;
                    }
                    if (token.indexOf("kb/s") > -1) {
                        parameters.put(AUDIO_BITRATE, Integer.parseInt(token.substring(0, token.indexOf("kb/s")).trim()));
                        continue;
                    }
                    if (token.indexOf("mb/s") <= -1) continue;
                    parameters.put(AUDIO_BITRATE, Integer.parseInt(token.substring(0, token.indexOf("mb/s")).trim()) * 1024);
                }
                continue;
            }
            if (!line.startsWith(TOKEN_STREAM) || line.indexOf("Subtitle:") <= -1 || (sCodec = SubtitleCodec.getByFFmpegValue(sCodecName = FFmpegMetadataRetriever.getSubtitleCodec(line))) == null) continue;
            Tupple<Integer, String> streamInfo = FFmpegMetadataRetriever.getStreamIndex(line);
            boolean defaultLanguage = line.indexOf("(default)") > -1;
            subtitlesList.add(new EmbeddedSubtitles(streamInfo.getValueA(), sCodec, streamInfo.getValueB(), defaultLanguage));
        }
        parameters.put(EMBEDDED_SUBTITLES, subtitlesList);
        return parameters;
    }

    protected static void updateMetadata(VideoMetadata metadata, List<String> ffmpegMediaDescription, String filePath) throws InvalidMediaFormatException {
        Map<String, Object> parameters = FFmpegMetadataRetriever.getParametersMap(ffmpegMediaDescription);
        Tupple audioStreamInfo = (Tupple)parameters.get(AUDIO_STREAM_INDEX);
        Tupple videoStreamInfo = (Tupple)parameters.get(VIDEO_STREAM_INDEX);
        metadata.setAudioBitrate((Integer)parameters.get(AUDIO_BITRATE));
        metadata.setAudioCodec(AudioCodec.getByFFmpegDecoderName((String)parameters.get(AUDIO_CODEC), (String)parameters.get(AUDIO_CODEC_DETAILS)));
        metadata.setAudioStreamIndex(audioStreamInfo != null ? (Integer)audioStreamInfo.getValueA() : null);
        metadata.setBitrate((Integer)parameters.get(BITRATE));
        metadata.setChannels((Integer)parameters.get(CHANNELS));
        metadata.setContainer(VideoContainer.getByFFmpegValue((String)parameters.get(CONTAINER), filePath));
        metadata.setDuration((Integer)parameters.get(DURATION));
        metadata.setFps((String)parameters.get(FPS));
        metadata.setFrequency((Integer)parameters.get(FREQUENCY));
        metadata.setHeight((Integer)parameters.get(HEIGHT));
        metadata.setVideoBitrate((Integer)parameters.get(VIDEO_BITRATE));
        metadata.setVideoCodec(VideoCodec.getByFFmpegValue((String)parameters.get(VIDEO_CODEC)));
        metadata.setVideoStreamIndex(videoStreamInfo != null ? (Integer)videoStreamInfo.getValueA() : null);
        metadata.setVideoFourCC((String)parameters.get(VIDEO_FOURCC));
        metadata.setWidth((Integer)parameters.get(WIDTH));
        metadata.setFtyp((String)parameters.get(FTYP));
        metadata.setSar(new SourceAspectRatio((String)parameters.get(SAR)));
        metadata.getEmbeddedSubtitles().addAll((List)parameters.get(EMBEDDED_SUBTITLES));
    }

    protected static void updateMetadata(AudioMetadata metadata, List<String> ffmpegMediaDescription) throws InvalidMediaFormatException {
        Map<String, Object> parameters = FFmpegMetadataRetriever.getParametersMap(ffmpegMediaDescription);
        metadata.setBitrate((Integer)parameters.get(BITRATE));
        metadata.setChannels((Integer)parameters.get(CHANNELS));
        metadata.setContainer(AudioContainer.getByName((String)parameters.get(AUDIO_CODEC)));
        metadata.setDuration((Integer)parameters.get(DURATION));
        metadata.setSampleFrequency((Integer)parameters.get(FREQUENCY));
    }

    protected static String getFps(String fpsValue) {
        if (fpsValue.indexOf("k") > -1) {
            fpsValue = fpsValue.replaceFirst("k", "000");
        }
        return MediaUtils.getValidFps(fpsValue);
    }

    protected static String getSar(String aspectDef) {
        int sarIndex = aspectDef.indexOf("SAR");
        if (sarIndex < 0) {
            sarIndex = aspectDef.indexOf("PAR");
        }
        if (sarIndex > -1) {
            aspectDef = aspectDef.substring(sarIndex + 4);
            String sar = aspectDef.substring(0, aspectDef.indexOf(" "));
            return sar;
        }
        return null;
    }

    protected static String getVideoCodec(String token) throws InvalidMediaFormatException {
        String codecValue = token.substring(token.indexOf("Video: ") + 7).split(" ")[0];
        if (codecValue != null && codecValue.startsWith("drm")) {
            throw new InvalidMediaFormatException("File is DRM protected");
        }
        return codecValue;
    }

    protected static String getVideoFourCC(String token) {
        String fourCC;
        String fourCCBlock;
        if (token.indexOf("(") > -1 && (fourCCBlock = token.substring(token.lastIndexOf("(") + 1, token.lastIndexOf(")"))).indexOf("/") > -1 && (fourCC = StringUtils.localeSafeToLowercase(fourCCBlock.split("/")[0].trim())).indexOf("[") == -1) {
            return fourCC;
        }
        return null;
    }

    protected static String[] getAudioCodec(String token) throws InvalidMediaFormatException {
        String details;
        String[] parts = token.substring(token.indexOf("Audio: ") + 7).split(" ");
        String codecValue = parts[0];
        String codecDetails = null;
        if (parts.length > 1 && (details = CollectionUtils.arrayToCSV(Arrays.copyOfRange(parts, 1, parts.length), " ")).startsWith("(")) {
            codecDetails = details.substring(1, details.indexOf(")"));
        }
        return new String[]{codecValue, codecDetails};
    }

    protected static String getSubtitleCodec(String token) throws InvalidMediaFormatException {
        String codecValue = token.substring(token.indexOf("Subtitle: ") + 10).split(" ")[0];
        return codecValue;
    }

    protected static Tupple<Integer, String> getStreamIndex(String token) {
        Matcher m = streamIndexPattern.matcher(token);
        if (m.find()) {
            return new Tupple<Integer, Object>(Integer.parseInt(m.group(1)), (m.groupCount() == 3 ? m.group(3) : null));
        }
        return null;
    }

    protected static void validateMandatoryMetadata(VideoMetadata metadata) throws InvalidMediaFormatException {
        if (metadata.getContainer() == null) {
            throw new InvalidMediaFormatException("Unknown video file type.");
        }
        if (metadata.getVideoCodec() == null) {
            throw new InvalidMediaFormatException("Unknown video codec.");
        }
        if (metadata.getWidth() == null) {
            throw new InvalidMediaFormatException("Unknown video width.");
        }
        if (metadata.getHeight() == null) {
            throw new InvalidMediaFormatException("Unknown video height.");
        }
    }

    protected static void validateCodecsFound(AudioMetadata metadata) throws InvalidMediaFormatException {
        if (metadata.getContainer() == null) {
            throw new InvalidMediaFormatException("Unknown audio file type.");
        }
    }

    private static void getProfileForH264(VideoMetadata metadata, String filePath, DeliveryContext context) {
        if (metadata.getVideoCodec() == VideoCodec.H264) {
            try {
                log.debug(String.format("Retrieving H264 profile/level for file '%s'", filePath));
                byte[] h264Stream = FFMPEGWrapper.readH264AnnexBHeader(filePath, metadata.getContainer(), context);
                AVCHeader avcHeader = FFmpegMetadataRetriever.parseH264Header(h264Stream);
                if (avcHeader != null) {
                    metadata.setH264Profile(avcHeader.getProfile());
                    String refFramesLevel = FFmpegMetadataRetriever.getAndValidateH264LevelBasedOnRefFrames(avcHeader.getRefFrames(), metadata.getWidth(), metadata.getHeight());
                    if (ObjectValidator.isNotEmpty(avcHeader.getLevel())) {
                        metadata.getH264Levels().put(H264LevelType.H, avcHeader.getLevel());
                    }
                    if (ObjectValidator.isNotEmpty(refFramesLevel)) {
                        metadata.getH264Levels().put(H264LevelType.RF, refFramesLevel);
                    }
                    log.debug(String.format("File '%s' has H264 profile %s, levels [%s] and %s ref frames", new Object[]{filePath, metadata.getH264Profile(), metadata.getH264Levels(), avcHeader.getRefFrames()}));
                } else {
                    log.warn(String.format("Couldn't resolve H264 profile/level/ref_frames for file '%s' because the header was not recognized", filePath));
                }
            }
            catch (Exception e) {
                log.warn(String.format("Failed to retrieve H264 profile/level/ref_frames information for file '%s': %s", filePath, e.getMessage()));
            }
        }
    }

    protected static AVCHeader parseH264Header(byte[] h264Stream) {
        try {
            AVCHeader avcHeader = new AVCHeader(h264Stream);
            avcHeader.parse();
            return avcHeader;
        }
        catch (Throwable e) {
            log.debug("AVC Header parse error: " + e.getMessage());
            return null;
        }
    }

    protected static String getAndValidateH264LevelBasedOnRefFrames(Integer refFrames, Integer width, Integer height) {
        if (width != null && height != null && width > 0 && height > 0 && refFrames != null && refFrames > 0) {
            Integer dpbMbs = width * height * refFrames / 256;
            String level = null;
            for (Map.Entry<String, Integer> levelDbp : maxDpbMbs.entrySet()) {
                level = levelDbp.getKey();
                if (levelDbp.getValue() <= dpbMbs) continue;
                return level;
            }
            return level;
        }
        return null;
    }

    private static void prepareMaxDpbMbs() {
        maxDpbMbs.put("1", 396);
        maxDpbMbs.put("1.1", 396);
        maxDpbMbs.put("1.2", 900);
        maxDpbMbs.put("1.3", 2376);
        maxDpbMbs.put("2", 2376);
        maxDpbMbs.put("2.1", 4752);
        maxDpbMbs.put("2.2", 8100);
        maxDpbMbs.put("3", 8100);
        maxDpbMbs.put("3.1", 18000);
        maxDpbMbs.put("3.2", 20480);
        maxDpbMbs.put("4", 32768);
        maxDpbMbs.put("4.1", 32768);
        maxDpbMbs.put("4.2", 34816);
        maxDpbMbs.put("5", 110400);
        maxDpbMbs.put("5.1", 184320);
    }

    static {
        FFmpegMetadataRetriever.prepareMaxDpbMbs();
    }
}

