/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.metadata;

import java.util.HashSet;
import java.util.Set;
import org.serviio.library.metadata.LibraryIndexingListener;
import org.serviio.library.metadata.MediaFileType;

public abstract class AbstractLibraryCheckerThread
extends Thread {
    protected boolean workerRunning = false;
    protected boolean searchingForFiles = false;
    protected boolean isSleeping = false;
    protected boolean dontSleep = false;
    private Set<LibraryIndexingListener> listeners = new HashSet<LibraryIndexingListener>();

    public void stopWorker() {
        this.workerRunning = false;
        this.interrupt();
    }

    public void invoke() {
        if (this.isSleeping) {
            this.interrupt();
        } else {
            this.dontSleep = true;
        }
    }

    public boolean isWorkerRunning() {
        return this.workerRunning;
    }

    public boolean isSearchingForFiles() {
        return this.searchingForFiles;
    }

    public void addListener(LibraryIndexingListener listener) {
        this.listeners.add(listener);
    }

    protected void notifyListenersAdd(MediaFileType fileType, String item) {
        for (LibraryIndexingListener l : this.listeners) {
            l.itemAdded(fileType, item);
        }
    }

    protected void notifyListenersUpdate(MediaFileType fileType, String item) {
        for (LibraryIndexingListener l : this.listeners) {
            l.itemUpdated(fileType, item);
        }
    }

    protected void notifyListenersRemove(MediaFileType fileType, String item) {
        for (LibraryIndexingListener l : this.listeners) {
            l.itemDeleted(fileType, item);
        }
    }

    protected void notifyListenersResetForAdding() {
        for (LibraryIndexingListener l : this.listeners) {
            l.resetForAdding();
        }
    }
}

