/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.metadata;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.serviio.library.metadata.LibraryIndexingListener;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.upnp.Device;
import org.serviio.upnp.service.contentdirectory.ContentDirectory;
import org.serviio.util.ServiioThreadFactory;
import org.serviio.util.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCDSLibraryIndexingListener
implements LibraryIndexingListener {
    private static final Logger log = LoggerFactory.getLogger(AbstractCDSLibraryIndexingListener.class);
    private static final int UPDATE_THREAD_INTERVAL_SECONDS = 5;
    private int threadUpdateInterval = 5;
    protected ContentDirectory cds = (ContentDirectory)Device.getInstance().getServiceById("urn:upnp-org:serviceId:ContentDirectory");
    private AtomicBoolean libraryUpdated = new AtomicBoolean(false);
    private String lastAddedFile;
    private int numberOfAddedFiles = 0;
    private Map<MediaFileType, String> fileTypeUpdateIds = new HashMap<MediaFileType, String>();

    public AbstractCDSLibraryIndexingListener() {
        ServiioThreadFactory.getInstance().newThread(new CDSNotifierThread(), "CDS library notifier", true).start();
        this.storeNewUpdateId(MediaFileType.IMAGE);
        this.storeNewUpdateId(MediaFileType.VIDEO);
        this.storeNewUpdateId(MediaFileType.AUDIO);
    }

    public AbstractCDSLibraryIndexingListener(int intervalSeconds) {
        this();
        this.threadUpdateInterval = intervalSeconds;
    }

    @Override
    public void resetForAdding() {
        this.lastAddedFile = null;
        this.numberOfAddedFiles = 0;
    }

    @Override
    public void itemAdded(MediaFileType fileType, String file) {
        this.lastAddedFile = file;
        ++this.numberOfAddedFiles;
        this.storeNewUpdateId(fileType);
        this.isLibraryUpdated().set(true);
    }

    @Override
    public void itemDeleted(MediaFileType fileType, String file) {
        this.storeNewUpdateId(fileType);
        this.isLibraryUpdated().set(true);
    }

    @Override
    public void itemUpdated(MediaFileType fileType, String file) {
        this.storeNewUpdateId(fileType);
        this.isLibraryUpdated().set(true);
    }

    protected abstract void performCDSUpdate();

    protected void notifyCDS() {
        log.debug("Library updated, notifying CDS");
        this.performCDSUpdate();
        this.isLibraryUpdated().set(false);
    }

    public String getUpdateId(MediaFileType fileType) {
        return this.fileTypeUpdateIds.get((Object)fileType);
    }

    public AtomicBoolean isLibraryUpdated() {
        return this.libraryUpdated;
    }

    public String getLastAddedFile() {
        return this.lastAddedFile;
    }

    public int getNumberOfAddedFiles() {
        return this.numberOfAddedFiles;
    }

    private void storeNewUpdateId(MediaFileType fileType) {
        if (fileType != null) {
            this.fileTypeUpdateIds.put(fileType, UUID.randomUUID().toString());
        }
    }

    private class CDSNotifierThread
    implements Runnable {
        private CDSNotifierThread() {
        }

        @Override
        public void run() {
            while (true) {
                if (AbstractCDSLibraryIndexingListener.this.isLibraryUpdated().get()) {
                    AbstractCDSLibraryIndexingListener.this.notifyCDS();
                }
                ThreadUtils.currentThreadSleep(AbstractCDSLibraryIndexingListener.this.threadUpdateInterval * 1000);
            }
        }
    }
}

