/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.local.service;

import java.util.ArrayList;
import java.util.List;
import org.serviio.library.entities.Image;
import org.serviio.library.entities.MusicTrack;
import org.serviio.library.entities.OnlineRepository;
import org.serviio.library.entities.Person;
import org.serviio.library.entities.Repository;
import org.serviio.library.entities.Series;
import org.serviio.library.entities.Video;
import org.serviio.library.local.ContentType;
import org.serviio.library.local.metadata.AudioMetadata;
import org.serviio.library.local.metadata.VideoMetadata;
import org.serviio.library.local.service.CoverImageService;
import org.serviio.library.local.service.PersonService;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.library.online.metadata.OnlineContainerItem;
import org.serviio.library.online.metadata.OnlineItem;
import org.serviio.library.online.metadata.OnlineResourceContainer;
import org.serviio.library.online.metadata.SingleURLItem;
import org.serviio.library.search.AlbumArtistSearchMetadata;
import org.serviio.library.search.AlbumSearchMetadata;
import org.serviio.library.search.EpisodeSearchMetadata;
import org.serviio.library.search.FileSearchMetadata;
import org.serviio.library.search.FolderSearchMetadata;
import org.serviio.library.search.MovieSearchMetadata;
import org.serviio.library.search.MusicTrackSearchMetadata;
import org.serviio.library.search.OnlineContainerSearchMetadata;
import org.serviio.library.search.OnlineItemSearchMetadata;
import org.serviio.library.search.SearchIndexer;
import org.serviio.library.search.SearchMetadata;
import org.serviio.library.search.SerieSearchMetadata;
import org.serviio.util.CollectionUtils;
import org.serviio.util.Tupple;

public class SearchMetadataFactory {
    public static List<SearchMetadata> videoMetadata(Long mediaItemId, VideoMetadata videoMD, Video video, Repository repository, Series series, Tupple<Long, List<Tupple<Long, String>>> folderHierarchy) {
        ArrayList<SearchMetadata> allMetadata = new ArrayList<SearchMetadata>();
        if (video.getContentType() == ContentType.MOVIE) {
            allMetadata.add(new MovieSearchMetadata(mediaItemId, video.getTitle(), video.getThumbnailId()));
        }
        if (video.getContentType() == ContentType.EPISODE && series != null) {
            allMetadata.add(new EpisodeSearchMetadata(mediaItemId, video.getSeasonNumber(), series.getId(), video.getTitle(), video.getThumbnailId(), series.getTitle()));
            allMetadata.add(new SerieSearchMetadata(series.getId(), series.getTitle(), series.getThumbnailId()));
        }
        allMetadata.add(new FileSearchMetadata(mediaItemId, video.getFileName(), SearchMetadataFactory.repositoryTupple(repository), SearchMetadataFactory.folderHierarchy(folderHierarchy), MediaFileType.VIDEO, video.getThumbnailId()));
        allMetadata.addAll(SearchMetadataFactory.buildMetadataForFolders(MediaFileType.VIDEO, repository, folderHierarchy));
        return allMetadata;
    }

    public static List<Tupple<SearchIndexer.SearchCategory, Long>> videoIndexIds(Long mediaItemId, Video video) {
        ArrayList<Tupple<SearchIndexer.SearchCategory, Long>> allPairs = new ArrayList<Tupple<SearchIndexer.SearchCategory, Long>>();
        if (video.getContentType() == ContentType.MOVIE) {
            allPairs.add(new Tupple<SearchIndexer.SearchCategory, Long>(SearchIndexer.SearchCategory.MOVIES, mediaItemId));
        }
        if (video.getContentType() == ContentType.EPISODE) {
            allPairs.add(new Tupple<SearchIndexer.SearchCategory, Long>(SearchIndexer.SearchCategory.EPISODES, mediaItemId));
        }
        allPairs.add(new Tupple<SearchIndexer.SearchCategory, Long>(SearchIndexer.SearchCategory.FILES, mediaItemId));
        return allPairs;
    }

    public static List<SearchMetadata> imageMetadata(Long mediaItemId, Image image, Repository repository, Tupple<Long, List<Tupple<Long, String>>> folderHierarchy) {
        ArrayList<SearchMetadata> allMetadata = new ArrayList<SearchMetadata>();
        allMetadata.add(new FileSearchMetadata(mediaItemId, image.getFileName(), SearchMetadataFactory.repositoryTupple(repository), SearchMetadataFactory.folderHierarchy(folderHierarchy), MediaFileType.IMAGE, image.getThumbnailId()));
        allMetadata.addAll(SearchMetadataFactory.buildMetadataForFolders(MediaFileType.IMAGE, repository, folderHierarchy));
        return allMetadata;
    }

    public static List<SearchMetadata> onlineMetadata(OnlineItem item, OnlineResourceContainer<? extends OnlineContainerItem<?>, ?> container, OnlineRepository repository) {
        Long itemThumbnailId;
        ArrayList<SearchMetadata> allMetadata = new ArrayList<SearchMetadata>();
        Long l = itemThumbnailId = item.getThumbnail() != null ? item.getId() : null;
        if (item instanceof SingleURLItem) {
            allMetadata.add(new OnlineItemSearchMetadata(repository.getId(), item.getId(), item.getDisplayTitle(repository.getRepositoryName()), item.getType(), itemThumbnailId));
        } else {
            String containerTitle = container.getDisplayName(repository.getRepositoryName());
            allMetadata.add(new OnlineItemSearchMetadata(repository.getId(), item.getId(), item.getTitle(), containerTitle, item.getType(), itemThumbnailId));
            allMetadata.add(new OnlineContainerSearchMetadata(repository.getId(), containerTitle, item.getType(), null, repository.getId()));
        }
        return allMetadata;
    }

    public static List<Tupple<SearchIndexer.SearchCategory, Long>> imageIndexIds(Long mediaItemId, Image image) {
        ArrayList<Tupple<SearchIndexer.SearchCategory, Long>> allPairs = new ArrayList<Tupple<SearchIndexer.SearchCategory, Long>>();
        allPairs.add(new Tupple<SearchIndexer.SearchCategory, Long>(SearchIndexer.SearchCategory.FILES, mediaItemId));
        return allPairs;
    }

    public static List<SearchMetadata> audioMetadata(Long mediaItemId, AudioMetadata audioMD, MusicTrack song, Repository repository, Tupple<Long, List<Tupple<Long, String>>> folderHierarchy) {
        ArrayList<SearchMetadata> allMetadata = new ArrayList<SearchMetadata>();
        Person albumArtist = (Person)CollectionUtils.getFirstItem(PersonService.getListOfPersonsForMusicAlbum(song.getAlbumId(), Person.RoleType.ALBUM_ARTIST));
        if (albumArtist != null) {
            allMetadata.add(new AlbumArtistSearchMetadata(albumArtist.getId(), albumArtist.getName(), albumArtist.getInitial(), CoverImageService.getPersonCoverArt(albumArtist.getId())));
        }
        allMetadata.add(new AlbumSearchMetadata(song.getAlbumId(), audioMD.getAlbum(), audioMD.getAlbumArtist(), CoverImageService.getMusicAlbumCoverArt(song.getAlbumId())));
        allMetadata.add(new MusicTrackSearchMetadata(mediaItemId, song.getAlbumId(), song.getTitle(), audioMD.getAlbum(), audioMD.getAlbumArtist(), song.getThumbnailId()));
        allMetadata.add(new FileSearchMetadata(mediaItemId, song.getFileName(), SearchMetadataFactory.repositoryTupple(repository), SearchMetadataFactory.folderHierarchy(folderHierarchy), MediaFileType.AUDIO, song.getThumbnailId()));
        allMetadata.addAll(SearchMetadataFactory.buildMetadataForFolders(MediaFileType.AUDIO, repository, folderHierarchy));
        return allMetadata;
    }

    public static List<Tupple<SearchIndexer.SearchCategory, Long>> audioIndexIds(Long mediaItemId, MusicTrack song) {
        ArrayList<Tupple<SearchIndexer.SearchCategory, Long>> allPairs = new ArrayList<Tupple<SearchIndexer.SearchCategory, Long>>();
        allPairs.add(new Tupple<SearchIndexer.SearchCategory, Long>(SearchIndexer.SearchCategory.MUSIC_TRACKS, mediaItemId));
        allPairs.add(new Tupple<SearchIndexer.SearchCategory, Long>(SearchIndexer.SearchCategory.FILES, mediaItemId));
        return allPairs;
    }

    private static List<SearchMetadata> buildMetadataForFolders(MediaFileType fileType, Repository repository, Tupple<Long, List<Tupple<Long, String>>> folderHierarchy) {
        ArrayList<SearchMetadata> allMetadata = new ArrayList<SearchMetadata>();
        if (repository != null && folderHierarchy != null) {
            List<Tupple<Long, String>> hierarchy = SearchMetadataFactory.folderHierarchy(folderHierarchy);
            for (int i = 0; i < hierarchy.size(); ++i) {
                List<Tupple<Long, String>> currentHierarchy = CollectionUtils.getSubList(hierarchy, 0, hierarchy.size() - i);
                Long leafFolderId = currentHierarchy.get(currentHierarchy.size() - 1).getValueA();
                allMetadata.add(new FolderSearchMetadata(SearchMetadataFactory.repositoryTupple(repository), currentHierarchy, fileType, CoverImageService.getFolderCoverArt(leafFolderId, fileType)));
            }
        }
        return allMetadata;
    }

    private static Tupple<Long, String> repositoryTupple(Repository repository) {
        if (repository != null) {
            return new Tupple<Long, String>(repository.getId(), repository.getRepositoryName());
        }
        return null;
    }

    private static List<Tupple<Long, String>> folderHierarchy(Tupple<Long, List<Tupple<Long, String>>> folderHierarchy) {
        if (folderHierarchy != null) {
            return folderHierarchy.getValueB();
        }
        return null;
    }
}

