/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.local.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.serviio.db.dao.DAOFactory;
import org.serviio.library.entities.AccessGroup;
import org.serviio.library.entities.Folder;
import org.serviio.library.entities.MediaItem;
import org.serviio.library.entities.Playlist;
import org.serviio.library.entities.Repository;
import org.serviio.library.local.service.AudioService;
import org.serviio.library.local.service.FolderService;
import org.serviio.library.local.service.ImageService;
import org.serviio.library.local.service.MediaService;
import org.serviio.library.local.service.PlaylistService;
import org.serviio.library.local.service.VideoService;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.library.search.SearchManager;
import org.serviio.library.service.AccessGroupService;
import org.serviio.library.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryService
implements Service {
    private static final Logger log = LoggerFactory.getLogger(RepositoryService.class);

    public static List<Repository> getAllRepositories() {
        return DAOFactory.getRepositoryDAO().findAll();
    }

    public static Repository getRepository(Long repositoryId) {
        return (Repository)DAOFactory.getRepositoryDAO().read(repositoryId);
    }

    public static boolean saveRepositories(List<Repository> repositories) {
        List<Repository> existingRepositories = RepositoryService.getAllRepositories();
        ArrayList<Repository> repsToRemove = new ArrayList<Repository>();
        boolean mediaItemsModified = false;
        for (Repository existingRepository : existingRepositories) {
            if (repositories.contains(existingRepository)) continue;
            log.debug(String.format("Will remove Repository: %s", existingRepository.toString()));
            repsToRemove.add(existingRepository);
        }
        if (RepositoryService.removeRepositories(repsToRemove)) {
            mediaItemsModified = true;
        }
        repositories.removeAll(repsToRemove);
        for (Repository repository : repositories) {
            if (repository.getId() == null) {
                DAOFactory.getRepositoryDAO().create(repository);
                continue;
            }
            if (!RepositoryService.updateRepository(repository)) continue;
            mediaItemsModified = true;
        }
        return mediaItemsModified;
    }

    public static List<Repository> getListOfRepositories(MediaFileType mediaType, AccessGroup accessGroup, int startingIndex, int requestedCount) {
        return DAOFactory.getRepositoryDAO().getRepositories(mediaType, accessGroup, startingIndex, requestedCount);
    }

    public static int getNumberOfRepositories(MediaFileType mediaType, AccessGroup accessGroup) {
        return DAOFactory.getRepositoryDAO().getRepositoriesCount(mediaType, accessGroup);
    }

    public static void markRepositoryAsScanned(Long repoId) {
        DAOFactory.getRepositoryDAO().markRepositoryAsScanned(repoId);
    }

    private static boolean removeRepositories(List<Repository> repositories) {
        log.debug(String.format("Found %s repositories to be removed", repositories.size()));
        boolean mediaItemsRemoved = false;
        for (Repository repository : repositories) {
            log.debug(String.format("Removing all items in repository %s", repository.getId()));
            List<MediaItem> mediaItems = MediaService.getMediaItemsInRepository(repository.getId());
            for (MediaItem mediaItem : mediaItems) {
                if (mediaItem.getFileType() == MediaFileType.AUDIO) {
                    AudioService.removeMusicTrackFromLibrary(mediaItem.getId());
                } else if (mediaItem.getFileType() == MediaFileType.VIDEO) {
                    VideoService.removeVideoFromLibrary(mediaItem.getId());
                } else if (mediaItem.getFileType() == MediaFileType.IMAGE) {
                    ImageService.removeImageFromLibrary(mediaItem.getId());
                }
                mediaItemsRemoved = true;
            }
            List<Playlist> playlists = PlaylistService.getPlaylistsInRepository(repository.getId());
            for (Playlist playlist : playlists) {
                PlaylistService.detetePlaylistAndItems(playlist.getId());
            }
            List<Folder> folders = FolderService.getFoldersInRepository(repository.getId());
            for (Folder folder : folders) {
                try {
                    FolderService.removeFolderAndItsParents(folder.getId(), SearchManager.getInstance().localIndexer());
                }
                catch (Exception e) {
                    log.debug(String.format("An error occured when trying to remove folder %s and it's parents: %s. This should fix itself.", folder.getId(), e.getMessage()));
                }
            }
            DAOFactory.getRepositoryDAO().delete(repository.getId());
        }
        return mediaItemsRemoved;
    }

    private static boolean updateRepository(Repository repository) {
        boolean mediaItemsRemoved = false;
        Repository existingRepository = RepositoryService.getRepository(repository.getId());
        if (existingRepository == null) {
            log.warn(String.format("Cannot update repository with id '%s' because it doesn't exist.", repository.getId()));
            return false;
        }
        Set<MediaFileType> existingSupportedFileTypes = existingRepository.getSupportedFileTypes();
        existingSupportedFileTypes.removeAll(repository.getSupportedFileTypes());
        for (MediaFileType unsupportedFileType : existingSupportedFileTypes) {
            List<MediaItem> mediaItems = MediaService.getMediaItemsInRepository(repository.getId(), unsupportedFileType);
            for (MediaItem mediaItem : mediaItems) {
                if (mediaItem.getFileType() == MediaFileType.AUDIO) {
                    AudioService.removeMusicTrackFromLibrary(mediaItem.getId());
                } else if (mediaItem.getFileType() == MediaFileType.VIDEO) {
                    VideoService.removeVideoFromLibrary(mediaItem.getId());
                } else if (mediaItem.getFileType() == MediaFileType.IMAGE) {
                    ImageService.removeImageFromLibrary(mediaItem.getId());
                }
                mediaItemsRemoved = true;
            }
        }
        List<AccessGroup> existingAccessGroups = AccessGroupService.getAccessGroupsForRepository(repository.getId());
        if (existingAccessGroups.size() != repository.getAccessGroupIds().size() || !existingAccessGroups.containsAll(repository.getAccessGroupIds())) {
            mediaItemsRemoved = true;
        }
        if (existingRepository.isSupportsDescriptiveMetadata() != repository.isSupportsDescriptiveMetadata()) {
            List<MediaItem> mediaItems = MediaService.getMediaItemsInRepository(repository.getId());
            for (MediaItem mediaItem : mediaItems) {
                MediaService.markMediaItemAsDirty(mediaItem.getId());
            }
        }
        DAOFactory.getRepositoryDAO().update(repository);
        return mediaItemsRemoved;
    }
}

