/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.local.service;

import java.io.File;
import java.util.List;
import org.serviio.db.dao.DAOFactory;
import org.serviio.library.entities.CoverImage;
import org.serviio.library.entities.MediaItem;
import org.serviio.library.entities.MetadataDescriptor;
import org.serviio.library.entities.MetadataExtractorConfig;
import org.serviio.library.local.metadata.extractor.ExtractorType;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.library.service.Service;
import org.serviio.util.FileUtils;

public class MediaService
implements Service {
    public static boolean isMediaPresentInLibrary(File mediaFile) {
        return DAOFactory.getMediaItemDAO().isMediaItemPresent(FileUtils.getProperFilePath(mediaFile));
    }

    public static MediaItem getMediaItem(String filePath, boolean ignoreCase) {
        return DAOFactory.getMediaItemDAO().getMediaItem(filePath, ignoreCase);
    }

    public static MediaItem readMediaItemById(Long id) {
        return DAOFactory.getMediaItemDAO().read(id);
    }

    public static File getFile(Long mediaItemId) {
        return DAOFactory.getMediaItemDAO().getFile(mediaItemId);
    }

    public static CoverImage getCoverImage(Long coverImageId) {
        return (CoverImage)DAOFactory.getCoverImageDAO().read(coverImageId);
    }

    public static void markMediaItemAsDirty(Long mediaItemId) {
        DAOFactory.getMediaItemDAO().markMediaItemAsDirty(mediaItemId);
    }

    public static void markMediaItemsAsDirty(MediaFileType fileType) {
        DAOFactory.getMediaItemDAO().markMediaItemsAsDirty(fileType);
    }

    public static void markMediaItemAsRead(Long mediaItemId) {
        DAOFactory.getMediaItemDAO().markMediaItemAsRead(mediaItemId);
    }

    public static void setMediaItemBookmark(Long mediaItemId, Integer seconds) {
        DAOFactory.getMediaItemDAO().setMediaItemBookmark(mediaItemId, seconds);
    }

    public static List<MediaItem> getMediaItemsInRepository(Long repositoryId) {
        return DAOFactory.getMediaItemDAO().getMediaItemsInRepository(repositoryId);
    }

    public static List<MediaItem> getMediaItemsInRepository(Long repositoryId, MediaFileType fileType) {
        return DAOFactory.getMediaItemDAO().getMediaItemsInRepository(repositoryId, fileType);
    }

    public static List<MediaItem> getDirtyMediaItemsInRepository(Long repositoryId) {
        return DAOFactory.getMediaItemDAO().getDirtyMediaItemsInRepository(repositoryId);
    }

    public static MetadataDescriptor getMetadataDescriptorForMediaItem(Long mediaItemId, ExtractorType extractorType) {
        return DAOFactory.getMetadataDescriptorDAO().retrieveMetadataDescriptorForMedia(mediaItemId, extractorType);
    }

    public static List<MetadataExtractorConfig> getMetadataExtractorConfigs(MediaFileType fileType) {
        return DAOFactory.getMetadataExtractorConfigDAO().retrieveByMediaFileType(fileType);
    }

    public static boolean updateMetadataExtractorConfigs(List<ExtractorType> extractors, MediaFileType fileType) {
        List<MetadataExtractorConfig> existingConfigs = MediaService.getMetadataExtractorConfigs(fileType);
        boolean updateNecessary = false;
        if (extractors.size() == existingConfigs.size()) {
            for (MetadataExtractorConfig existingConfig : existingConfigs) {
                if (extractors.contains((Object)existingConfig.getExtractorType())) continue;
                updateNecessary = true;
            }
        } else {
            updateNecessary = true;
        }
        if (updateNecessary) {
            for (MetadataExtractorConfig config : existingConfigs) {
                DAOFactory.getMetadataExtractorConfigDAO().delete(config.getId());
            }
            for (ExtractorType extractor : extractors) {
                MetadataExtractorConfig newConfig = new MetadataExtractorConfig(fileType, extractor, extractor.getDefaultPriority());
                DAOFactory.getMetadataExtractorConfigDAO().create(newConfig);
            }
        }
        return updateNecessary;
    }
}

