/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.local.service;

import java.util.List;
import org.serviio.config.Configuration;
import org.serviio.db.dao.DAOFactory;
import org.serviio.library.entities.Genre;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.library.service.Service;
import org.serviio.util.ObjectValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenreService
implements Service {
    private static final Logger log = LoggerFactory.getLogger(GenreService.class);

    public static void removeGenre(Long genreId) {
        int numberOfItems;
        if (genreId != null && (numberOfItems = DAOFactory.getGenreDAO().getNumberOfMediaItems(genreId)) == 0) {
            DAOFactory.getGenreDAO().delete(genreId);
        }
    }

    public static Genre getGenre(Long genreId) {
        if (genreId != null) {
            return (Genre)DAOFactory.getGenreDAO().read(genreId);
        }
        return null;
    }

    public static List<Genre> getListOfGenres(MediaFileType fileType, int startingIndex, int requestedCount) {
        return DAOFactory.getGenreDAO().retrieveGenres(fileType, startingIndex, requestedCount, Configuration.isBrowseFilterOutSeries());
    }

    public static int getNumberOfGenres(MediaFileType fileType) {
        return DAOFactory.getGenreDAO().getGenreCount(fileType, Configuration.isBrowseFilterOutSeries());
    }

    public static Long findOrCreateGenre(String genreName) {
        if (ObjectValidator.isNotEmpty(genreName)) {
            Genre genre = DAOFactory.getGenreDAO().findGenreByName(genreName);
            if (genre == null) {
                log.debug(String.format("Genre %s not found, creating a new one", genreName));
                genre = new Genre(genreName);
                return DAOFactory.getGenreDAO().create(genre);
            }
            log.debug(String.format("Genre %s found", genreName));
            return genre.getId();
        }
        return null;
    }
}

