/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.local.service;

import org.serviio.db.dao.DAOFactory;
import org.serviio.library.entities.CoverImage;
import org.serviio.library.local.metadata.ImageDescriptor;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.library.service.Service;
import org.serviio.util.ImageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoverImageService
implements Service {
    private static final Logger log = LoggerFactory.getLogger(CoverImageService.class);
    public static final int HD_THUMNAIL_WIDTH_MAX = 320;
    public static final int HD_THUMNAIL_HEIGHT_MAX = 320;

    public static Long createCoverImage(ImageDescriptor image, Integer rotation) {
        CoverImage coverImage = CoverImageService.prepareCoverImage(image, rotation);
        if (coverImage != null) {
            return DAOFactory.getCoverImageDAO().create(coverImage);
        }
        return null;
    }

    public static CoverImage prepareCoverImage(ImageDescriptor image, Integer requiredRotation) {
        if (image != null) {
            try {
                ImageDescriptor hdThumbnail = CoverImageService.prepareCoverImageThumbnail(image.getImageData(), requiredRotation, 320, 320);
                ImageDescriptor dlnaThumbnail = CoverImageService.prepareCoverImageThumbnail(hdThumbnail.getImageData(), null, 160, 160);
                CoverImage coverImage = new CoverImage(dlnaThumbnail.getImageData(), "image/jpeg", dlnaThumbnail.getWidth(), dlnaThumbnail.getHeight(), hdThumbnail.getImageData(), hdThumbnail.getWidth(), hdThumbnail.getHeight());
                return coverImage;
            }
            catch (Throwable e) {
                log.warn(String.format("Cannot convert/resize art to JPG. Message: %s", e.getMessage()));
                return null;
            }
        }
        return null;
    }

    public static Long getMusicAlbumCoverArt(Long albumId) {
        return DAOFactory.getCoverImageDAO().getCoverImageForMusicAlbum(albumId);
    }

    public static Long getFolderCoverArt(Long folderId, MediaFileType fileType) {
        return DAOFactory.getCoverImageDAO().getCoverImageForFolder(folderId, fileType);
    }

    public static Long getPersonCoverArt(Long personId) {
        return DAOFactory.getCoverImageDAO().getCoverImageForPerson(personId);
    }

    public static Long getRepositoryCoverArt(Long repositoryId, MediaFileType fileType) {
        return DAOFactory.getCoverImageDAO().getCoverImageForRepository(repositoryId, fileType);
    }

    public static void removeCoverImage(Long coverImageId) {
        if (coverImageId != null) {
            DAOFactory.getCoverImageDAO().delete(coverImageId);
        }
    }

    private static ImageDescriptor prepareCoverImageThumbnail(byte[] imagedata, Integer requiredRotation, int maxWidth, int maxHeight) {
        if (imagedata != null && imagedata.length > 0) {
            try {
                log.debug(String.format("Resizing and storing cover art image for max resolution of %sx%s", maxWidth, maxHeight));
                ImageDescriptor resizedImage = ImageUtils.resizeImageAsJPG(imagedata, maxWidth, maxHeight);
                log.debug("Image successfully resized");
                if (requiredRotation != null && !requiredRotation.equals(new Integer(0))) {
                    log.debug(String.format("Rotating thumbnail image (%s)", requiredRotation));
                    resizedImage = ImageUtils.rotateImage(resizedImage.getImageData(), requiredRotation);
                }
                return resizedImage;
            }
            catch (Throwable e) {
                log.warn(String.format("Cannot convert/resize art to JPG. Message: %s", e.getMessage()));
                return null;
            }
        }
        return null;
    }
}

