/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.local.service;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.serviio.db.dao.DAOFactory;
import org.serviio.library.entities.AccessGroup;
import org.serviio.library.entities.MetadataDescriptor;
import org.serviio.library.entities.MusicAlbum;
import org.serviio.library.entities.MusicTrack;
import org.serviio.library.entities.Person;
import org.serviio.library.entities.Repository;
import org.serviio.library.local.metadata.AudioMetadata;
import org.serviio.library.local.metadata.extractor.MetadataFile;
import org.serviio.library.local.service.CoverImageService;
import org.serviio.library.local.service.FolderService;
import org.serviio.library.local.service.GenreService;
import org.serviio.library.local.service.PlaylistService;
import org.serviio.library.local.service.RepositoryService;
import org.serviio.library.local.service.SearchService;
import org.serviio.library.search.SearchIndexer;
import org.serviio.library.search.SearchManager;
import org.serviio.library.service.Service;
import org.serviio.util.ObjectValidator;
import org.serviio.util.Tupple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AudioService
implements Service {
    private static final Logger log = LoggerFactory.getLogger(AudioService.class);

    public static void addMusicTrackToLibrary(AudioMetadata metadata, Repository repository) {
        if (metadata != null) {
            log.debug(String.format("Adding music track into database: %s", metadata.getTitle()));
            Long albumId = AudioService.findOrCreateAlbum(metadata);
            Tupple<Long, List<Tupple<Long, String>>> folderHierarchy = FolderService.createOrReadFolder(repository, metadata.getFilePath());
            Long genreId = GenreService.findOrCreateGenre(metadata.getGenre());
            Long coverImageId = CoverImageService.createCoverImage(metadata.getCoverImage(), null);
            MusicTrack track = new MusicTrack(metadata.getTitle(), metadata.getContainer(), new File(metadata.getFilePath()).getName(), metadata.getFilePath(), (Long)metadata.getFileSize(), folderHierarchy.getValueA(), repository.getId(), metadata.getDate());
            track.setAlbumId(albumId);
            track.setDuration(metadata.getDuration());
            track.setGenreId(genreId);
            track.setThumbnailId(coverImageId);
            track.setTrackNumber(metadata.getTrackNumber());
            track.setReleaseYear(metadata.getReleaseYear());
            track.setDescription(metadata.getDescription());
            track.setBitrate(metadata.getBitrate());
            track.setChannels(metadata.getChannels());
            track.setSampleFrequency(metadata.getSampleFrequency());
            track.setDiscNumber(metadata.getDiscNumber());
            track.setDirty(metadata.isDirty());
            Long mediaItemId = DAOFactory.getMusicTrackDAO().create(track);
            if (ObjectValidator.isNotEmpty(metadata.getArtist())) {
                DAOFactory.getPersonDAO().addPersonToMedia(metadata.getArtist(), Person.RoleType.ARTIST, mediaItemId);
            }
            if (ObjectValidator.isNotEmpty(metadata.getAuthor())) {
                DAOFactory.getPersonDAO().addPersonToMedia(metadata.getAuthor(), Person.RoleType.COMPOSER, mediaItemId);
            }
            for (MetadataFile metadataFile : metadata.getMetadataFiles()) {
                MetadataDescriptor metadataDescriptor = new MetadataDescriptor(metadataFile.getExtractorType(), mediaItemId, metadataFile.getLastUpdatedDate(), metadataFile.getIdentifier());
                DAOFactory.getMetadataDescriptorDAO().create(metadataDescriptor);
            }
            SearchService.makeAudioSearchable(mediaItemId, metadata, track, repository, folderHierarchy);
        } else {
            log.warn("Music track cannot be added to the library because no metadata has been provided");
        }
    }

    public static void removeMusicTrackFromLibrary(Long mediaItemId) {
        MusicTrack track = AudioService.getSong(mediaItemId);
        if (track != null) {
            log.debug(String.format("Removing music track from database: %s", track.getTitle()));
            DAOFactory.getPersonDAO().removeAllPersonsFromMedia(mediaItemId);
            PlaylistService.removeMediaItemFromPlaylists(mediaItemId);
            DAOFactory.getMetadataDescriptorDAO().removeMetadataDescriptorsForMedia(mediaItemId);
            DAOFactory.getMusicTrackDAO().delete(track.getId());
            CoverImageService.removeCoverImage(track.getThumbnailId());
            AudioService.removeAlbum(track);
            FolderService.removeFolderAndItsParents(track.getFolderId(), SearchManager.getInstance().localIndexer());
            GenreService.removeGenre(track.getGenreId());
            SearchService.makeAudioUnsearchable(mediaItemId, track);
        } else {
            log.warn("Music track cannot be removed from the library because it cannot be found");
        }
    }

    public static void updateMusicTrackInLibrary(AudioMetadata metadata, Long mediaItemId) {
        if (metadata != null) {
            log.debug(String.format("Updating music track in database: %s", metadata.getTitle()));
            MusicTrack track = AudioService.getSong(mediaItemId);
            Long albumId = AudioService.findOrCreateAlbum(metadata);
            Long genreId = GenreService.findOrCreateGenre(metadata.getGenre());
            Long coverImageId = CoverImageService.createCoverImage(metadata.getCoverImage(), null);
            MusicTrack updatedTrack = new MusicTrack(metadata.getTitle(), metadata.getContainer(), track.getFileName(), metadata.getFilePath(), (Long)metadata.getFileSize(), track.getFolderId(), track.getRepositoryId(), metadata.getDate());
            updatedTrack.setId(track.getId());
            updatedTrack.setAlbumId(albumId);
            updatedTrack.setDuration(metadata.getDuration());
            updatedTrack.setGenreId(genreId);
            updatedTrack.setThumbnailId(coverImageId);
            updatedTrack.setTrackNumber(metadata.getTrackNumber());
            updatedTrack.setReleaseYear(metadata.getReleaseYear());
            updatedTrack.setDescription(metadata.getDescription());
            updatedTrack.setBitrate(metadata.getBitrate());
            updatedTrack.setChannels(metadata.getChannels());
            updatedTrack.setSampleFrequency(metadata.getSampleFrequency());
            updatedTrack.setDiscNumber(metadata.getDiscNumber());
            updatedTrack.setDirty(metadata.isDirty());
            DAOFactory.getMusicTrackDAO().update(updatedTrack);
            List<Long> originalArtistRoles = DAOFactory.getPersonDAO().getRoleIDsForMediaItem(Person.RoleType.ARTIST, mediaItemId);
            List<Long> originalComposerRoles = DAOFactory.getPersonDAO().getRoleIDsForMediaItem(Person.RoleType.COMPOSER, mediaItemId);
            ArrayList<Long> newArtistRoles = new ArrayList<Long>();
            ArrayList<Long> newComposerRoles = new ArrayList<Long>();
            if (ObjectValidator.isNotEmpty(metadata.getArtist())) {
                Long artistRoleId = DAOFactory.getPersonDAO().addPersonToMedia(metadata.getArtist(), Person.RoleType.ARTIST, mediaItemId);
                newArtistRoles.add(artistRoleId);
            }
            if (ObjectValidator.isNotEmpty(metadata.getAuthor())) {
                Long composerRoleId = DAOFactory.getPersonDAO().addPersonToMedia(metadata.getAuthor(), Person.RoleType.COMPOSER, mediaItemId);
                newComposerRoles.add(composerRoleId);
            }
            DAOFactory.getMetadataDescriptorDAO().removeMetadataDescriptorsForMedia(mediaItemId);
            for (MetadataFile metadataFile : metadata.getMetadataFiles()) {
                MetadataDescriptor metadataDescriptor = new MetadataDescriptor(metadataFile.getExtractorType(), mediaItemId, metadataFile.getLastUpdatedDate(), metadataFile.getIdentifier());
                DAOFactory.getMetadataDescriptorDAO().create(metadataDescriptor);
            }
            AudioService.removeAlbum(track);
            GenreService.removeGenre(track.getGenreId());
            CoverImageService.removeCoverImage(track.getThumbnailId());
            originalArtistRoles.removeAll(newArtistRoles);
            DAOFactory.getPersonDAO().removePersonsAndRoles(originalArtistRoles);
            originalComposerRoles.removeAll(newComposerRoles);
            DAOFactory.getPersonDAO().removePersonsAndRoles(originalComposerRoles);
            SearchService.makeAudioSearchable(mediaItemId, metadata, updatedTrack, RepositoryService.getRepository(updatedTrack.getRepositoryId()), FolderService.getFolderHierarchy(updatedTrack.getFolderId()));
        } else {
            log.warn("Music track cannot be updated in the library because no metadata has been provided");
        }
    }

    public static List<MusicTrack> getListOfSongsForArtist(Long artistId, AccessGroup accessGroup, int startingIndex, int requestedCount) {
        return DAOFactory.getMusicTrackDAO().retrieveMusicTracksForArtist(artistId, accessGroup, startingIndex, requestedCount);
    }

    public static int getNumberOfSongsForArtist(Long artistId, AccessGroup accessGroup) {
        return DAOFactory.getMusicTrackDAO().retrieveMusicTracksForArtistCount(artistId, accessGroup);
    }

    public static List<MusicTrack> getListOfSongsForGenre(Long genreId, AccessGroup accessGroup, int startingIndex, int requestedCount) {
        return DAOFactory.getMusicTrackDAO().retrieveMusicTracksForGenre(genreId, accessGroup, startingIndex, requestedCount);
    }

    public static int getNumberOfSongsForGenre(Long genreId, AccessGroup accessGroup) {
        return DAOFactory.getMusicTrackDAO().retrieveMusicTracksForGenreCount(genreId, accessGroup);
    }

    public static List<MusicTrack> getListOfSongsForPlaylist(Long playlistId, AccessGroup accessGroup, int startingIndex, int requestedCount) {
        return DAOFactory.getMusicTrackDAO().retrieveMusicTracksForPlaylist(playlistId, accessGroup, startingIndex, requestedCount);
    }

    public static int getNumberOfSongsForPlaylist(Long playlistId, AccessGroup accessGroup) {
        return DAOFactory.getMusicTrackDAO().retrieveMusicTracksForPlaylistCount(playlistId, accessGroup);
    }

    public static List<String> getListOfSongInitials(AccessGroup accessGroup, int startingIndex, int requestedCount) {
        return DAOFactory.getMusicTrackDAO().retrieveMusicTracksInitials(accessGroup, startingIndex, requestedCount);
    }

    public static int getNumberOfSongInitials(AccessGroup accessGroup) {
        return DAOFactory.getMusicTrackDAO().retrieveMusicTracksInitialsCount(accessGroup);
    }

    public static List<MusicTrack> getListOfSongsForInitial(String initial, AccessGroup accessGroup, int startingIndex, int requestedCount) {
        return DAOFactory.getMusicTrackDAO().retrieveMusicTracksForInitial(initial, accessGroup, startingIndex, requestedCount);
    }

    public static int getNumberOfSongsForInitial(String initial, AccessGroup accessGroup) {
        return DAOFactory.getMusicTrackDAO().retrieveMusicTracksForInitialCount(initial, accessGroup);
    }

    public static List<MusicTrack> getListOfSongsForFolder(Long folderId, AccessGroup accessGroup, int startingIndex, int requestedCount) {
        return DAOFactory.getMusicTrackDAO().retrieveMusicTracksForFolder(folderId, accessGroup, startingIndex, requestedCount);
    }

    public static int getNumberOfSongsForFolder(Long folderId, AccessGroup accessGroup) {
        return DAOFactory.getMusicTrackDAO().retrieveMusicTracksForFolderCount(folderId, accessGroup);
    }

    public static List<MusicTrack> getListOfAllSongs(AccessGroup accessGroup, int startingIndex, int requestedCount) {
        return DAOFactory.getMusicTrackDAO().retrieveAllMusicTracks(accessGroup, startingIndex, requestedCount);
    }

    public static int getNumberOfAllSongs(AccessGroup accessGroup) {
        return DAOFactory.getMusicTrackDAO().retrieveAllMusicTracksCount(accessGroup);
    }

    public static List<MusicTrack> getListOfRandomSongs(int max, AccessGroup accessGroup, int startingIndex, int requestedCount) {
        return DAOFactory.getMusicTrackDAO().retrieveRandomMusicTracks(max, startingIndex, requestedCount, accessGroup);
    }

    public static int getNumberOfRandomSongs(int max, AccessGroup accessGroup) {
        return DAOFactory.getMusicTrackDAO().retrieveRandomMusicTracksCount(max, accessGroup);
    }

    public static List<MusicAlbum> getListOfRandomAlbums(int max, int startingIndex, int requestedCount) {
        return DAOFactory.getMusicAlbumDAO().retrieveRandomAlbums(max, startingIndex, requestedCount);
    }

    public static int getNumberOfRandomAlbums(int max) {
        return DAOFactory.getMusicAlbumDAO().retrieveRandomAlbumsCount(max);
    }

    public static MusicTrack getSong(Long musicTrackId) {
        if (musicTrackId != null) {
            return (MusicTrack)DAOFactory.getMusicTrackDAO().read(musicTrackId);
        }
        return null;
    }

    public static List<MusicAlbum> getListOfAlbumsForTrackRole(Long artistId, Person.RoleType role, int startingIndex, int requestedCount) {
        return DAOFactory.getMusicAlbumDAO().retrieveMusicAlbumsForTrackRole(artistId, role, startingIndex, requestedCount);
    }

    public static int getNumberOfAlbumsForTrackRole(Long artistId, Person.RoleType role) {
        return DAOFactory.getMusicAlbumDAO().retrieveMusicAlbumsForTrackRoleCount(artistId, role);
    }

    public static List<MusicAlbum> getListOfAlbumsForTrackRole(String artistName, Person.RoleType role, int startingIndex, int requestedCount) {
        return DAOFactory.getMusicAlbumDAO().retrieveMusicAlbumsForTrackRole(artistName, role, startingIndex, requestedCount);
    }

    public static int getNumberOfAlbumsForTrackRole(String artistName, Person.RoleType role) {
        return DAOFactory.getMusicAlbumDAO().retrieveMusicAlbumsForTrackRoleCount(artistName, role);
    }

    public static List<MusicAlbum> getListOfAlbumsForAlbumArtist(Long artistId, int startingIndex, int requestedCount) {
        return DAOFactory.getMusicAlbumDAO().retrieveMusicAlbumsForAlbumArtist(artistId, startingIndex, requestedCount);
    }

    public static int getNumberOfAlbumsForAlbumArtist(Long artistId) {
        return DAOFactory.getMusicAlbumDAO().retrieveMusicAlbumsForAlbumArtistCount(artistId);
    }

    public static List<MusicTrack> getListOfSongsForTrackRoleAndAlbum(Long artistId, Person.RoleType role, Long albumId, AccessGroup accessGroup, int startingIndex, int requestedCount) {
        return DAOFactory.getMusicTrackDAO().retrieveMusicTracksForTrackRoleAndAlbum(artistId, role, albumId, accessGroup, startingIndex, requestedCount);
    }

    public static int getNumberOfSongsForTrackRoleAndAlbum(Long artistId, Person.RoleType role, Long albumId, AccessGroup accessGroup) {
        return DAOFactory.getMusicTrackDAO().retrieveMusicTracksForTrackRoleAndAlbumCount(artistId, role, albumId, accessGroup);
    }

    public static List<MusicTrack> getListOfSongsForAlbum(Long albumId, AccessGroup accessGroup, int startingIndex, int requestedCount) {
        return DAOFactory.getMusicTrackDAO().retrieveMusicTracksForAlbum(albumId, accessGroup, startingIndex, requestedCount);
    }

    public static int getNumberOfSongsForAlbum(Long albumId, AccessGroup accessGroup) {
        return DAOFactory.getMusicTrackDAO().retrieveMusicTracksForAlbumCount(albumId, accessGroup);
    }

    public static List<MusicAlbum> getListOfAllAlbums(int startingIndex, int requestedCount) {
        return DAOFactory.getMusicAlbumDAO().retrieveAllMusicAlbums(startingIndex, requestedCount);
    }

    public static int getNumberOfAllAlbums() {
        return DAOFactory.getMusicAlbumDAO().retrieveAllMusicAlbumsCount();
    }

    public static List<MusicAlbum> getListOfLastViewedAlbums(int max, AccessGroup accessGroup, int startIndex, int count) {
        return DAOFactory.getMusicAlbumDAO().retrieveLastViewedMusicAlbums(max, startIndex, count, accessGroup);
    }

    public static int getNumberOfLastViewedAlbums(int max, AccessGroup accessGroup) {
        return DAOFactory.getMusicAlbumDAO().retrieveLastViewedMusicAlbumsCount(max, accessGroup);
    }

    public static MusicAlbum getMusicAlbum(Long albumId) {
        if (albumId != null) {
            return (MusicAlbum)DAOFactory.getMusicAlbumDAO().read(albumId);
        }
        return null;
    }

    private static void removeAlbum(MusicTrack track) {
        int numberOfTracks;
        if (track.getAlbumId() != null && (numberOfTracks = DAOFactory.getMusicAlbumDAO().getNumberOfTracks(track.getAlbumId())) == 0) {
            List<Long> removedPersonIds = DAOFactory.getPersonDAO().removeAllPersonsFromMusicAlbum(track.getAlbumId());
            DAOFactory.getMusicAlbumDAO().delete(track.getAlbumId());
            SearchManager.getInstance().localIndexer().metadataRemoved(SearchIndexer.SearchCategory.ALBUMS, track.getAlbumId());
            for (Long personId : removedPersonIds) {
                SearchManager.getInstance().localIndexer().metadataRemoved(SearchIndexer.SearchCategory.ALBUM_ARTISTS, personId);
            }
        }
    }

    private static Long findOrCreateAlbum(AudioMetadata metadata) {
        if (ObjectValidator.isNotEmpty(metadata.getAlbum())) {
            String albumArtist = metadata.getAlbumArtist();
            MusicAlbum album = DAOFactory.getMusicAlbumDAO().findAlbum(metadata.getAlbum(), albumArtist);
            if (album == null) {
                log.debug(String.format("Album %s (%s) not found, creating a new one", metadata.getAlbum(), albumArtist));
                album = new MusicAlbum(metadata.getAlbum());
                Long albumId = DAOFactory.getMusicAlbumDAO().create(album);
                DAOFactory.getPersonDAO().addPersonToMusicAlbum(metadata.getAlbumArtist(), Person.RoleType.ALBUM_ARTIST, albumId);
                return albumId;
            }
            log.debug(String.format("Album %s found, attaching the music track to it", album.getTitle()));
            return album.getId();
        }
        return null;
    }
}

