/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.local.metadata.extractor.video;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.imaging.ImageInfo;
import org.apache.commons.imaging.Imaging;
import org.serviio.config.Configuration;
import org.serviio.library.local.OnlineDBIdentifier;
import org.serviio.library.local.metadata.ImageDescriptor;
import org.serviio.library.local.metadata.VideoMetadata;
import org.serviio.library.local.metadata.extractor.MetadataSourceNotAccessibleException;
import org.serviio.library.local.metadata.extractor.video.SearchSourceAdaptor;
import org.serviio.library.local.metadata.extractor.video.VideoDescription;
import org.serviio.util.HttpClient;
import org.serviio.util.NumberUtils;
import org.serviio.util.ObjectValidator;
import org.serviio.util.StringUtils;
import org.serviio.util.XPathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TheTVDBSourceAdaptor
implements SearchSourceAdaptor {
    private static final String APIKEY = "235C8CA4529142E9";
    private static final String API_BASE_CONTEXT = "/api/";
    private static final String MAIN_SERVER_URL = "http://thetvdb.com";
    private static List<String> xmlMirrors = new ArrayList<String>();
    private static List<String> bannerMirrors = new ArrayList<String>();
    private static final Logger log = LoggerFactory.getLogger(TheTVDBSourceAdaptor.class);
    private static final DateFormat firstAiredDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private String seriesId;
    private String episodeXML;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void retrieveMetadata(String episodeId, VideoMetadata videoMetadata) throws IOException, MetadataSourceNotAccessibleException {
        String seriesXML = this.getSeriesDetails(this.seriesId);
        if (!ObjectValidator.isNotEmpty(seriesXML) || !ObjectValidator.isNotEmpty(this.episodeXML)) throw new IOException("Series metadata is missing");
        try {
            Node rootSeriesNode = XPathUtil.getRootNode(seriesXML);
            Node seriesNode = XPathUtil.getNode(rootSeriesNode, "Data/Series");
            String actors = XPathUtil.getNodeValue(seriesNode, "Actors");
            videoMetadata.setActors(this.splitMultiValue(actors));
            videoMetadata.setSeriesName(StringUtils.trim(XPathUtil.getNodeValue(seriesNode, "SeriesName")));
            Node rootEpisodeNode = XPathUtil.getRootNode(this.episodeXML);
            Node episodeNode = XPathUtil.getNode(rootEpisodeNode, "Data/Episode");
            videoMetadata.setTitle(StringUtils.trim(XPathUtil.getNodeValue(episodeNode, "EpisodeName")));
            videoMetadata.setDirectors(this.splitMultiValue(XPathUtil.getNodeValue(episodeNode, "Director")));
            videoMetadata.setDescription(StringUtils.trim(XPathUtil.getNodeValue(episodeNode, "Overview")));
            videoMetadata.setDate(this.getFirstAiredDate(XPathUtil.getNodeValue(episodeNode, "FirstAired")));
            String seasonNumber = StringUtils.trim(XPathUtil.getNodeValue(episodeNode, "SeasonNumber"));
            String episodeNumber = StringUtils.trim(XPathUtil.getNodeValue(episodeNode, "EpisodeNumber"));
            videoMetadata.setSeasonNumber(ObjectValidator.isNotEmpty(seasonNumber) ? Integer.valueOf(seasonNumber) : null);
            videoMetadata.setEpisodeNumber(ObjectValidator.isNotEmpty(episodeNumber) ? Integer.valueOf(episodeNumber) : null);
            videoMetadata.getOnlineIdentifiers().put(OnlineDBIdentifier.TVDB, episodeId);
            String imdbId = XPathUtil.getNodeValue(episodeNode, "IMDB_ID");
            if (ObjectValidator.isNotEmpty(imdbId)) {
                videoMetadata.getOnlineIdentifiers().put(OnlineDBIdentifier.IMDB, imdbId.trim());
            }
            if (!Configuration.isRetrieveArtFromOnlineSources()) return;
            String episodeBannerFile = XPathUtil.getNodeValue(episodeNode, "filename");
            videoMetadata.setCoverImage(this.loadImage(episodeBannerFile));
            String seriesPoster = XPathUtil.getNodeValue(seriesNode, "poster");
            if (ObjectValidator.isEmpty(seriesPoster)) {
                seriesPoster = XPathUtil.getNodeValue(seriesNode, "fanart");
            }
            videoMetadata.setSeriesCoverImage(this.loadImage(seriesPoster));
            return;
        }
        catch (XPathExpressionException e) {
            throw new IOException(String.format("Cannot retrieve metadata for episode %s from tvdb.com, the returned XML is corrupt", episodeId));
        }
    }

    @Override
    public String search(VideoDescription description) throws IOException, MetadataSourceNotAccessibleException {
        TheTVDBSourceAdaptor.setupMirrors();
        String episodeId = null;
        int i = 0;
        while (this.seriesId == null && i < description.getNames().length) {
            this.seriesId = this.searchForSeries(description.getNames()[i++], description.getYear());
        }
        if (this.seriesId == null && description.getYear() != null) {
            i = 0;
            while (this.seriesId == null && i < description.getNames().length) {
                this.seriesId = this.searchForSeries(description.getNames()[i++], null);
            }
        }
        if (this.seriesId != null) {
            episodeId = this.getEpisodeDetails(this.seriesId, description.getSeason(), description.getEpisode());
        }
        return episodeId;
    }

    private static void setupMirrors() throws IOException, MetadataSourceNotAccessibleException {
        block8: {
            if (xmlMirrors.isEmpty() || bannerMirrors.isEmpty()) {
                String path = String.format("%s%s%s/mirrors.xml", MAIN_SERVER_URL, API_BASE_CONTEXT, APIKEY);
                try {
                    String mirrorsXML = TheTVDBSourceAdaptor.retrieveXMLFromUrl(path);
                    if (ObjectValidator.isNotEmpty(mirrorsXML)) {
                        Node rootNode = XPathUtil.getRootNode(mirrorsXML);
                        NodeList mirrorNodes = XPathUtil.getNodeSet(rootNode, "Mirrors/Mirror");
                        log.debug(String.format("Found %s mirror(s)", mirrorNodes.getLength()));
                        for (int i = 0; i < mirrorNodes.getLength(); ++i) {
                            Node mirrorNode = mirrorNodes.item(i);
                            Integer typeMask = Integer.parseInt(XPathUtil.getNodeValue(mirrorNode, "typemask"));
                            String mirrorPath = XPathUtil.getNodeValue(mirrorNode, "mirrorpath");
                            if (typeMask == 1 || typeMask == 3 || typeMask == 7) {
                                xmlMirrors.add(mirrorPath);
                            }
                            if (typeMask != 2 && typeMask != 3 && typeMask != 7) continue;
                            bannerMirrors.add(mirrorPath);
                        }
                        break block8;
                    }
                    throw new IOException("Cannot retrieve list of mirrors for tvdb.com, returned document is empty");
                }
                catch (FileNotFoundException fnfe) {
                    throw new IOException("Cannot retrieve list of mirrors for tvdb.com, file not found");
                }
                catch (MetadataSourceNotAccessibleException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IOException(String.format("Cannot retrieve list of mirrors for tvdb.com: %s", e.getMessage()), e);
                }
            }
        }
    }

    private String searchForSeries(String seriesName, Integer year) throws IOException {
        block10: {
            if (ObjectValidator.isNotEmpty(seriesName)) {
                String seriesNameSearchString = String.format("%s%s", seriesName, year != null ? " " + year.toString() : "");
                log.debug(String.format("Searching for series '%s'", seriesNameSearchString));
                try {
                    String seriesSearchPath = String.format("%s%sGetSeries.php?seriesname=%s&language=all", MAIN_SERVER_URL, API_BASE_CONTEXT, URLEncoder.encode(seriesNameSearchString, "UTF-8"));
                    String searchResultXML = TheTVDBSourceAdaptor.retrieveXMLFromUrl(seriesSearchPath);
                    if (ObjectValidator.isNotEmpty(searchResultXML)) {
                        try {
                            Node rootNode = XPathUtil.getRootNode(searchResultXML);
                            Node errorNode = XPathUtil.getNode(rootNode, "Error");
                            if (errorNode == null) {
                                NodeList seriesNodes = XPathUtil.getNodeSet(rootNode, "Data/Series");
                                if (seriesNodes != null && seriesNodes.getLength() > 0) {
                                    log.debug(String.format("Found %s series (or translations), using the first one", seriesNodes.getLength()));
                                    Node seriesNode = seriesNodes.item(0);
                                    String seriesId = XPathUtil.getNodeValue(seriesNode, "seriesid");
                                    return seriesId;
                                }
                            } else {
                                throw new IOException("Cannot retrieve series search results for tvdb.com, an error was returned");
                            }
                            log.debug("No series with the name has been found");
                            break block10;
                        }
                        catch (XPathExpressionException e) {
                            throw new IOException("Cannot retrieve series search results for tvdb.com, the returned XML is corrupt");
                        }
                    }
                    throw new IOException("Cannot retrieve series search results for tvdb.com, returned document is empty");
                }
                catch (FileNotFoundException fnfe) {
                    throw new IOException("Cannot retrieve series search results for tvdb.com, file not found");
                }
                catch (Exception e) {
                    throw new IOException(String.format("Cannot retrieve series search results for tvdb.com: %s", e.getMessage()));
                }
            }
        }
        return null;
    }

    private String getEpisodeDetails(String seriesId, int season, int episode) throws IOException, MetadataSourceNotAccessibleException {
        String languageCode = Configuration.getMetadataPreferredLanguage();
        log.debug(String.format("Retrieving details of episode (seriesId = %s, season = %s, episode = %s, language = %s)", seriesId, season, episode, languageCode));
        try {
            String episodeDetailsPath = String.format("%s%s%s/series/%s/default/%s/%s/%s.xml", this.getXMLMirror(), API_BASE_CONTEXT, APIKEY, seriesId, season, episode, languageCode);
            this.episodeXML = TheTVDBSourceAdaptor.retrieveXMLFromUrl(episodeDetailsPath);
            if (ObjectValidator.isNotEmpty(this.episodeXML)) {
                Node rootNode = XPathUtil.getRootNode(this.episodeXML);
                String episodeId = XPathUtil.getNodeValue(rootNode, "Data/Episode/id");
                return episodeId;
            }
            throw new IOException("Cannot retrieve episode details, returned document is empty");
        }
        catch (FileNotFoundException fnfe) {
            throw new IOException(String.format("Cannot retrieve episode details (series = %s, season = %s, episode = %s), file not found", seriesId, season, episode));
        }
        catch (MetadataSourceNotAccessibleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(String.format("Cannot retrieve episode details (series = %s, season = %s, episode = %s): %s", seriesId, season, episode, e.getMessage()));
        }
    }

    private String getSeriesDetails(String seriesId) throws IOException, MetadataSourceNotAccessibleException {
        String languageCode = Configuration.getMetadataPreferredLanguage();
        log.debug(String.format("Retrieving details of series (seriesId = %s, language = %s)", seriesId, languageCode));
        try {
            String seriesDetailsPath = String.format("%s%s%s/series/%s/%s.xml", this.getXMLMirror(), API_BASE_CONTEXT, APIKEY, seriesId, languageCode);
            String seriesXML = TheTVDBSourceAdaptor.retrieveXMLFromUrl(seriesDetailsPath);
            return seriesXML;
        }
        catch (FileNotFoundException fnfe) {
            throw new IOException(String.format("Cannot retrieve series details (series = %s), file not found", seriesId));
        }
        catch (MetadataSourceNotAccessibleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(String.format("Cannot retrieve series details (series = %s): %s", seriesId, e.getMessage()));
        }
    }

    private String getBannerMirror() {
        int index = NumberUtils.getRandomInInterval(0, bannerMirrors.size() - 1);
        return bannerMirrors.get(index);
    }

    private String getXMLMirror() {
        int index = NumberUtils.getRandomInInterval(0, xmlMirrors.size() - 1);
        return xmlMirrors.get(index);
    }

    private List<String> splitMultiValue(String value) {
        if (ObjectValidator.isNotEmpty(value)) {
            if (value.startsWith("|")) {
                value = value.substring(1);
            }
            if (value.endsWith("|")) {
                value = value.substring(0, value.length() - 1);
            }
            return Arrays.asList(value.split("\\|"));
        }
        return Collections.emptyList();
    }

    private Date getFirstAiredDate(String firstAiredDateString) {
        if (ObjectValidator.isNotEmpty(firstAiredDateString)) {
            try {
                Date firstAiredDate = firstAiredDateFormat.parse(firstAiredDateString.trim());
                return firstAiredDate;
            }
            catch (ParseException e) {
                return null;
            }
        }
        return null;
    }

    private static String retrieveXMLFromUrl(String url) throws MetadataSourceNotAccessibleException, IOException {
        String xml = null;
        try {
            xml = HttpClient.retrieveTextFileFromURL(url, "UTF-8");
        }
        catch (IOException e) {
            throw new MetadataSourceNotAccessibleException("Error connecting to thetvdb.com: " + e.getMessage(), e);
        }
        try {
            XPathUtil.getRootNode(xml);
        }
        catch (Exception e) {
            log.debug("Retrieved XML cannot be parsed, it might be a gzip file. Trying unzipping it.");
            xml = HttpClient.retrieveGZippedTextFileFromURL(url, "UTF-8");
            try {
                XPathUtil.getRootNode(xml);
            }
            catch (Exception e1) {
                throw new IOException("Failed to parse retrieved file (even unpacked version)");
            }
        }
        return xml;
    }

    private ImageDescriptor loadImage(String bannerFile) {
        if (ObjectValidator.isNotEmpty(bannerFile)) {
            try {
                String bannerPath = String.format("%s/banners/%s", this.getBannerMirror(), bannerFile);
                byte[] bannerBytes = HttpClient.retrieveBinaryFileFromURL(bannerPath);
                ImageInfo imageInfo = Imaging.getImageInfo((byte[])bannerBytes);
                ImageDescriptor image = new ImageDescriptor(bannerBytes, imageInfo.getMimeType());
                log.debug(String.format("Retrieved banner: %s", bannerPath));
                return image;
            }
            catch (Exception e) {
                log.warn(String.format("Cannot retrieve banner: %s", e.getMessage()));
            }
        }
        return null;
    }
}

