/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.local.metadata.extractor.video;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.imaging.ImageInfo;
import org.apache.commons.imaging.Imaging;
import org.serviio.config.Configuration;
import org.serviio.library.local.OnlineDBIdentifier;
import org.serviio.library.local.metadata.ImageDescriptor;
import org.serviio.library.local.metadata.MPAARating;
import org.serviio.library.local.metadata.VideoMetadata;
import org.serviio.library.local.metadata.extractor.MetadataSourceNotAccessibleException;
import org.serviio.library.local.metadata.extractor.video.SearchSourceAdaptor;
import org.serviio.library.local.metadata.extractor.video.VideoDescription;
import org.serviio.util.HttpClient;
import org.serviio.util.JsonUtils;
import org.serviio.util.ObjectValidator;
import org.serviio.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TheMovieDBSourceAdaptor
implements SearchSourceAdaptor {
    private static final String APIKEY = "33a37a299fe4bef416e347c2fca2494c";
    private static final String API_BASE_CONTEXT = "http://api.themoviedb.org/3/";
    private static String IMAGE_URL_BASE;
    private static final Logger log;
    private static final DateFormat releaseDateFormat;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void retrieveMetadata(String movieId, VideoMetadata videoMetadata) throws IOException, MetadataSourceNotAccessibleException {
        String movieJSON = this.getMovieDetails(movieId);
        if (!ObjectValidator.isNotEmpty(movieJSON)) throw new IOException("Metadata XML file is missing");
        try {
            String posterPath;
            Map<String, Object> json = JsonUtils.parseJson(movieJSON);
            videoMetadata.setTitle(this.getMovieTitle(json));
            videoMetadata.setDescription(TheMovieDBSourceAdaptor.getJsonFieldValue("overview", json));
            videoMetadata.setGenre(this.getGenre(json));
            videoMetadata.setDate(this.getReleaseDate(json));
            videoMetadata.setActors(this.getCast(json));
            videoMetadata.setDirectors(this.getCrew(json, "Director"));
            videoMetadata.setProducers(this.getCrew(json, "Producer"));
            videoMetadata.setMPAARating(this.getMPAARating(json));
            videoMetadata.getOnlineIdentifiers().put(OnlineDBIdentifier.TMDB, movieId);
            String imdbId = TheMovieDBSourceAdaptor.getJsonFieldValue("imdb_id", json);
            if (ObjectValidator.isNotEmpty(imdbId)) {
                videoMetadata.getOnlineIdentifiers().put(OnlineDBIdentifier.IMDB, imdbId.trim());
            }
            if (!Configuration.isRetrieveArtFromOnlineSources() || !ObjectValidator.isNotEmpty(posterPath = TheMovieDBSourceAdaptor.getJsonFieldValue("poster_path", json))) return;
            String posterURL = String.format("%sw500%s", IMAGE_URL_BASE, posterPath);
            try {
                byte[] bannerBytes = HttpClient.retrieveBinaryFileFromURL(posterURL);
                ImageInfo imageInfo = Imaging.getImageInfo((byte[])bannerBytes);
                ImageDescriptor image = new ImageDescriptor(bannerBytes, imageInfo.getMimeType());
                videoMetadata.setCoverImage(image);
                log.debug(String.format("Retrieved poster: %s", posterURL));
                return;
            }
            catch (FileNotFoundException e) {
                log.warn(String.format("Poster '%s' doesn't exist, will try another one", posterURL));
                return;
            }
            catch (Exception e) {
                log.warn(String.format("Cannot retrieve movie poster: %s", e.getMessage()));
            }
            return;
        }
        catch (Exception e) {
            throw new IOException(String.format("Metadata XML for movie id %s is corrupt. ", movieId));
        }
    }

    @Override
    public String search(VideoDescription description) throws IOException, MetadataSourceNotAccessibleException {
        String movieId = this.searchForMovie(description.getNames(), description.getYear());
        return movieId;
    }

    private String searchForMovie(String[] movieNames, Integer releaseYear) throws IOException, MetadataSourceNotAccessibleException {
        block4: {
            List<Map<String, Object>> returnedMovieNodes = this.findAllSearchMatches(movieNames, releaseYear);
            if (returnedMovieNodes.size() > 0) {
                try {
                    List<Map<String, Object>> moviesWithMatchingName = this.filterMovieNodesForNameMatch(returnedMovieNodes, movieNames);
                    Map<String, Object> matchingMovieNode = null;
                    matchingMovieNode = moviesWithMatchingName.size() > 0 ? moviesWithMatchingName.get(0) : returnedMovieNodes.get(0);
                    if (matchingMovieNode != null) {
                        String movieId = matchingMovieNode.get("id").toString();
                        log.debug(String.format("Found a suitable movie match, id = %s", movieId));
                        return movieId;
                    }
                    break block4;
                }
                catch (Exception e) {
                    throw new IOException(String.format("Cannot retrieve movie search results: %s", e.getMessage()));
                }
            }
            log.debug("No movie with the name has been found");
        }
        return null;
    }

    private List<Map<String, Object>> findAllSearchMatches(String[] movieNames, Integer year) throws IOException, MetadataSourceNotAccessibleException {
        ArrayList<Map<String, Object>> allReturnedNodes = new ArrayList<Map<String, Object>>();
        String languageCode = Configuration.getMetadataPreferredLanguage();
        for (String movieName : movieNames) {
            if (!ObjectValidator.isNotEmpty(movieName)) continue;
            log.debug(String.format("Searching for movie '%s' %s (language: %s)", movieName, year != null ? year : "", languageCode));
            try {
                String searchResultJSON;
                String moviesSearchPath = String.format("%ssearch/movie?query=%s&api_key=%s&language=%s&search_type=phrase&include_adult=true", API_BASE_CONTEXT, URLEncoder.encode(movieName, "UTF-8"), APIKEY, languageCode);
                if (year != null) {
                    moviesSearchPath = moviesSearchPath + "&year=" + year;
                }
                if (ObjectValidator.isNotEmpty(searchResultJSON = TheMovieDBSourceAdaptor.getContentFromUrl(moviesSearchPath))) {
                    Map<String, Object> json = JsonUtils.parseJson(searchResultJSON);
                    Integer numberReturned = Integer.parseInt(json.get("total_results").toString());
                    log.debug(String.format("Found %s matches", numberReturned));
                    if (numberReturned <= 0) continue;
                    allReturnedNodes.addAll((List)json.get("results"));
                    continue;
                }
                log.warn("Cannot retrieve movie search results, unrecognizable file returned (possibly error)");
            }
            catch (MetadataSourceNotAccessibleException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(String.format("Cannot retrieve movie search results: %s", e.getMessage()));
            }
        }
        return allReturnedNodes;
    }

    private static String getContentFromUrl(String url) throws MetadataSourceNotAccessibleException {
        try {
            return HttpClient.retrieveTextFileFromURL(url, "UTF-8");
        }
        catch (IOException e) {
            throw new MetadataSourceNotAccessibleException("Error connecting to themoviedb.com: " + e.getMessage(), e);
        }
    }

    private String getMovieDetails(String movieId) throws IOException, MetadataSourceNotAccessibleException {
        String languageCode = Configuration.getMetadataPreferredLanguage();
        log.debug(String.format("Retrieving details of movie (movieId = %s, language = %s)", movieId, languageCode));
        try {
            String movieDetailsPath = String.format("%smovie/%s?api_key=%s&language=%s&append_to_response=casts,releases", API_BASE_CONTEXT, movieId, APIKEY, languageCode);
            String movieJson = TheMovieDBSourceAdaptor.getContentFromUrl(movieDetailsPath);
            if (ObjectValidator.isNotEmpty(movieJson)) {
                return movieJson;
            }
            throw new IOException("Cannot retrieve movie details, returned document is empty (possible error)");
        }
        catch (FileNotFoundException fnfe) {
            throw new IOException(String.format("Cannot retrieve movie details (movieId = %s), file not found", movieId));
        }
        catch (MetadataSourceNotAccessibleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(String.format("Cannot retrieve movie details (movieId = %s): %s", movieId, e.getMessage()));
        }
    }

    private List<Map<String, Object>> filterMovieNodesForNameMatch(List<Map<String, Object>> movieNodes, String[] movieNames) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        if (movieNodes != null && movieNodes.size() > 0) {
            block0: for (int i = 0; i < movieNodes.size(); ++i) {
                Map<String, Object> movieNode = movieNodes.get(i);
                String name = TheMovieDBSourceAdaptor.getJsonFieldValue("title", movieNode);
                String originalName = TheMovieDBSourceAdaptor.getJsonFieldValue("original_title", movieNode);
                for (String movieName : movieNames) {
                    if (movieName == null) continue;
                    String trimmedMovieName = StringUtils.localeSafeToLowercase(movieName).trim();
                    if ((name == null || !trimmedMovieName.equalsIgnoreCase(name.trim())) && (originalName == null || !trimmedMovieName.equalsIgnoreCase(originalName.trim()))) continue;
                    result.add(movieNode);
                    continue block0;
                }
            }
        }
        return result;
    }

    private List<String> getCast(Map<String, Object> json) {
        List crew;
        ArrayList<String> result = new ArrayList<String>();
        Map casts = (Map)json.get("casts");
        if (casts != null && (crew = (List)casts.get("cast")) != null) {
            for (int i = 0; i < crew.size(); ++i) {
                result.add(TheMovieDBSourceAdaptor.getJsonFieldValue("name", (Map)crew.get(i)));
            }
        }
        return result;
    }

    private List<String> getCrew(Map<String, Object> json, String job) {
        List crew;
        ArrayList<String> result = new ArrayList<String>();
        Map casts = (Map)json.get("casts");
        if (casts != null && (crew = (List)casts.get("crew")) != null) {
            for (int i = 0; i < crew.size(); ++i) {
                Map crewEntry = (Map)crew.get(i);
                String crewEntryJob = TheMovieDBSourceAdaptor.getJsonFieldValue("job", crewEntry);
                if (!job.equals(crewEntryJob)) continue;
                result.add(TheMovieDBSourceAdaptor.getJsonFieldValue("name", (Map)crew.get(i)));
            }
        }
        return result;
    }

    private Date getReleaseDate(Map<String, Object> json) {
        String releaseDateString = TheMovieDBSourceAdaptor.getJsonFieldValue("release_date", json);
        if (ObjectValidator.isNotEmpty(releaseDateString)) {
            try {
                Date releaseDate = releaseDateFormat.parse(releaseDateString.trim());
                return releaseDate;
            }
            catch (ParseException e) {
                return null;
            }
        }
        return null;
    }

    private String getMovieTitle(Map<String, Object> json) {
        String originalTitle;
        String title = TheMovieDBSourceAdaptor.getJsonFieldValue("title", json);
        if (Configuration.isMetadataUseOriginalTitle() && ObjectValidator.isNotEmpty(originalTitle = TheMovieDBSourceAdaptor.getJsonFieldValue("original_title", json))) {
            title = originalTitle;
        }
        return title;
    }

    private String getGenre(Map<String, Object> json) {
        List genres = (List)json.get("genres");
        if (genres.size() > 0) {
            return TheMovieDBSourceAdaptor.getJsonFieldValue("name", (Map)genres.get(0));
        }
        return null;
    }

    private static String getJsonFieldValue(String field, Map<String, Object> json) {
        return StringUtils.trim(StringUtils.toString(json.get(field)));
    }

    private static void setupImageUrl() {
        String configurationPath = String.format("%sconfiguration?api_key=%s", API_BASE_CONTEXT, APIKEY);
        try {
            String configJson = TheMovieDBSourceAdaptor.getContentFromUrl(configurationPath);
            Map<String, Object> json = JsonUtils.parseJson(configJson);
            Map images = (Map)json.get("images");
            IMAGE_URL_BASE = TheMovieDBSourceAdaptor.getJsonFieldValue("base_url", images);
        }
        catch (MetadataSourceNotAccessibleException e) {
            log.error("Cannot load themoviedb.org configuration data", (Throwable)e);
        }
    }

    private MPAARating getMPAARating(Map<String, Object> json) {
        List countries;
        Map releases = (Map)json.get("releases");
        if (releases != null && releases.size() > 0 && (countries = (List)releases.get("countries")) != null) {
            for (Map country : countries) {
                if (!country.get("iso_3166_1").toString().equalsIgnoreCase("US")) continue;
                String normalizedRating = StringUtils.localeSafeToLowercase(country.get("certification").toString());
                if (normalizedRating.equals("pg-13")) {
                    return MPAARating.PG13;
                }
                if (normalizedRating.equals("pg")) {
                    return MPAARating.PG;
                }
                if (normalizedRating.equals("g")) {
                    return MPAARating.G;
                }
                if (normalizedRating.equals("r")) {
                    return MPAARating.R;
                }
                if (!normalizedRating.equals("nc-17")) continue;
                return MPAARating.NC17;
            }
        }
        return null;
    }

    static {
        log = LoggerFactory.getLogger(TheMovieDBSourceAdaptor.class);
        releaseDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        TheMovieDBSourceAdaptor.setupImageUrl();
    }
}

