/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.local.metadata.extractor.video;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.serviio.library.entities.MediaItem;
import org.serviio.library.entities.MetadataDescriptor;
import org.serviio.library.entities.Repository;
import org.serviio.library.local.ContentType;
import org.serviio.library.local.metadata.LocalItemMetadata;
import org.serviio.library.local.metadata.VideoMetadata;
import org.serviio.library.local.metadata.extractor.ExtractorType;
import org.serviio.library.local.metadata.extractor.InvalidMediaFormatException;
import org.serviio.library.local.metadata.extractor.MetadataExtractor;
import org.serviio.library.local.metadata.extractor.MetadataFile;
import org.serviio.library.local.metadata.extractor.MetadataSourceNotAccessibleException;
import org.serviio.library.local.metadata.extractor.video.FileNameParser;
import org.serviio.library.local.metadata.extractor.video.SearchSourceAdaptor;
import org.serviio.library.local.metadata.extractor.video.SearchSourceFactory;
import org.serviio.library.local.metadata.extractor.video.TheMovieDBSourceAdaptor;
import org.serviio.library.local.metadata.extractor.video.TheTVDBSourceAdaptor;
import org.serviio.library.local.metadata.extractor.video.VideoDescription;
import org.serviio.library.metadata.MediaFileType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineVideoSourcesMetadataExtractor
extends MetadataExtractor {
    private static final Logger log = LoggerFactory.getLogger(OnlineVideoSourcesMetadataExtractor.class);

    @Override
    public ExtractorType getExtractorType() {
        return ExtractorType.ONLINE_VIDEO_SOURCES;
    }

    @Override
    protected MetadataFile getMetadataFile(File mediaFile, MediaFileType fileType, Repository repository) throws IOException, MetadataSourceNotAccessibleException {
        VideoDescription videoDescription = FileNameParser.parse(mediaFile, repository);
        if (videoDescription.isSearchRecommended() && videoDescription.getType() != VideoDescription.VideoType.SPECIAL && fileType == MediaFileType.VIDEO) {
            SearchSourceAdaptor adaptor = SearchSourceFactory.getSearchSourceAdaptor(videoDescription.getType());
            if (adaptor != null) {
                String metadataId = adaptor.search(videoDescription);
                if (metadataId != null) {
                    MetadataFile metadataFile = new MetadataFile(this.getExtractorType(), new Date(), metadataId, adaptor);
                    return metadataFile;
                }
                log.warn(String.format("Online metadata search returned no results for file %s [%s]", mediaFile.getName(), videoDescription.toString()));
                return null;
            }
            return null;
        }
        return null;
    }

    @Override
    public boolean isMetadataUpdated(File mediaFile, MediaItem mediaItem, MetadataDescriptor metadataDescriptor) {
        return metadataDescriptor == null;
    }

    @Override
    protected void retrieveMetadata(MetadataFile metadataDescriptor, LocalItemMetadata metadata) throws IOException, InvalidMediaFormatException, MetadataSourceNotAccessibleException {
        SearchSourceAdaptor adaptor = (SearchSourceAdaptor)metadataDescriptor.getExtractable();
        adaptor.retrieveMetadata(metadataDescriptor.getIdentifier(), (VideoMetadata)metadata);
        this.setMetadataContentType((VideoMetadata)metadata, (SearchSourceAdaptor)metadataDescriptor.getExtractable());
    }

    protected void setMetadataContentType(VideoMetadata metadata, SearchSourceAdaptor adaptor) {
        if (adaptor instanceof TheMovieDBSourceAdaptor) {
            metadata.setContentType(ContentType.MOVIE);
        } else if (adaptor instanceof TheTVDBSourceAdaptor) {
            metadata.setContentType(ContentType.EPISODE);
        }
    }
}

