/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.local.metadata.extractor.video;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.serviio.library.entities.Repository;
import org.serviio.library.local.metadata.extractor.video.VideoDescription;
import org.serviio.util.FileUtils;
import org.serviio.util.StringUtils;

public class FileNameParser {
    private static Pattern[] EPISODIC_PATTERNS = new Pattern[]{Pattern.compile("[s]([\\d]+)[e]([\\d]+).*", 2), Pattern.compile("[s]([\\d]+)\\.[e]([\\d]+).*", 2), Pattern.compile("([\\d]+)[x]([\\d]+)", 2), Pattern.compile("[s]([\\d]+)_[e]([\\d]+).*", 2), Pattern.compile("^([\\d])[\\s]([\\d]{2,2})", 2), Pattern.compile("^([\\d]{1,2})[\\s]([\\d]{2,2})", 2), Pattern.compile("([\\d]{1,2})[\\s]{0,1}-[\\s]{0,1}([\\d]{1,2})[\\s]*-", 2), Pattern.compile("season\\s([\\d]+)\\sepisode\\s([\\d]+).*", 2)};
    private static Pattern[] SPECIAL_PATTERNS = new Pattern[]{Pattern.compile(".*trailer.*", 2), Pattern.compile(".*sample.*", 2)};
    private static Pattern MOVIE_YEAR_PATTERN = Pattern.compile("(?<!^)[\\[\\(]?(\\b\\d{4}\\b)[\\]\\)]?");
    private static Pattern SERIES_YEAR_PATTERN = Pattern.compile("[\\[\\(](\\d{4})[\\]\\)]");

    public static VideoDescription parse(File videoFile, Repository repository) {
        Pattern descriptionPattern = FileNameParser.getEpisodeMatch(videoFile);
        if (descriptionPattern != null) {
            return FileNameParser.getEpisodeDescription(videoFile, descriptionPattern, repository);
        }
        if (FileNameParser.isSpecialContent(videoFile)) {
            return new VideoDescription(VideoDescription.VideoType.SPECIAL, false);
        }
        return FileNameParser.getMovieDescription(videoFile, repository);
    }

    protected static boolean isSpecialContent(File videoFile) {
        String file = FileUtils.getFileNameWithoutExtension(videoFile).trim();
        for (Pattern pattern : SPECIAL_PATTERNS) {
            Matcher m = pattern.matcher(file);
            if (!m.matches()) continue;
            return true;
        }
        return false;
    }

    protected static Pattern getEpisodeMatch(File videoFile) {
        String file = FileUtils.getFileNameWithoutExtension(videoFile).trim();
        for (Pattern pattern : EPISODIC_PATTERNS) {
            Matcher m = pattern.matcher(file);
            if (!m.find()) continue;
            return pattern;
        }
        return null;
    }

    protected static VideoDescription getEpisodeDescription(File videoFile, Pattern pattern, Repository repository) {
        Integer year = FileNameParser.getYearFromFileName(SERIES_YEAR_PATTERN, videoFile);
        Matcher m = pattern.matcher(videoFile.getName());
        if (m.find()) {
            int seasonNumber = Integer.parseInt(m.group(1));
            int episodeNumber = Integer.parseInt(m.group(2));
            String fileBasedName = FileNameParser.getVideoName(videoFile, pattern, SERIES_YEAR_PATTERN, true, false);
            String folderBasedName = FileNameParser.getParentFolderBasedName(videoFile, repository);
            return new VideoDescription(VideoDescription.VideoType.EPISODE, true, new String[]{fileBasedName, folderBasedName}, seasonNumber, episodeNumber, year);
        }
        return new VideoDescription(VideoDescription.VideoType.EPISODE, false);
    }

    protected static VideoDescription getMovieDescription(File videoFile, Repository repository) {
        Integer year = FileNameParser.getYearFromFileName(MOVIE_YEAR_PATTERN, videoFile);
        String fileBasedName = FileNameParser.getVideoName(videoFile, null, MOVIE_YEAR_PATTERN, false, false);
        String folderBasedName = FileNameParser.getParentFolderBasedName(videoFile, repository);
        return new VideoDescription(VideoDescription.VideoType.FILM, true, new String[]{fileBasedName, folderBasedName}, year);
    }

    private static Integer getYearFromFileName(Pattern pattern, File videoFile) {
        Matcher m = pattern.matcher(videoFile.getName());
        Integer year = FileNameParser.findYearInString(m);
        if (year == null) {
            File folder = FileNameParser.getSuitableParentFolder(videoFile.getParentFile());
            m = pattern.matcher(folder.getName());
            year = FileNameParser.findYearInString(m);
        }
        return year;
    }

    private static Integer findYearInString(Matcher m) {
        Integer year = null;
        while (m.find()) {
            year = Integer.parseInt(m.group(1));
        }
        return year;
    }

    protected static String getVideoName(File videoFile, Pattern patternToDelete, Pattern yearPattern, boolean episodic, boolean folder) {
        if (FileNameParser.isFileNameNondescriptive(videoFile.getPath())) {
            return null;
        }
        String file = videoFile.getName().trim();
        if (!folder) {
            file = FileUtils.getFileNameWithoutExtension(videoFile).trim();
        }
        if (patternToDelete != null) {
            file = patternToDelete.matcher(file).replaceAll("");
        }
        if (episodic && !folder && file.indexOf("-") > -1) {
            file = file.substring(0, file.indexOf("-"));
        }
        file = file.replaceAll("(?<!\\.)\\.(?!\\.)", " ").trim();
        file = file.replaceAll("[_]", " ").trim();
        if (!folder) {
            file = file.replaceAll("-", " ").trim();
        }
        if (StringUtils.localeSafeToLowercase(file).endsWith("the") && (file = "the " + file.substring(0, file.length() - 3).trim()).endsWith(",")) {
            file = file.substring(0, file.length() - 1);
        }
        file = StringUtils.replaceLast(file, yearPattern, "", false);
        file = file.replaceAll("(\\[).*(\\])", "");
        file = file.replaceAll("(?<!^)(\\b[A-Z]{4,}\\b).*", "");
        file = StringUtils.localeSafeToLowercase(file);
        file = file.replaceAll("(dvdrip|dvd-rip|bdrip|bd-rip|dvd|xvid|divx|xv|xvi|hd|hdtv|1080|720).*", "");
        file = file.replaceAll("\\s{2,}", " ");
        return file.trim();
    }

    protected static String getParentFolderBasedName(File videoFile, Repository repository) {
        File repositoryFolder = repository.getFolder();
        if (videoFile.getParentFile() != null && !videoFile.getParentFile().equals(repositoryFolder)) {
            File folder = FileNameParser.getSuitableParentFolder(videoFile.getParentFile());
            String folderBasedMovieName = FileNameParser.getVideoName(folder, null, MOVIE_YEAR_PATTERN, false, true);
            return folderBasedMovieName;
        }
        return null;
    }

    protected static File getSuitableParentFolder(File videoFolder) {
        String folderName;
        if (videoFolder != null && ((folderName = StringUtils.localeSafeToLowercase(videoFolder.getName())).startsWith("season") || folderName.startsWith("series") || folderName.startsWith("cd") || folderName.startsWith("video_ts"))) {
            return FileNameParser.getSuitableParentFolder(videoFolder.getParentFile());
        }
        return videoFolder;
    }

    protected static boolean isFileNameNondescriptive(String filePath) {
        String filePathFixed = StringUtils.localeSafeToUppercase(filePath);
        return filePathFixed.indexOf("VIDEO_TS") > -1 || filePathFixed.indexOf("VTS_") > -1;
    }
}

