/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.local.metadata.extractor.embedded.h264;

import java.io.IOException;
import java.io.OutputStream;
import org.serviio.library.local.metadata.extractor.embedded.h264.BufferWrapper;
import org.serviio.library.local.metadata.extractor.embedded.h264.NALUnitType;

public class NALUnit {
    public NALUnitType type;
    public int nal_ref_idc;

    public NALUnit(NALUnitType type, int nal_ref_idc) {
        this.type = type;
        this.nal_ref_idc = nal_ref_idc;
    }

    public static NALUnit read(BufferWrapper is) throws IOException {
        int nalu = is.read();
        int nal_ref_idc = nalu >> 5 & 3;
        int nb = nalu & 0x1F;
        NALUnitType type = NALUnitType.fromValue(nb);
        return new NALUnit(type, nal_ref_idc);
    }

    public void write(OutputStream out) throws IOException {
        int nalu = this.type.getValue() | this.nal_ref_idc << 5;
        out.write(nalu);
    }

    public String toString() {
        return "NALUnit{type=" + this.type + ", nal_ref_idc=" + this.nal_ref_idc + '}';
    }
}

