/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.local.metadata.extractor.embedded.h264;

import java.io.IOException;
import org.serviio.library.local.metadata.extractor.embedded.h264.BTree;
import org.serviio.library.local.metadata.extractor.embedded.h264.BitstreamReader;
import org.serviio.library.local.metadata.extractor.embedded.h264.BufferWrapper;

public class CAVLCReader
extends BitstreamReader {
    public CAVLCReader(BufferWrapper is) throws IOException {
        super(is);
    }

    public long readNBit(int n, String message) throws IOException {
        long val = this.readNBit(n);
        this.trace(message, String.valueOf(val));
        return val;
    }

    private int readUE() throws IOException {
        int cnt = 0;
        while (this.read1Bit() == 0) {
            ++cnt;
        }
        int res = 0;
        if (cnt > 0) {
            long val = this.readNBit(cnt);
            res = (int)((long)((1 << cnt) - 1) + val);
        }
        return res;
    }

    public int readUE(String message) throws IOException {
        int res = this.readUE();
        this.trace(message, String.valueOf(res));
        return res;
    }

    public int readSE(String message) throws IOException {
        int val = this.readUE();
        int sign = ((val & 1) << 1) - 1;
        val = ((val >> 1) + (val & 1)) * sign;
        this.trace(message, String.valueOf(val));
        return val;
    }

    public boolean readBool(String message) throws IOException {
        boolean res = this.read1Bit() != 0;
        this.trace(message, res ? "1" : "0");
        return res;
    }

    public int readU(int i, String string) throws IOException {
        return (int)this.readNBit(i, string);
    }

    public byte[] read(int payloadSize) throws IOException {
        byte[] result = new byte[payloadSize];
        for (int i = 0; i < payloadSize; ++i) {
            result[i] = (byte)this.readByte();
        }
        return result;
    }

    public boolean readAE() {
        throw new UnsupportedOperationException("Stan");
    }

    public int readTE(int max) throws IOException {
        if (max > 1) {
            return this.readUE();
        }
        return ~this.read1Bit() & 1;
    }

    public int readAEI() {
        throw new UnsupportedOperationException("Stan");
    }

    public int readME(String string) throws IOException {
        return this.readUE(string);
    }

    public Object readCE(BTree bt, String message) throws IOException {
        Object i;
        do {
            int bit;
            if ((bt = bt.down(bit = this.read1Bit())) != null) continue;
            throw new RuntimeException("Illegal code");
        } while ((i = bt.getValue()) == null);
        this.trace(message, i.toString());
        return i;
    }

    public int readZeroBitCount(String message) throws IOException {
        int count = 0;
        while (this.read1Bit() == 0) {
            ++count;
        }
        this.trace(message, String.valueOf(count));
        return count;
    }

    public void readTrailingBits() throws IOException {
        this.read1Bit();
        this.readRemainingByte();
    }

    private void trace(String message, String val) {
        int i;
        StringBuilder traceBuilder = new StringBuilder();
        String pos = String.valueOf(bitsRead - this.debugBits.length());
        int spaces = 8 - pos.length();
        traceBuilder.append("@" + pos);
        for (i = 0; i < spaces; ++i) {
            traceBuilder.append(' ');
        }
        traceBuilder.append(message);
        spaces = 100 - traceBuilder.length() - this.debugBits.length();
        for (i = 0; i < spaces; ++i) {
            traceBuilder.append(' ');
        }
        traceBuilder.append(this.debugBits);
        traceBuilder.append(" (" + val + ")");
        this.debugBits.clear();
    }
}

