/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.local.metadata.extractor.embedded.h264;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import org.serviio.library.local.metadata.extractor.embedded.h264.AbstractBufferWrapper;
import org.serviio.library.local.metadata.extractor.embedded.h264.BufferWrapper;

public class BufferWrapperImpl
extends AbstractBufferWrapper {
    ByteBuffer[] parents;
    int activeParent = 0;

    public BufferWrapperImpl(byte[] bytes) {
        this(ByteBuffer.wrap(bytes));
    }

    public BufferWrapperImpl(ByteBuffer parent) {
        this.parents = new ByteBuffer[]{parent};
    }

    public BufferWrapperImpl(ByteBuffer[] parents) {
        this.parents = parents;
    }

    public BufferWrapperImpl(List<ByteBuffer> parents) {
        this.parents = parents.toArray(new ByteBuffer[parents.size()]);
    }

    public BufferWrapperImpl(File file) throws IOException {
        long filelength = file.length();
        int sliceSize = 0x8000000;
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
        long i = 0L;
        while (i < filelength) {
            if (filelength - i > (long)sliceSize) {
                MappedByteBuffer bb;
                try {
                    bb = raf.getChannel().map(FileChannel.MapMode.READ_ONLY, i, sliceSize);
                }
                catch (IOException e1) {
                    try {
                        bb = raf.getChannel().map(FileChannel.MapMode.READ_ONLY, i, sliceSize);
                    }
                    catch (IOException e2) {
                        try {
                            bb = raf.getChannel().map(FileChannel.MapMode.READ_ONLY, i, sliceSize);
                        }
                        catch (IOException e3) {
                            bb = raf.getChannel().map(FileChannel.MapMode.READ_ONLY, i, sliceSize);
                        }
                    }
                }
                buffers.add(bb);
                i += (long)sliceSize;
                continue;
            }
            buffers.add(raf.getChannel().map(FileChannel.MapMode.READ_ONLY, i, filelength - i).slice());
            i += filelength - i;
        }
        this.parents = buffers.toArray(new ByteBuffer[buffers.size()]);
        raf.close();
    }

    @Override
    public long position() {
        if (this.activeParent >= 0) {
            long pos = 0L;
            for (int i = 0; i < this.activeParent; ++i) {
                pos += (long)this.parents[i].limit();
            }
            return pos += (long)this.parents[this.activeParent].position();
        }
        return this.size();
    }

    @Override
    public void position(long position) {
        if (position == this.size()) {
            this.activeParent = -1;
        } else {
            int current = 0;
            while (position >= (long)this.parents[current].limit()) {
                position -= (long)this.parents[current++].limit();
            }
            this.parents[current].position((int)position);
            this.activeParent = current;
        }
    }

    @Override
    public long size() {
        long size = 0L;
        for (ByteBuffer parent : this.parents) {
            size += (long)parent.limit();
        }
        return size;
    }

    @Override
    public long remaining() {
        if (this.activeParent == -1) {
            return 0L;
        }
        long remaining = 0L;
        for (int i = this.activeParent; i < this.parents.length; ++i) {
            remaining += (long)this.parents[i].remaining();
        }
        return remaining;
    }

    @Override
    public int read() {
        if (this.parents[this.activeParent].remaining() == 0) {
            if (this.parents.length > this.activeParent + 1) {
                ++this.activeParent;
                this.parents[this.activeParent].rewind();
                return this.read();
            }
            return -1;
        }
        int b = this.parents[this.activeParent].get();
        return b < 0 ? b + 256 : b;
    }

    @Override
    public int read(byte[] b) {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) {
        if (this.parents[this.activeParent].remaining() >= len) {
            this.parents[this.activeParent].get(b, off, len);
            return len;
        }
        int curRemaining = this.parents[this.activeParent].remaining();
        this.parents[this.activeParent].get(b, off, curRemaining);
        ++this.activeParent;
        this.parents[this.activeParent].rewind();
        return curRemaining + this.read(b, off + curRemaining, len - curRemaining);
    }

    @Override
    public BufferWrapper getSegment(long startPos, long length) {
        long savePos = this.position();
        ArrayList<ByteBuffer> segments = new ArrayList<ByteBuffer>();
        this.position(startPos);
        while (length > 0L) {
            ByteBuffer currentSlice = this.parents[this.activeParent].slice();
            if ((long)currentSlice.remaining() >= length) {
                currentSlice.limit((int)length);
                length -= length;
            } else {
                length -= (long)currentSlice.remaining();
                this.parents[++this.activeParent].rewind();
            }
            segments.add(currentSlice);
        }
        this.position(savePos);
        return new BufferWrapperImpl(segments.toArray(new ByteBuffer[segments.size()]));
    }
}

