/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.local.metadata.extractor.embedded.h264;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.serviio.library.local.metadata.extractor.embedded.h264.BufferWrapper;

public abstract class AbstractBufferWrapper
implements BufferWrapper {
    public int readBitsRemaining;
    private byte readBitsBuffer;

    @Override
    public long readUInt64() throws IOException {
        long result = 0L;
        if ((result += this.readUInt32() << 32) < 0L) {
            throw new RuntimeException("I don't know how to deal with UInt64! long is not sufficient and I don't want to use BigInt");
        }
        return result += this.readUInt32();
    }

    @Override
    public long readUInt32() throws IOException {
        long result = 0L;
        result += (long)this.readUInt16() << 16;
        return result += (long)this.readUInt16();
    }

    @Override
    public int readInt32() throws IOException {
        int ch1 = this.readUInt8();
        int ch2 = this.readUInt8();
        int ch3 = this.readUInt8();
        int ch4 = this.readUInt8();
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    @Override
    public int readUInt24() throws IOException {
        int result = 0;
        result += this.readUInt16() << 8;
        return result += this.readUInt8();
    }

    @Override
    public int readUInt16() throws IOException {
        int result = 0;
        result += this.readUInt8() << 8;
        return result += this.readUInt8();
    }

    @Override
    public int readUInt8() throws IOException {
        int b = this.readByte();
        return b < 0 ? b + 256 : b;
    }

    @Override
    public byte readByte() throws IOException {
        int b;
        if (this.readBitsRemaining != 0) {
            // empty if block
        }
        if ((b = this.read()) == -1) {
            throw new RuntimeException("Read beyond buffer's end");
        }
        return (byte)(b >= 128 ? b - 256 : b);
    }

    @Override
    public String readIso639() throws IOException {
        int bits = this.readUInt16();
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < 3; ++i) {
            int c = bits >> (2 - i) * 5 & 0x1F;
            result.append((char)(c + 96));
        }
        return result.toString();
    }

    @Override
    public String readString() throws IOException {
        byte read;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((read = this.readByte()) != 0) {
            out.write(read);
        }
        try {
            return out.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("JVM doesn't support UTF-8");
        }
    }

    @Override
    public long readUInt32BE() throws IOException {
        long result = 0L;
        result += (long)this.readUInt16BE();
        return result += (long)this.readUInt16BE() << 16;
    }

    @Override
    public int readUInt16BE() throws IOException {
        int result = 0;
        result += this.readUInt8();
        return result += this.readUInt8() << 8;
    }

    @Override
    public int readBits(int i) throws IOException {
        if (i > 31) {
            throw new IllegalArgumentException("cannot readByte more than 31 bits");
        }
        int ret = 0;
        while (i > 8) {
            int moved = this.parse8(8) << i - 8;
            ret |= moved;
            i -= 8;
        }
        return ret | this.parse8(i);
    }

    private int parse8(int i) throws IOException {
        if (this.readBitsRemaining == 0) {
            this.readBitsBuffer = this.readByte();
            this.readBitsRemaining = 8;
        }
        if (i > this.readBitsRemaining) {
            int resultRemaining = i - this.readBitsRemaining;
            int buffer = (this.readBitsBuffer & (int)(Math.pow(2.0, this.readBitsRemaining) - 1.0)) << resultRemaining;
            this.readBitsBuffer = this.readByte();
            this.readBitsRemaining = 8 - resultRemaining;
            int movedAndMasked = this.readBitsBuffer >>> this.readBitsRemaining & (int)(Math.pow(2.0, resultRemaining) - 1.0);
            return buffer | movedAndMasked;
        }
        this.readBitsRemaining -= i;
        return this.readBitsBuffer >>> this.readBitsRemaining & (int)(Math.pow(2.0, i) - 1.0);
    }

    @Override
    public int getReadBitsRemaining() {
        return this.readBitsRemaining;
    }

    @Override
    public double readFixedPoint1616() throws IOException {
        byte[] bytes = this.read(4);
        int result = 0;
        result |= bytes[0] << 24 & 0xFF000000;
        result |= bytes[1] << 16 & 0xFF0000;
        result |= bytes[2] << 8 & 0xFF00;
        return (double)(result |= bytes[3] & 0xFF) / 65536.0;
    }

    @Override
    public float readFixedPoint88() throws IOException {
        byte[] bytes = this.read(2);
        int result = 0;
        result = (short)(result | bytes[0] << 8 & 0xFF00);
        result = (short)(result | bytes[1] & 0xFF);
        return (float)result / 256.0f;
    }

    @Override
    public String readString(int length) throws IOException {
        byte[] buffer = new byte[length];
        this.read(buffer);
        try {
            return new String(buffer, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("JVM doesn't support UTF-8");
        }
    }

    @Override
    public byte[] read(int byteCount) throws IOException {
        byte[] result = new byte[byteCount];
        this.read(result);
        return result;
    }

    @Override
    public long skip(long n) throws IOException {
        this.position(this.position() + n);
        return n;
    }
}

