/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.local.metadata.extractor.embedded;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.serviio.config.Configuration;
import org.serviio.delivery.DeliveryContext;
import org.serviio.dlna.VideoContainer;
import org.serviio.external.FFMPEGWrapper;
import org.serviio.library.local.metadata.ImageDescriptor;
import org.serviio.library.local.metadata.TransportStreamTimestamp;
import org.serviio.library.local.metadata.VideoMetadata;
import org.serviio.library.local.metadata.extractor.InvalidMediaFormatException;
import org.serviio.library.metadata.FFmpegMetadataRetriever;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VideoExtractionStrategy {
    private static final Logger log = LoggerFactory.getLogger(VideoExtractionStrategy.class);

    public void extractMetadata(VideoMetadata metadata, File f) throws IOException, InvalidMediaFormatException {
        byte[] thumbnailImage;
        log.debug(String.format("Extracting metadata of video file: %s", f.getAbsolutePath()));
        FFmpegMetadataRetriever.retrieveMetadata(metadata, f.getPath(), DeliveryContext.local());
        this.setupTimestampForMPEG2TS(metadata, f);
        if (Configuration.isGenerateLocalThumbnailForVideos() && (thumbnailImage = FFMPEGWrapper.readVideoThumbnail(f, metadata.getDuration(), metadata.getVideoCodec(), metadata.getContainer())) != null && thumbnailImage.length > 0) {
            ImageDescriptor imageDesc = new ImageDescriptor(thumbnailImage, "image/jpeg");
            metadata.setCoverImage(imageDesc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupTimestampForMPEG2TS(VideoMetadata metadata, File f) throws IOException {
        TransportStreamTimestamp ts = null;
        if (metadata.getContainer() == VideoContainer.MPEG2TS) {
            RandomAccessFile raf = null;
            try {
                raf = new RandomAccessFile(f, "r");
                byte[] packetBuffer = new byte[197];
                raf.read(packetBuffer);
                if (packetBuffer[0] == 71) {
                    ts = TransportStreamTimestamp.NONE;
                } else if (packetBuffer[4] == 71 && packetBuffer[196] == 71) {
                    if (packetBuffer[0] == 0 && packetBuffer[1] == 0 && packetBuffer[2] == 0 && packetBuffer[3] == 0) {
                        ts = TransportStreamTimestamp.ZERO;
                        log.debug("Found ZERO value timestamp in the transport stream");
                    } else {
                        ts = TransportStreamTimestamp.VALID;
                        log.debug("Found VALID value timestamp in the transport stream");
                    }
                } else {
                    log.warn("Cannot find a valid timestamp in the transport stream packet, setting it to NONE");
                    ts = TransportStreamTimestamp.NONE;
                }
            }
            finally {
                if (raf != null) {
                    raf.close();
                }
            }
        }
        metadata.setTimestampType(ts);
    }
}

