/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.local.metadata.extractor.embedded;

import java.io.IOException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.imaging.ImageFormat;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.AudioHeader;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.vorbiscomment.VorbisCommentFieldKey;
import org.jaudiotagger.tag.vorbiscomment.VorbisCommentTag;
import org.serviio.dlna.AudioContainer;
import org.serviio.library.local.metadata.AudioMetadata;
import org.serviio.library.local.metadata.ImageDescriptor;
import org.serviio.library.local.metadata.extractor.InvalidMediaFormatException;
import org.serviio.library.local.metadata.extractor.embedded.AudioExtractionStrategy;
import org.serviio.util.ObjectValidator;

public class OGGExtractionStrategy
extends AudioExtractionStrategy {
    @Override
    public void extractMetadata(AudioMetadata metadata, AudioFile f, AudioHeader header, Tag tag) throws IOException, InvalidMediaFormatException {
        super.extractMetadata(metadata, f, header, tag);
        if (metadata.getCoverImage() == null) {
            ImageFormat imageFormat;
            VorbisCommentTag ovtag = (VorbisCommentTag)f.getTag();
            byte[] imageBytes = null;
            String mimetype = null;
            String imageData = ovtag.getFirst(VorbisCommentFieldKey.METADATA_BLOCK_PICTURE);
            if (ObjectValidator.isEmpty(imageData)) {
                imageData = ovtag.getFirst(VorbisCommentFieldKey.COVERART);
                mimetype = ovtag.getFirst(VorbisCommentFieldKey.COVERARTMIME);
                if (ObjectValidator.isNotEmpty(imageData)) {
                    try {
                        imageBytes = Base64.decodeBase64((byte[])imageData.getBytes("UTF-8"));
                    }
                    catch (Exception e) {}
                }
            } else {
                ImageDescriptor imageDesc = this.getImageDescriptorFromMetadataField(imageData);
                if (imageDesc != null) {
                    imageBytes = imageDesc.getImageData();
                    mimetype = imageDesc.getMimeType();
                }
            }
            if (imageBytes != null && this.isSupportedImageFormat(imageFormat = this.getImageFormat(imageBytes))) {
                if (ObjectValidator.isEmpty(mimetype)) {
                    mimetype = this.getMimeType(imageFormat);
                }
                ImageDescriptor imageDesc = new ImageDescriptor(imageBytes, mimetype);
                metadata.setCoverImage(imageDesc);
            }
        }
    }

    private ImageDescriptor getImageDescriptorFromMetadataField(String imageData) {
        try {
            byte[] imageStructure = Base64.decodeBase64((byte[])imageData.getBytes("UTF-8"));
            int offset = 4;
            byte[] result = new byte[4];
            System.arraycopy(imageStructure, offset, result, 0, 4);
            int mimeTypeLength = this.unsignedIntToLong(result);
            byte[] mimeTypeBytes = new byte[mimeTypeLength];
            System.arraycopy(imageStructure, offset += 4, mimeTypeBytes, 0, mimeTypeLength);
            String mimetype = new String(mimeTypeBytes);
            if (mimetype.equals("-->")) {
                return null;
            }
            System.arraycopy(imageStructure, offset += mimeTypeLength, result, 0, 4);
            int descLength = this.unsignedIntToLong(result);
            offset = offset + 4 + descLength;
            offset = offset + 4 + 4 + 4 + 4;
            System.arraycopy(imageStructure, offset, result, 0, 4);
            int imageBytesLength = this.unsignedIntToLong(result);
            byte[] imageBytes = new byte[imageBytesLength];
            System.arraycopy(imageStructure, offset += 4, imageBytes, 0, imageBytesLength);
            return new ImageDescriptor(imageBytes, mimetype);
        }
        catch (Exception e) {
            return null;
        }
    }

    private int unsignedIntToLong(byte[] b) {
        long l = 0L;
        l |= (long)(b[0] & 0xFF);
        l <<= 8;
        l |= (long)(b[1] & 0xFF);
        l <<= 8;
        l |= (long)(b[2] & 0xFF);
        l <<= 8;
        return Integer.parseInt(Long.toString(l |= (long)(b[3] & 0xFF)));
    }

    @Override
    protected AudioContainer getContainer() {
        return AudioContainer.OGG;
    }
}

