/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.local.metadata.extractor.embedded;

import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.AudioHeader;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.id3.ID3v1Tag;
import org.jaudiotagger.tag.id3.ID3v24Tag;
import org.jaudiotagger.tag.reference.GenreTypes;
import org.serviio.dlna.AudioContainer;
import org.serviio.library.local.metadata.AudioMetadata;
import org.serviio.library.local.metadata.extractor.InvalidMediaFormatException;
import org.serviio.library.local.metadata.extractor.embedded.AudioExtractionStrategy;
import org.serviio.util.CollectionUtils;
import org.serviio.util.NumberUtils;
import org.serviio.util.ObjectValidator;

public class MP3ExtractionStrategy
extends AudioExtractionStrategy {
    private static final Pattern yearPattern = Pattern.compile("([0-9]{4})");

    @Override
    public void extractMetadata(AudioMetadata metadata, AudioFile audioFile, AudioHeader header, Tag tag) throws IOException, InvalidMediaFormatException {
        MP3File mp3File = (MP3File)audioFile;
        if (mp3File.hasID3v1Tag()) {
            ID3v1Tag v1tag = mp3File.getID3v1Tag();
            super.extractMetadata(metadata, audioFile, header, (Tag)v1tag);
        } else {
            super.extractMetadata(metadata, audioFile, header, null);
        }
        if (mp3File.hasID3v2Tag()) {
            ID3v24Tag v24tag = mp3File.getID3v2TagAsv24();
            metadata.setDiscNumber(NumberUtils.stringToInt(v24tag.getFirst("TPOS")));
            if (ObjectValidator.isNotEmpty(v24tag.getFirst(FieldKey.GENRE))) {
                metadata.setGenre(this.getGenreString(v24tag.getFirst(FieldKey.GENRE)));
            }
            if (ObjectValidator.isEmpty(metadata.getGenre()) && ObjectValidator.isNotEmpty(v24tag.getFirst("TCON"))) {
                metadata.setGenre(this.getGenreString(v24tag.getFirst("TCON")));
            }
            if (ObjectValidator.isNotEmpty(v24tag.getFirst("TALB"))) {
                metadata.setAlbum(v24tag.getFirst("TALB"));
            }
            if (ObjectValidator.isNotEmpty(v24tag.getFirst("TPE2"))) {
                metadata.setAlbumArtist(v24tag.getFirst("TPE2"));
            }
            if (ObjectValidator.isNotEmpty(v24tag.getFirst("TPE1"))) {
                metadata.setArtist(v24tag.getFirst("TPE1"));
            }
            if (ObjectValidator.isNotEmpty(v24tag.getFirst("TDRC"))) {
                metadata.setReleaseYear(this.getReleaseYear(v24tag.getFirst("TDRC")));
            }
            if (ObjectValidator.isNotEmpty(v24tag.getFirst("TIT2"))) {
                metadata.setTitle(v24tag.getFirst("TIT2"));
            }
            if (ObjectValidator.isNotEmpty(v24tag.getFirst("TRCK"))) {
                metadata.setTrackNumber(this.fixTrackNumber(v24tag.getFirst("TRCK")));
            }
            if (metadata.getCoverImage() == null) {
                metadata.setCoverImage(this.findAlbumArt((Tag)v24tag));
            }
        }
    }

    @Override
    protected AudioContainer getContainer() {
        return AudioContainer.MP3;
    }

    protected String getGenreString(String genreDefinition) {
        ArrayList<String> resultGenre = new ArrayList<String>();
        String workingGenreDef = "";
        if (genreDefinition.indexOf(0) > -1) {
            String[] tokens;
            for (String token : tokens = genreDefinition.split("\\x00")) {
                workingGenreDef = NumberUtils.isNumber(token) ? String.format("%s(%s)", workingGenreDef, token.trim()) : String.format("%s%s", workingGenreDef, token.trim());
            }
        } else {
            workingGenreDef = genreDefinition.replaceAll("\\(\\(", "(");
        }
        if (NumberUtils.isNumber(workingGenreDef)) {
            workingGenreDef = String.format("(%s)", workingGenreDef);
        }
        int startPos = workingGenreDef.indexOf("(");
        int endPos = -1;
        if (startPos > -1) {
            while (startPos > -1) {
                if (endPos + 1 < startPos) {
                    resultGenre.add(workingGenreDef.substring(endPos + 1, startPos));
                }
                endPos = workingGenreDef.indexOf(")", startPos);
                String betweenBrackets = workingGenreDef.substring(startPos + 1, endPos);
                try {
                    Integer genreNumber = new Integer(betweenBrackets);
                    String genreName = GenreTypes.getInstanceOf().getValueForId(genreNumber.intValue());
                    if (ObjectValidator.isNotEmpty(genreName)) {
                        resultGenre.add(genreName);
                    }
                }
                catch (NumberFormatException e) {
                    String nonNumericReference = "";
                    nonNumericReference = betweenBrackets.equals("RX") ? "Remix" : (betweenBrackets.equals("CR") ? "Cover" : "(" + betweenBrackets + ")");
                    resultGenre.add(nonNumericReference);
                }
                startPos = workingGenreDef.indexOf("(", startPos + 1);
            }
            if (endPos + 1 < workingGenreDef.length()) {
                resultGenre.add(workingGenreDef.substring(endPos + 1));
            }
        } else {
            resultGenre.add(genreDefinition);
        }
        return CollectionUtils.listToCSV(resultGenre, " ", true);
    }

    protected Integer getReleaseYear(String year) {
        try {
            return Integer.valueOf(year);
        }
        catch (NumberFormatException e) {
            Matcher m = yearPattern.matcher(year);
            if (m.find() && m.groupCount() > 0) {
                return NumberUtils.stringToInt(m.group(1));
            }
            return null;
        }
    }
}

