/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.local.metadata.extractor.embedded;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.common.bytesource.ByteSource;
import org.apache.commons.imaging.common.bytesource.ByteSourceInputStream;
import org.apache.commons.imaging.formats.jpeg.JpegUtils;
import org.serviio.dlna.SamplingMode;

public class JPEGSamplingTypeReader {
    private static final int END_OF_IMAGE_MARKER = 65497;
    private static final String INVALID_JPEG_ERROR_MSG = "Not a Valid JPEG File";

    private JPEGSamplingTypeReader() {
    }

    public static JpegImageParams getJpegImageData(InputStream is, String filename) throws IOException, ImageReadException {
        final JpegImageParams imageParams = new JpegImageParams(SamplingMode.UNKNOWN);
        JpegUtils.Visitor visitor = new JpegUtils.Visitor(){

            public boolean beginSOS() {
                return false;
            }

            public void visitSOS(int marker, byte[] markerBytes, byte[] imageData) {
            }

            public boolean visitSegment(int marker, byte[] markerBytes, int markerLength, byte[] markerLengthBytes, byte[] segmentData) throws ImageReadException, IOException {
                if (marker == 65497) {
                    return false;
                }
                if (marker == 65472 || marker == 65474) {
                    this.parseSOFSegment(markerLength, segmentData);
                }
                return true;
            }

            private void parseSOFSegment(int markerLength, byte[] segmentData) throws IOException, ImageReadException {
                int toBeProcessed = markerLength - 2;
                byte numComponents = 0;
                ByteArrayInputStream is = new ByteArrayInputStream(segmentData);
                if (toBeProcessed <= 6) {
                    return;
                }
                ByteSourceInputStream.skipBytes((InputStream)is, (long)5L, (String)JPEGSamplingTypeReader.INVALID_JPEG_ERROR_MSG);
                numComponents = ByteSourceInputStream.readByte((String)"Number_of_components", (InputStream)is, (String)"Unable to read Number of components from SOF marker");
                if (numComponents == 3 && (toBeProcessed -= 6) == 9) {
                    ByteSourceInputStream.skipBytes((InputStream)is, (long)1L, (String)JPEGSamplingTypeReader.INVALID_JPEG_ERROR_MSG);
                    imageParams.setSamplingMode(ByteSourceInputStream.readByte((String)"Sampling Factors", (InputStream)is, (String)"Unable to read the sampling factor from the 'Y' channel component spec"));
                    ByteSourceInputStream.readByte((String)"Quantization Table Index", (InputStream)is, (String)"Unable to read Quantization table index of 'Y' channel");
                    ByteSourceInputStream.skipBytes((InputStream)is, (long)2L, (String)JPEGSamplingTypeReader.INVALID_JPEG_ERROR_MSG);
                    ByteSourceInputStream.readByte((String)"Quantization Table Index", (InputStream)is, (String)"Unable to read Quantization table index of 'Cb' Channel");
                }
            }
        };
        new JpegUtils().traverseJFIF((ByteSource)new ByteSourceInputStream(is, filename), visitor);
        return imageParams;
    }

    public static class JpegImageParams {
        private SamplingMode mode;

        JpegImageParams(SamplingMode mode) {
            this.mode = mode;
        }

        public SamplingMode getSamplingMode() {
            return this.mode;
        }

        public void setSamplingMode(int samplingMode) {
            for (SamplingMode mode : SamplingMode.values()) {
                if (samplingMode != mode.getModeValue()) continue;
                this.mode = mode;
                return;
            }
            this.mode = SamplingMode.UNKNOWN;
        }
    }
}

