/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.local.metadata.extractor.embedded;

import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.common.IImageMetadata;
import org.apache.commons.imaging.common.bytesource.ByteSource;
import org.apache.commons.imaging.formats.jpeg.JpegImageMetadata;
import org.apache.commons.imaging.formats.tiff.TiffField;
import org.apache.commons.imaging.formats.tiff.constants.TiffConstants;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfo;
import org.serviio.dlna.ImageContainer;
import org.serviio.dlna.SamplingMode;
import org.serviio.library.local.metadata.ImageMetadata;
import org.serviio.library.local.metadata.extractor.InvalidMediaFormatException;
import org.serviio.library.local.metadata.extractor.embedded.ImageExtractionStrategy;
import org.serviio.library.local.metadata.extractor.embedded.JPEGSamplingTypeReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPEGExtractionStrategy
extends ImageExtractionStrategy {
    private static DateFormat exifDF = new SimpleDateFormat("''yyyy:MM:dd HH:mm:ss''");
    private static final Logger log = LoggerFactory.getLogger(JPEGExtractionStrategy.class);

    @Override
    public void extractMetadata(ImageMetadata metadata, ByteSource f) throws IOException, InvalidMediaFormatException {
        super.extractMetadata(metadata, f);
        try {
            IImageMetadata imageMetadata = Imaging.getMetadata((InputStream)f.getInputStream(), (String)f.getFilename());
            if (imageMetadata != null && imageMetadata instanceof JpegImageMetadata) {
                JpegImageMetadata jpegMetadata = (JpegImageMetadata)imageMetadata;
                TiffField dateField = jpegMetadata.findEXIFValue((TagInfo)TiffConstants.EXIF_TAG_DATE_TIME_ORIGINAL);
                if (dateField == null) {
                    dateField = jpegMetadata.findEXIFValue((TagInfo)TiffConstants.TIFF_TAG_DATE_TIME);
                }
                Date createdDate = dateField != null ? exifDF.parse(dateField.getValueDescription()) : null;
                metadata.setDate(createdDate);
                metadata.setExifRotation(this.getRotation(jpegMetadata));
            }
            try {
                JPEGSamplingTypeReader.JpegImageParams params = JPEGSamplingTypeReader.getJpegImageData(f.getInputStream(), f.getFilename());
                metadata.setChromaSubsampling(params.getSamplingMode());
            }
            catch (Exception e) {
                metadata.setChromaSubsampling(SamplingMode.UNKNOWN);
            }
        }
        catch (ImageReadException e) {
            log.debug(String.format("Cannot read file %s for metadata extraction. Message: %s", f.getFilename(), e.getMessage()));
        }
        catch (ParseException e) {
        }
        catch (OutOfMemoryError e) {
            log.debug(String.format("Cannot get metadata of file %s because of OutOfMemory error. The file is dodgy, but will still be added to the library.", f.getFilename()));
        }
        catch (IOException e) {
            log.debug(String.format("Cannot read EXIF metadata for file %s. Message: %s", f.getFilename(), e.getMessage()));
        }
    }

    @Override
    protected ImageContainer getContainer() {
        return ImageContainer.JPEG;
    }

    protected Integer getRotation(JpegImageMetadata jpegMetadata) throws ImageReadException {
        TiffField rotation = jpegMetadata.findEXIFValue((TagInfo)TiffConstants.TIFF_TAG_ORIENTATION);
        if (rotation != null) {
            if (rotation.getIntValue() == 3) {
                return 180;
            }
            if (rotation.getIntValue() == 8) {
                return 270;
            }
            if (rotation.getIntValue() == 6) {
                return 90;
            }
            return 0;
        }
        return 0;
    }
}

