/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.local.metadata.extractor.embedded;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.imaging.ImageInfo;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.common.bytesource.ByteSource;
import org.serviio.dlna.ImageContainer;
import org.serviio.library.local.metadata.ImageMetadata;
import org.serviio.library.local.metadata.extractor.InvalidMediaFormatException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ImageExtractionStrategy {
    private static final Logger log = LoggerFactory.getLogger(ImageExtractionStrategy.class);

    public void extractMetadata(ImageMetadata metadata, ByteSource f) throws IOException, InvalidMediaFormatException {
        log.debug(String.format("Extracting metadata of image file: %s", f.getFilename()));
        try {
            ImageInfo imageInfo = Imaging.getImageInfo((InputStream)f.getInputStream(), (String)f.getFilename());
            if (imageInfo != null) {
                metadata.setWidth(imageInfo.getWidth());
                metadata.setHeight(imageInfo.getHeight());
                metadata.setColorDepth(imageInfo.getBitsPerPixel());
            }
            metadata.setContainer(this.getContainer());
        }
        catch (ImageReadException e) {
            throw new IOException(String.format("Cannot read file %s for metadata extraction: %s", f.getFilename(), e.getMessage()), e);
        }
        catch (OutOfMemoryError e) {
            throw new IOException(String.format("Cannot read file %s for metadata extraction because of out-of-memory error", f.getFilename()), e);
        }
    }

    protected abstract ImageContainer getContainer();
}

