/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.local.metadata.extractor.embedded;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.AudioFileIO;
import org.jaudiotagger.audio.AudioHeader;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import org.jaudiotagger.audio.exceptions.ReadOnlyFileException;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.audio.mp4.Mp4AudioHeader;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagException;
import org.jaudiotagger.tag.flac.FlacTag;
import org.jaudiotagger.tag.vorbiscomment.VorbisCommentTag;
import org.serviio.delivery.DeliveryContext;
import org.serviio.library.entities.MediaItem;
import org.serviio.library.entities.MetadataDescriptor;
import org.serviio.library.entities.Repository;
import org.serviio.library.local.ContentType;
import org.serviio.library.local.metadata.AudioMetadata;
import org.serviio.library.local.metadata.ImageMetadata;
import org.serviio.library.local.metadata.LocalItemMetadata;
import org.serviio.library.local.metadata.VideoMetadata;
import org.serviio.library.local.metadata.extractor.ExtractorType;
import org.serviio.library.local.metadata.extractor.InvalidMediaFormatException;
import org.serviio.library.local.metadata.extractor.MetadataExtractor;
import org.serviio.library.local.metadata.extractor.MetadataFile;
import org.serviio.library.local.metadata.extractor.MetadataSourceNotAccessibleException;
import org.serviio.library.local.metadata.extractor.embedded.AudioExtractionStrategy;
import org.serviio.library.local.metadata.extractor.embedded.FLACExtractionStrategy;
import org.serviio.library.local.metadata.extractor.embedded.MP3ExtractionStrategy;
import org.serviio.library.local.metadata.extractor.embedded.MP4ExtractionStrategy;
import org.serviio.library.local.metadata.extractor.embedded.OGGExtractionStrategy;
import org.serviio.library.local.metadata.extractor.embedded.VideoExtractionStrategy;
import org.serviio.library.local.metadata.extractor.embedded.WMAExtractionStrategy;
import org.serviio.library.metadata.FFmpegMetadataRetriever;
import org.serviio.library.metadata.ImageMetadataRetriever;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.util.FileUtils;
import org.serviio.util.ObjectValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedMetadataExtractor
extends MetadataExtractor {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedMetadataExtractor.class);
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("dd/MM/yyyy");

    @Override
    public ExtractorType getExtractorType() {
        return ExtractorType.EMBEDDED;
    }

    @Override
    public boolean isMetadataUpdated(File mediaFile, MediaItem mediaItem, MetadataDescriptor metadataDescriptor) {
        if (mediaFile != null && mediaFile.exists() && metadataDescriptor != null) {
            Date mediaFileDate = FileUtils.getLastModifiedDate(mediaFile);
            return metadataDescriptor.getDateUpdated() == null || mediaFileDate.after(metadataDescriptor.getDateUpdated());
        }
        return false;
    }

    @Override
    protected MetadataFile getMetadataFile(File mediaFile, MediaFileType fileType, Repository repository) throws IOException, MetadataSourceNotAccessibleException {
        if (mediaFile.exists() && mediaFile.canRead()) {
            return new MetadataFile(this.getExtractorType(), FileUtils.getLastModifiedDate(mediaFile), null, mediaFile);
        }
        throw new IOException(String.format("File %s cannot be read to extract metadata", mediaFile.getAbsolutePath()));
    }

    @Override
    protected void retrieveMetadata(MetadataFile metadataDescriptor, LocalItemMetadata metadata) throws IOException, InvalidMediaFormatException, MetadataSourceNotAccessibleException {
        File mediaFile = (File)metadataDescriptor.getExtractable();
        if (metadata instanceof AudioMetadata) {
            this.retrieveAudioMetadata(mediaFile, metadata);
        } else if (metadata instanceof ImageMetadata) {
            this.retrieveImageMetadata(mediaFile, metadata);
        } else {
            this.retrieveVideoMetadata(mediaFile, metadata);
        }
        if (ObjectValidator.isEmpty(metadata.getTitle())) {
            metadata.setTitle(FileUtils.getFileNameWithoutExtension(mediaFile));
        }
        if (metadata.getDate() == null) {
            metadata.setDate(FileUtils.getLastModifiedDate(mediaFile));
        }
        metadata.setFileSize(mediaFile.length());
        metadata.setFilePath(FileUtils.getProperFilePath(mediaFile));
    }

    protected void retrieveAudioMetadata(File mediaFile, LocalItemMetadata metadata) throws IOException, InvalidMediaFormatException {
        AudioMetadata aMetadata = (AudioMetadata)metadata;
        try {
            AudioFile audioFile = AudioFileIO.read((File)mediaFile);
            Tag tag = audioFile.getTag();
            AudioHeader header = audioFile.getAudioHeader();
            AudioExtractionStrategy strategy = null;
            if (audioFile instanceof MP3File) {
                strategy = new MP3ExtractionStrategy();
            } else if (header.getFormat().startsWith("ASF")) {
                strategy = new WMAExtractionStrategy();
            } else if (header instanceof Mp4AudioHeader) {
                strategy = new MP4ExtractionStrategy();
            } else if (tag instanceof FlacTag) {
                strategy = new FLACExtractionStrategy();
            } else if (tag instanceof VorbisCommentTag) {
                strategy = new OGGExtractionStrategy();
            } else {
                throw new InvalidMediaFormatException(String.format("File %s has unsupported audio format", mediaFile.getName()));
            }
            ((AudioExtractionStrategy)strategy).extractMetadata(aMetadata, audioFile, header, tag);
        }
        catch (CannotReadException e) {
            FFmpegMetadataRetriever.retrieveAudioMetadata(aMetadata, FileUtils.getProperFilePath(mediaFile), DeliveryContext.local());
        }
        catch (InvalidAudioFrameException e) {
            throw new InvalidMediaFormatException(e);
        }
        catch (TagException e) {
            throw new InvalidMediaFormatException(e);
        }
        catch (ReadOnlyFileException e) {
            // empty catch block
        }
        if (aMetadata.getReleaseYear() != null) {
            metadata.setDate(this.yearToDate(aMetadata.getReleaseYear()));
        }
    }

    protected void retrieveImageMetadata(File mediaFile, LocalItemMetadata metadata) throws IOException, InvalidMediaFormatException {
        ImageMetadataRetriever.retrieveImageMetadata((ImageMetadata)metadata, FileUtils.getProperFilePath(mediaFile), true);
    }

    protected void retrieveVideoMetadata(File mediaFile, LocalItemMetadata metadata) throws IOException, InvalidMediaFormatException {
        VideoExtractionStrategy strategy = new VideoExtractionStrategy();
        strategy.extractMetadata((VideoMetadata)metadata, mediaFile);
        ((VideoMetadata)metadata).setContentType(ContentType.UNKNOWN);
    }

    private Date yearToDate(Integer year) {
        String dateStr = "01/01/" + year.toString();
        try {
            return DATE_FORMAT.parse(dateStr);
        }
        catch (ParseException e) {
            log.debug(String.format("Could not parse year %s to date", year));
            return null;
        }
    }
}

