/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.library.local.metadata.extractor.embedded;

import java.io.IOException;
import java.util.List;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.Imaging;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.AudioHeader;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.datatype.Artwork;
import org.serviio.dlna.AudioContainer;
import org.serviio.library.local.metadata.AudioMetadata;
import org.serviio.library.local.metadata.ImageDescriptor;
import org.serviio.library.local.metadata.extractor.InvalidMediaFormatException;
import org.serviio.util.NumberUtils;
import org.serviio.util.ObjectValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AudioExtractionStrategy {
    private static final Logger log = LoggerFactory.getLogger(AudioExtractionStrategy.class);

    public void extractMetadata(AudioMetadata metadata, AudioFile f, AudioHeader header, Tag tag) throws IOException, InvalidMediaFormatException {
        log.debug(String.format("Extracting metadata of audio file: %s", f.getFile().getAbsolutePath()));
        if (tag != null) {
            metadata.setAlbum(this.getKey(tag, FieldKey.ALBUM));
            metadata.setAuthor(this.getKey(tag, FieldKey.COMPOSER));
            metadata.setArtist(this.getKey(tag, FieldKey.ARTIST));
            metadata.setReleaseYear(NumberUtils.stringToInt(tag.getFirst(FieldKey.YEAR)));
            metadata.setTitle(this.getKey(tag, FieldKey.TITLE));
            metadata.setTrackNumber(this.fixTrackNumber(this.getKey(tag, FieldKey.TRACK)));
            metadata.setAlbumArtist(this.getKey(tag, FieldKey.ALBUM_ARTIST));
            metadata.setDescription(this.getKey(tag, FieldKey.COMMENT));
            metadata.setGenre(this.getKey(tag, FieldKey.GENRE));
            metadata.setDiscNumber(NumberUtils.stringToInt(tag.getFirst(FieldKey.DISC_NO)));
            metadata.setCoverImage(this.findAlbumArt(tag));
        }
        if (header != null) {
            metadata.setDuration(header.getTrackLength());
            long bitrate = header.getBitRateAsNumber();
            try {
                metadata.setBitrate(Integer.parseInt(Long.toString(bitrate)));
            }
            catch (NumberFormatException e) {
                log.debug(String.format("Invalid bitrate: %s", bitrate));
            }
            metadata.setChannels(this.getNumberOfChannels(header));
            metadata.setSampleFrequency(header.getSampleRateAsNumber());
        }
        metadata.setContainer(this.getContainer());
    }

    private String getKey(Tag tag, FieldKey key) {
        try {
            return ObjectValidator.isNotEmpty(tag.getFirst(key)) ? tag.getFirst(key) : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected ImageDescriptor findAlbumArt(Tag tag) {
        List albumArtList = tag.getArtworkList();
        if (albumArtList != null && !albumArtList.isEmpty()) {
            for (Artwork albumArt : albumArtList) {
                byte[] imageBuffer;
                if (!ObjectValidator.isEmpty(albumArt.getImageUrl()) || !this.isSupportedImageFormat(imageBuffer = albumArt.getBinaryData())) continue;
                ImageDescriptor imageDesc = new ImageDescriptor(imageBuffer, albumArt.getMimeType());
                return imageDesc;
            }
        }
        return null;
    }

    protected Integer fixTrackNumber(String trackNumber) {
        try {
            int slashPos;
            if (trackNumber != null && (slashPos = trackNumber.indexOf("/")) > -1) {
                trackNumber = trackNumber.substring(0, slashPos);
            }
            return NumberUtils.stringToInt(trackNumber);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected abstract AudioContainer getContainer();

    protected Integer getNumberOfChannels(AudioHeader header) {
        String channels = header.getChannels();
        if (channels != null) {
            if (channels.equals("1") || channels.equalsIgnoreCase("Mono")) {
                return 1;
            }
            if (channels.equals("2") || channels.equalsIgnoreCase("Stereo") || channels.equalsIgnoreCase("Joint Stereo")) {
                return 2;
            }
            return 0;
        }
        return null;
    }

    protected boolean isSupportedImageFormat(byte[] imageBytes) {
        ImageFormat imageFormat = this.getImageFormat(imageBytes);
        return this.isSupportedImageFormat(imageFormat);
    }

    protected ImageFormat getImageFormat(byte[] imageBytes) {
        try {
            ImageFormat imageFormat = Imaging.guessFormat((byte[])imageBytes);
            return imageFormat;
        }
        catch (Exception e) {
            log.debug("Cannot get image format: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    protected boolean isSupportedImageFormat(ImageFormat imageFormat) {
        return imageFormat != null && !imageFormat.equals((Object)ImageFormat.IMAGE_FORMAT_UNKNOWN);
    }

    protected String getMimeType(ImageFormat imageFormat) {
        if (imageFormat == ImageFormat.IMAGE_FORMAT_GIF) {
            return "image/gif";
        }
        if (imageFormat == ImageFormat.IMAGE_FORMAT_JPEG) {
            return "image/jpeg";
        }
        if (imageFormat == ImageFormat.IMAGE_FORMAT_PNG) {
            return "image/png";
        }
        log.debug("Cannot guess mime type of image format: " + imageFormat.toString());
        return null;
    }
}

